/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml.ext;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.apache.ws.security.saml.ext.builder.SAML1ComponentBuilder;
import org.apache.ws.security.saml.ext.builder.SAML2ComponentBuilder;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.UUIDGenerator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.ConfirmationMethod;
import org.opensaml.saml1.core.SubjectConfirmation;
import org.opensaml.saml1.core.SubjectStatement;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Subject;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionWrapper {
    private static final Log LOG = LogFactory.getLog(AssertionWrapper.class);
    private XMLObject xmlObject = null;
    private org.opensaml.saml1.core.Assertion saml1 = null;
    private Assertion saml2 = null;
    private SAMLVersion samlVersion;
    private CallbackHandler samlCallbackHandler = null;
    private Element assertionElement;
    private SAMLKeyInfo subjectKeyInfo;
    private SAMLKeyInfo signatureKeyInfo;
    private final String defaultCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final String defaultRSASignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private final String defaultDSASignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private final boolean fromDOM;

    public AssertionWrapper(Element element) throws WSSecurityException {
        OpenSAMLUtil.initSamlEngine();
        this.parseElement(element);
        this.fromDOM = true;
    }

    public AssertionWrapper(Assertion saml2) {
        this((XMLObject)saml2);
    }

    public AssertionWrapper(org.opensaml.saml1.core.Assertion saml1) {
        this((XMLObject)saml1);
    }

    public AssertionWrapper(XMLObject xmlObject) {
        OpenSAMLUtil.initSamlEngine();
        this.xmlObject = xmlObject;
        if (xmlObject instanceof org.opensaml.saml1.core.Assertion) {
            this.saml1 = (org.opensaml.saml1.core.Assertion)xmlObject;
            this.samlVersion = SAMLVersion.VERSION_11;
        } else if (xmlObject instanceof Assertion) {
            this.saml2 = (Assertion)xmlObject;
            this.samlVersion = SAMLVersion.VERSION_20;
        } else {
            LOG.error((Object)("AssertionWrapper: found unexpected type " + (xmlObject != null ? xmlObject.getClass().getName() : null)));
        }
        this.fromDOM = false;
    }

    public AssertionWrapper(SAMLParms parms) throws WSSecurityException {
        OpenSAMLUtil.initSamlEngine();
        Callback[] samlCallbacks = new SAMLCallback[]{new SAMLCallback()};
        try {
            this.samlCallbackHandler = parms.getCallbackHandler();
            this.samlCallbackHandler.handle(samlCallbacks);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while creating SAML assertion wrapper", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new IllegalStateException("UnsupportedCallbackException while creating SAML assertion wrapper", e);
        }
        if (((SAMLCallback)samlCallbacks[0]).getAssertionElement() != null) {
            this.parseElement(((SAMLCallback)samlCallbacks[0]).getAssertionElement());
            this.fromDOM = true;
        } else {
            this.parseCallback((SAMLCallback)samlCallbacks[0], parms);
            this.fromDOM = false;
        }
    }

    public org.opensaml.saml1.core.Assertion getSaml1() {
        return this.saml1;
    }

    public Assertion getSaml2() {
        return this.saml2;
    }

    public XMLObject getXmlObject() {
        return this.xmlObject;
    }

    public boolean isCreated() {
        return this.saml1 != null || this.saml2 != null;
    }

    public Element toDOM(Document doc) throws WSSecurityException {
        if (this.fromDOM && this.assertionElement != null) {
            this.parseElement(this.assertionElement);
            if (doc != null) {
                return (Element)doc.importNode(this.assertionElement, true);
            }
            return this.assertionElement;
        }
        this.assertionElement = OpenSAMLUtil.toDom(this.xmlObject, doc);
        return this.assertionElement;
    }

    public String assertionToString() throws WSSecurityException {
        if (this.assertionElement == null) {
            Element element = this.toDOM(null);
            return DOM2Writer.nodeToString(element);
        }
        return DOM2Writer.nodeToString(this.assertionElement);
    }

    public String getId() {
        String id = null;
        if (this.saml2 != null) {
            id = this.saml2.getID();
        } else if (this.saml1 != null) {
            id = this.saml1.getID();
        } else {
            LOG.error((Object)"AssertionWrapper: unable to return ID - no saml assertion object");
        }
        if (id == null || id.length() == 0) {
            LOG.error((Object)"AssertionWrapper: ID was null, seeting a new ID value");
            id = "_" + UUIDGenerator.getUUID();
            if (this.saml2 != null) {
                this.saml2.setID(id);
            } else if (this.saml1 != null) {
                this.saml1.setID(id);
            }
        }
        return id;
    }

    public String getIssuerString() {
        if (this.saml2 != null && this.saml2.getIssuer() != null) {
            return this.saml2.getIssuer().getValue();
        }
        if (this.saml1 != null) {
            return this.saml1.getIssuer();
        }
        LOG.error((Object)"AssertionWrapper: unable to return Issuer string - no saml assertion object or issuer is null");
        return null;
    }

    public List<String> getConfirmationMethods() {
        ArrayList<String> methods;
        block5: {
            block4: {
                methods = new ArrayList<String>();
                if (this.saml2 == null) break block4;
                Subject subject = this.saml2.getSubject();
                List confirmations = subject.getSubjectConfirmations();
                for (org.opensaml.saml2.core.SubjectConfirmation confirmation : confirmations) {
                    methods.add(confirmation.getMethod());
                }
                break block5;
            }
            if (this.saml1 == null) break block5;
            ArrayList subjectStatements = new ArrayList();
            subjectStatements.addAll(this.saml1.getSubjectStatements());
            subjectStatements.addAll(this.saml1.getAuthenticationStatements());
            subjectStatements.addAll(this.saml1.getAttributeStatements());
            subjectStatements.addAll(this.saml1.getAuthorizationDecisionStatements());
            for (SubjectStatement subjectStatement : subjectStatements) {
                SubjectConfirmation confirmation;
                org.opensaml.saml1.core.Subject subject = subjectStatement.getSubject();
                if (subject == null || (confirmation = subject.getSubjectConfirmation()) == null) continue;
                XMLObject data = confirmation.getSubjectConfirmationData();
                if (data instanceof ConfirmationMethod) {
                    ConfirmationMethod method = (ConfirmationMethod)data;
                    methods.add(method.getConfirmationMethod());
                }
                List confirmationMethods = confirmation.getConfirmationMethods();
                for (ConfirmationMethod confirmationMethod : confirmationMethods) {
                    methods.add(confirmationMethod.getConfirmationMethod());
                }
            }
        }
        return methods;
    }

    public boolean isSigned() {
        if (this.saml2 != null) {
            return this.saml2.isSigned() || this.saml2.getSignature() != null;
        }
        if (this.saml1 != null) {
            return this.saml1.isSigned() || this.saml1.getSignature() != null;
        }
        return false;
    }

    public void setSignature(Signature signature) {
        if (this.xmlObject instanceof SignableSAMLObject) {
            SignableSAMLObject signableObject = (SignableSAMLObject)this.xmlObject;
            signableObject.setSignature(signature);
            signableObject.releaseDOM();
            signableObject.releaseChildrenDOM(true);
        } else {
            LOG.error((Object)("Attempt to sign an unsignable object " + this.xmlObject.getClass().getName()));
        }
    }

    public void signAssertion(String issuerKeyName, String issuerKeyPassword, Crypto issuerCrypto, boolean sendKeyValue) throws WSSecurityException {
        this.signAssertion(issuerKeyName, issuerKeyPassword, issuerCrypto, sendKeyValue, "http://www.w3.org/2001/10/xml-exc-c14n#", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    public void signAssertion(String issuerKeyName, String issuerKeyPassword, Crypto issuerCrypto, boolean sendKeyValue, String canonicalizationAlgorithm, String signatureAlgorithm) throws WSSecurityException {
        Signature signature = OpenSAMLUtil.buildSignature();
        signature.setCanonicalizationAlgorithm(canonicalizationAlgorithm);
        LOG.debug((Object)("Using Canonicalization algorithm " + canonicalizationAlgorithm));
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(issuerKeyName);
        X509Certificate[] issuerCerts = issuerCrypto.getX509Certificates(cryptoType);
        if (issuerCerts == null) {
            throw new WSSecurityException("No issuer certs were found to sign the SAML Assertion using issuer name: " + issuerKeyName);
        }
        String sigAlgo = signatureAlgorithm;
        String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
        }
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        LOG.debug((Object)("Using Signature algorithm " + sigAlgo));
        PrivateKey privateKey = null;
        try {
            privateKey = issuerCrypto.getPrivateKey(issuerKeyName, issuerKeyPassword);
        }
        catch (Exception ex) {
            throw new WSSecurityException(ex.getMessage(), ex);
        }
        signature.setSignatureAlgorithm(sigAlgo);
        BasicX509Credential signingCredential = new BasicX509Credential();
        signingCredential.setEntityCertificate(issuerCerts[0]);
        signingCredential.setPrivateKey(privateKey);
        signature.setSigningCredential((Credential)signingCredential);
        X509KeyInfoGeneratorFactory kiFactory = new X509KeyInfoGeneratorFactory();
        if (sendKeyValue) {
            kiFactory.setEmitPublicKeyValue(true);
        } else {
            kiFactory.setEmitEntityCertificate(true);
        }
        try {
            KeyInfo keyInfo = kiFactory.newInstance().generate((Credential)signingCredential);
            signature.setKeyInfo(keyInfo);
        }
        catch (SecurityException ex) {
            throw new WSSecurityException("Error generating KeyInfo from signing credential", ex);
        }
        this.setSignature(signature);
    }

    public void verifySignature(RequestData data, WSDocInfo docInfo) throws WSSecurityException {
        Signature sig = null;
        if (this.saml2 != null && this.saml2.getSignature() != null) {
            sig = this.saml2.getSignature();
        } else if (this.saml1 != null && this.saml1.getSignature() != null) {
            sig = this.saml1.getSignature();
        }
        if (sig != null) {
            KeyInfo keyInfo = sig.getKeyInfo();
            SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo(keyInfo.getDOM(), data, docInfo, data.getWssConfig().isWsiBSPCompliant());
            if (samlKeyInfo == null) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
            try {
                validator.validate(sig);
            }
            catch (ValidationException ex) {
                throw new WSSecurityException("SAML signature validation failed", ex);
            }
            BasicX509Credential credential = new BasicX509Credential();
            if (samlKeyInfo.getCerts() != null) {
                credential.setEntityCertificate(samlKeyInfo.getCerts()[0]);
            } else if (samlKeyInfo.getPublicKey() != null) {
                credential.setPublicKey(samlKeyInfo.getPublicKey());
            } else {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            SignatureValidator sigValidator = new SignatureValidator((Credential)credential);
            try {
                sigValidator.validate(sig);
            }
            catch (ValidationException ex) {
                throw new WSSecurityException("SAML signature validation failed", ex);
            }
            this.signatureKeyInfo = samlKeyInfo;
        } else {
            LOG.debug((Object)"AssertionWrapper: no signature to validate");
        }
    }

    public void parseHOKSubject(RequestData data, WSDocInfo docInfo) throws WSSecurityException {
        String confirmMethod = null;
        List<String> methods = this.getConfirmationMethods();
        if (methods != null && methods.size() > 0) {
            confirmMethod = methods.get(0);
        }
        if (OpenSAMLUtil.isMethodHolderOfKey(confirmMethod)) {
            if (this.saml1 != null) {
                this.subjectKeyInfo = SAMLUtil.getCredentialFromSubject(this.saml1, data, docInfo, data.getWssConfig().isWsiBSPCompliant());
            } else if (this.saml2 != null) {
                this.subjectKeyInfo = SAMLUtil.getCredentialFromSubject(this.saml2, data, docInfo, data.getWssConfig().isWsiBSPCompliant());
            }
        }
    }

    public SAMLVersion getSamlVersion() {
        if (this.samlVersion == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The SAML version was null in getSamlVersion(). Recomputing SAML version...");
            }
            if (this.saml1 != null && this.saml2 == null) {
                this.samlVersion = SAMLVersion.VERSION_11;
            } else if (this.saml1 == null && this.saml2 != null) {
                this.samlVersion = SAMLVersion.VERSION_20;
            } else {
                throw new IllegalStateException("Could not determine the SAML version number. Check your configuration and try again.");
            }
        }
        return this.samlVersion;
    }

    public Element getElement() {
        return this.assertionElement;
    }

    public SAMLKeyInfo getSignatureKeyInfo() {
        return this.signatureKeyInfo;
    }

    public SAMLKeyInfo getSubjectKeyInfo() {
        return this.subjectKeyInfo;
    }

    public byte[] getSignatureValue() throws WSSecurityException {
        Signature sig = null;
        if (this.saml2 != null && this.saml2.getSignature() != null) {
            sig = this.saml2.getSignature();
        } else if (this.saml1 != null && this.saml1.getSignature() != null) {
            sig = this.saml1.getSignature();
        }
        if (sig != null) {
            Element signatureElement = sig.getDOM();
            try {
                XMLSignature xmlSignature = new XMLSignature(signatureElement, "");
                return xmlSignature.getSignatureValue();
            }
            catch (XMLSignatureException e) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
            }
            catch (XMLSecurityException e) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
            }
        }
        return null;
    }

    private void parseElement(Element element) throws WSSecurityException {
        this.xmlObject = OpenSAMLUtil.fromDom(element);
        if (this.xmlObject instanceof org.opensaml.saml1.core.Assertion) {
            this.saml1 = (org.opensaml.saml1.core.Assertion)this.xmlObject;
            this.samlVersion = SAMLVersion.VERSION_11;
        } else if (this.xmlObject instanceof Assertion) {
            this.saml2 = (Assertion)this.xmlObject;
            this.samlVersion = SAMLVersion.VERSION_20;
        } else {
            LOG.error((Object)("AssertionWrapper: found unexpected type " + (this.xmlObject != null ? this.xmlObject.getClass().getName() : this.xmlObject)));
        }
        this.assertionElement = element;
    }

    private void parseCallback(SAMLCallback samlCallback, SAMLParms parms) throws WSSecurityException {
        String issuer;
        this.samlVersion = samlCallback.getSamlVersion();
        if (this.samlVersion == null) {
            this.samlVersion = parms.getSAMLVersion();
        }
        if ((issuer = samlCallback.getIssuer()) == null && parms.getIssuer() != null) {
            issuer = parms.getIssuer();
        }
        if (this.samlVersion.equals(SAMLVersion.VERSION_11)) {
            this.saml1 = SAML1ComponentBuilder.createSamlv1Assertion(issuer);
            try {
                List<AuthenticationStatement> authenticationStatements = SAML1ComponentBuilder.createSamlv1AuthenticationStatement(samlCallback.getAuthenticationStatementData());
                this.saml1.getAuthenticationStatements().addAll(authenticationStatements);
                List<AttributeStatement> attributeStatements = SAML1ComponentBuilder.createSamlv1AttributeStatement(samlCallback.getAttributeStatementData());
                this.saml1.getAttributeStatements().addAll(attributeStatements);
                List<AuthorizationDecisionStatement> authDecisionStatements = SAML1ComponentBuilder.createSamlv1AuthorizationDecisionStatement(samlCallback.getAuthDecisionStatementData());
                this.saml1.getAuthorizationDecisionStatements().addAll(authDecisionStatements);
                Conditions conditions = SAML1ComponentBuilder.createSamlv1Conditions(samlCallback.getConditions());
                this.saml1.setConditions(conditions);
            }
            catch (SecurityException ex) {
                throw new WSSecurityException("Error generating KeyInfo from signing credential", ex);
            }
            this.xmlObject = this.saml1;
        } else if (this.samlVersion.equals(SAMLVersion.VERSION_20)) {
            this.saml2 = SAML2ComponentBuilder.createAssertion();
            Issuer samlIssuer = SAML2ComponentBuilder.createIssuer(issuer);
            List<AuthnStatement> authnStatements = SAML2ComponentBuilder.createAuthnStatement(samlCallback.getAuthenticationStatementData());
            this.saml2.getAuthnStatements().addAll(authnStatements);
            List<org.opensaml.saml2.core.AttributeStatement> attributeStatements = SAML2ComponentBuilder.createAttributeStatement(samlCallback.getAttributeStatementData());
            this.saml2.getAttributeStatements().addAll(attributeStatements);
            List<AuthzDecisionStatement> authDecisionStatements = SAML2ComponentBuilder.createAuthorizationDecisionStatement(samlCallback.getAuthDecisionStatementData());
            this.saml2.getAuthzDecisionStatements().addAll(authDecisionStatements);
            this.saml2.setIssuer(samlIssuer);
            try {
                Subject subject = SAML2ComponentBuilder.createSaml2Subject(samlCallback.getSubject());
                this.saml2.setSubject(subject);
            }
            catch (SecurityException ex) {
                throw new WSSecurityException("Error generating KeyInfo from signing credential", ex);
            }
            org.opensaml.saml2.core.Conditions conditions = SAML2ComponentBuilder.createConditions(samlCallback.getConditions());
            this.saml2.setConditions(conditions);
            this.xmlObject = this.saml2;
        }
    }
}

