/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml.ext;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.OpenSAMLBootstrap;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class OpenSAMLUtil {
    private static final Log log = LogFactory.getLog(OpenSAMLUtil.class);
    private static XMLObjectBuilderFactory builderFactory;
    private static MarshallerFactory marshallerFactory;
    private static UnmarshallerFactory unmarshallerFactory;
    private static boolean samlEngineInitialized;

    public static synchronized void initSamlEngine() {
        if (!samlEngineInitialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initilizing the opensaml2 library...");
            }
            try {
                OpenSAMLBootstrap.bootstrap();
                builderFactory = Configuration.getBuilderFactory();
                marshallerFactory = Configuration.getMarshallerFactory();
                unmarshallerFactory = Configuration.getUnmarshallerFactory();
                samlEngineInitialized = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"opensaml2 library bootstrap complete");
                }
            }
            catch (ConfigurationException e) {
                log.error((Object)"Unable to bootstrap the opensaml2 library - all SAML operations will fail", (Throwable)e);
            }
        }
    }

    public static XMLObject fromDom(Element root) throws WSSecurityException {
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(root);
        try {
            return unmarshaller.unmarshall(root);
        }
        catch (UnmarshallingException ex) {
            throw new WSSecurityException("Error unmarshalling a SAML assertion", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element toDom(XMLObject xmlObject, Document doc) throws WSSecurityException {
        Element element;
        block16: {
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            element = null;
            DocumentFragment frag = doc == null ? null : doc.createDocumentFragment();
            try {
                Assertion saml1;
                if (frag != null) {
                    while (doc.getFirstChild() != null) {
                        frag.appendChild(doc.removeChild(doc.getFirstChild()));
                    }
                }
                try {
                    element = doc == null ? marshaller.marshall(xmlObject) : marshaller.marshall(xmlObject, doc);
                }
                catch (MarshallingException ex) {
                    throw new WSSecurityException("Error marshalling a SAML assertion", ex);
                }
                if (xmlObject instanceof org.opensaml.saml2.core.Assertion) {
                    org.opensaml.saml2.core.Assertion saml2 = (org.opensaml.saml2.core.Assertion)xmlObject;
                    if (saml2.getSignature() == null) break block16;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Signing SAML v2.0 assertion...");
                    }
                    try {
                        Signer.signObject((Signature)saml2.getSignature());
                        break block16;
                    }
                    catch (SignatureException ex) {
                        throw new WSSecurityException("Error signing a SAML assertion", ex);
                    }
                }
                if (!(xmlObject instanceof Assertion) || (saml1 = (Assertion)xmlObject).getSignature() == null) break block16;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Signing SAML v1.1 assertion...");
                }
                try {
                    Signer.signObject((Signature)saml1.getSignature());
                }
                catch (SignatureException ex) {
                    throw new WSSecurityException("Error signing a SAML assertion", ex);
                }
            }
            finally {
                if (frag != null) {
                    while (doc.getFirstChild() != null) {
                        doc.removeChild(doc.getFirstChild());
                    }
                    doc.appendChild(frag);
                }
            }
        }
        return element;
    }

    public static Signature buildSignature() {
        QName qName = Signature.DEFAULT_ELEMENT_NAME;
        XMLObjectBuilder builder = builderFactory.getBuilder(qName);
        if (builder == null) {
            log.error((Object)("Unable to retrieve builder for object QName " + qName));
            return null;
        }
        return (Signature)builder.buildObject(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public static boolean isMethodSenderVouches(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:sender-vouches");
    }

    public static boolean isMethodHolderOfKey(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:holder-of-key");
    }

    static {
        samlEngineInitialized = false;
    }
}

