/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.Principal;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.token.KerberosServiceContext;
import org.apache.ws.security.message.token.KerberosServiceExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosServiceAction
implements PrivilegedAction<Principal> {
    private static Log LOG = LogFactory.getLog(KerberosServiceAction.class);
    private byte[] ticket;
    private String serviceName;
    private boolean isUsernameServiceNameForm;

    public KerberosServiceAction(byte[] ticket, String serviceName) {
        this(ticket, serviceName, false);
    }

    public KerberosServiceAction(byte[] ticket, String serviceName, boolean isUsernameServiceNameForm) {
        this.ticket = ticket;
        this.serviceName = serviceName;
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    @Override
    public Principal run() {
        try {
            KerberosServiceExceptionAction action = new KerberosServiceExceptionAction(this.ticket, this.serviceName, this.isUsernameServiceNameForm, false);
            KerberosServiceContext krbServiceCtx = action.run();
            return krbServiceCtx.getPrincipal();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error in validating a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }
}

