/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedKeySTRParser
implements STRParser {
    private static final Log LOG = LogFactory.getLog(EncryptedKeySTRParser.class);
    private X509Certificate[] certs;
    private STRParser.REFERENCE_TYPE referenceType;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        Crypto crypto = data.getDecCrypto();
        WSSConfig config = data.getWssConfig();
        boolean bspCompliant = true;
        if (config != null) {
            bspCompliant = config.isWsiBSPCompliant();
        }
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, bspCompliant);
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            this.referenceType = STRParser.REFERENCE_TYPE.DIRECT_REF;
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
            this.referenceType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(secRef.getKeyIdentifierValueType()) ? STRParser.REFERENCE_TYPE.THUMBPRINT_SHA1 : STRParser.REFERENCE_TYPE.KEY_IDENTIFIER;
        }
        WSSecurityEngineResult result = wsDocInfo.getResult(uri);
        if (result != null) {
            this.processPreviousResult(result, secRef, data, wsDocInfo, bspCompliant);
        } else if (secRef.containsKeyIdentifier()) {
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                AssertionWrapper assertion = SAMLUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                if (bspCompliant) {
                    BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                }
                SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
                this.certs = samlKi.getCerts();
            } else {
                if (bspCompliant) {
                    BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, null);
                }
                this.certs = secRef.getKeyIdentifier(crypto);
            }
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            this.referenceType = STRParser.REFERENCE_TYPE.ISSUER_SERIAL;
            this.certs = secRef.getX509IssuerSerial(crypto);
        } else if (secRef.containsReference()) {
            Element bstElement = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler());
            QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
            if (el.equals(WSSecurityEngine.BINARY_TOKEN)) {
                X509Security token = new X509Security(bstElement);
                if (bspCompliant) {
                    BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, token);
                }
                this.certs = new X509Certificate[]{token.getX509Certificate(crypto)};
            } else {
                throw new WSSecurityException(1, "unsupportedBinaryTokenType", null);
            }
        }
        if (LOG.isDebugEnabled() && this.certs != null && this.certs[0] != null) {
            LOG.debug((Object)("cert: " + this.certs[0]));
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return null;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    @Override
    public STRParser.REFERENCE_TYPE getCertificatesReferenceType() {
        return this.referenceType;
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, WSDocInfo wsDocInfo, boolean bspCompliant) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (4096 == action) {
            if (bspCompliant) {
                BinarySecurity token = (BinarySecurity)result.get("binary-security-token");
                BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, token);
            }
            this.certs = (X509Certificate[])result.get("x509-certificates");
        } else if (8 == action || 16 == action) {
            AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
            if (bspCompliant) {
                BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
            }
            SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant);
            this.certs = keyInfo.getCerts();
        } else {
            throw new WSSecurityException(1, "unsupportedBinaryTokenType", null);
        }
    }
}

