/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.message.token.Timestamp;
import org.opensaml.SAMLAssertion;

public class WSSecurityEngineResult
extends HashMap {
    public static final String TAG_ACTION = "action";
    public static final String TAG_PRINCIPAL = "principal";
    public static final String TAG_X509_CERTIFICATE = "x509-certificate";
    public static final String TAG_SAML_ASSERTION = "saml-assertion";
    public static final String TAG_TIMESTAMP = "timestamp";
    public static final String TAG_SIGNED_ELEMENT_IDS = "signed-element-ids";
    public static final String TAG_SIGNATURE_VALUE = "signature-value";
    public static final String TAG_SIGNATURE_CONFIRMATION = "signature-confirmation";
    public static final String TAG_PROTECTED_ELEMENTS = "protected-elements";
    public static final String TAG_SECURITY_CONTEXT_TOKEN = "security-context-token";
    public static final String TAG_DECRYPTED_KEY = "decrypted-key";
    public static final String TAG_ENCRYPTED_KEY_ID = "encrypted-key-id";
    public static final String TAG_DATA_REF_URIS = "data-ref-uris";
    public static final String TAG_X509_CERTIFICATES = "x509-certificates";
    public static final String TAG_BINARY_SECURITY_TOKEN = "binary-security-token";
    public static final Object TAG_ENCRYPTED_EPHEMERAL_KEY = "encrypted-ephemeral-key-bytes";

    public WSSecurityEngineResult(int act, SAMLAssertion ass) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_SAML_ASSERTION, ass);
    }

    public WSSecurityEngineResult(int act, Principal princ, X509Certificate certificate, Set elements, byte[] sv) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_PRINCIPAL, princ);
        this.put(TAG_X509_CERTIFICATE, certificate);
        this.put(TAG_SIGNED_ELEMENT_IDS, elements);
        this.put(TAG_SIGNATURE_VALUE, sv);
    }

    public WSSecurityEngineResult(int act, Principal princ, X509Certificate certificate, Set elements, Set protectedElements, byte[] sv) {
        this(act, princ, certificate, elements, sv);
        this.put(TAG_PROTECTED_ELEMENTS, protectedElements);
    }

    public WSSecurityEngineResult(int act, byte[] decryptedKey, byte[] encryptedKeyBytes, String encyptedKeyId, List dataRefUris) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_DECRYPTED_KEY, decryptedKey);
        this.put(TAG_ENCRYPTED_EPHEMERAL_KEY, encryptedKeyBytes);
        this.put(TAG_ENCRYPTED_KEY_ID, encyptedKeyId);
        this.put(TAG_DATA_REF_URIS, dataRefUris);
    }

    public WSSecurityEngineResult(int act, ArrayList dataRefUris) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_DATA_REF_URIS, dataRefUris);
    }

    public WSSecurityEngineResult(int act, Timestamp tstamp) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_TIMESTAMP, tstamp);
    }

    public WSSecurityEngineResult(int act, SecurityContextToken sct) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_SECURITY_CONTEXT_TOKEN, sct);
    }

    public WSSecurityEngineResult(int act, SignatureConfirmation sc) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_SIGNATURE_CONFIRMATION, sc);
    }

    public WSSecurityEngineResult(int act, BinarySecurity token, X509Certificate[] certificates) {
        this.put(TAG_ACTION, new Integer(act));
        this.put(TAG_BINARY_SECURITY_TOKEN, token);
        this.put(TAG_X509_CERTIFICATES, certificates);
    }

    public int getAction() {
        return (Integer)this.get(TAG_ACTION);
    }

    public Principal getPrincipal() {
        return (Principal)this.get(TAG_PRINCIPAL);
    }

    public X509Certificate getCertificate() {
        return (X509Certificate)this.get(TAG_X509_CERTIFICATE);
    }

    public SAMLAssertion getAssertion() {
        return (SAMLAssertion)this.get(TAG_SAML_ASSERTION);
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.get(TAG_TIMESTAMP);
    }

    public Set getSignedElements() {
        return (Set)this.get(TAG_SIGNED_ELEMENT_IDS);
    }

    public byte[] getSignatureValue() {
        return (byte[])this.get(TAG_SIGNATURE_VALUE);
    }

    public SignatureConfirmation getSigConf() {
        return (SignatureConfirmation)this.get(TAG_SIGNATURE_CONFIRMATION);
    }

    public void setSignatureValue(byte[] signatureValue) {
        this.put(TAG_SIGNATURE_VALUE, signatureValue);
    }

    public SecurityContextToken getSecurityContextToken() {
        return (SecurityContextToken)this.get(TAG_SECURITY_CONTEXT_TOKEN);
    }

    public byte[] getDecryptedKey() {
        return (byte[])this.get(TAG_DECRYPTED_KEY);
    }

    public String getEncryptedKeyId() {
        return (String)this.get(TAG_ENCRYPTED_KEY_ID);
    }

    public ArrayList getDataRefUris() {
        return (ArrayList)this.get(TAG_DATA_REF_URIS);
    }
}

