/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaDerivationMethod;
import org.apache.ws.commons.schema.utils.XmlSchemaNamed;
import org.apache.ws.commons.schema.utils.XmlSchemaNamedImpl;

public abstract class XmlSchemaType
extends XmlSchemaAnnotated
implements XmlSchemaNamed {
    private XmlSchemaDerivationMethod deriveBy;
    private XmlSchemaDerivationMethod finalDerivation;
    private XmlSchemaDerivationMethod finalResolved;
    private boolean isMixed;
    private XmlSchemaNamedImpl namedDelegate;

    protected XmlSchemaType(XmlSchema schema, boolean topLevel) {
        this.namedDelegate = new XmlSchemaNamedImpl(schema, topLevel);
        this.finalDerivation = XmlSchemaDerivationMethod.NONE;
        if (topLevel) {
            schema.getItems().add(this);
        }
    }

    public XmlSchemaDerivationMethod getDeriveBy() {
        return this.deriveBy;
    }

    public XmlSchemaDerivationMethod getFinal() {
        return this.finalDerivation;
    }

    public void setFinal(XmlSchemaDerivationMethod finalDerivationValue) {
        this.finalDerivation = finalDerivationValue;
    }

    public XmlSchemaDerivationMethod getFinalResolved() {
        return this.finalResolved;
    }

    public boolean isMixed() {
        return this.isMixed;
    }

    public void setMixed(boolean isMixedValue) {
        this.isMixed = isMixedValue;
    }

    public String toString() {
        if (this.getName() == null) {
            return super.toString() + "[anonymous]";
        }
        if (this.namedDelegate.getParent().getLogicalTargetNamespace() == null) {
            return super.toString() + "[{}" + this.getName() + "]";
        }
        return super.toString() + "[{" + this.namedDelegate.getParent().getLogicalTargetNamespace() + "}" + this.getName() + "]";
    }

    public String getName() {
        return this.namedDelegate.getName();
    }

    public XmlSchema getParent() {
        return this.namedDelegate.getParent();
    }

    public QName getQName() {
        return this.namedDelegate.getQName();
    }

    public boolean isAnonymous() {
        return this.namedDelegate.isAnonymous();
    }

    public boolean isTopLevel() {
        return this.namedDelegate.isTopLevel();
    }

    public void setName(String name) {
        if (this.namedDelegate.isTopLevel() && this.namedDelegate.getName() != null) {
            this.namedDelegate.getParent().getSchemaTypes().remove(this.getQName());
        }
        this.namedDelegate.setName(name);
        if (this.namedDelegate.isTopLevel()) {
            this.namedDelegate.getParent().getSchemaTypes().put(this.getQName(), this);
        }
    }

    void setFinalResolved(XmlSchemaDerivationMethod finalResolved) {
        this.finalResolved = finalResolved;
    }

    public void setFinalDerivation(XmlSchemaDerivationMethod finalDerivation) {
        this.finalDerivation = finalDerivation;
    }

    public XmlSchemaDerivationMethod getFinalDerivation() {
        return this.finalDerivation;
    }

    public void setDeriveBy(XmlSchemaDerivationMethod deriveBy) {
        this.deriveBy = deriveBy;
    }
}

