/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContentProcessing;
import org.apache.ws.commons.schema.XmlSchemaDerivationMethod;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaIdentityConstraint;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaKeyref;
import org.apache.ws.commons.schema.XmlSchemaNotation;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaRedefine;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.XmlSchemaXPath;
import org.apache.ws.commons.schema.extensions.ExtensionRegistry;
import org.apache.ws.commons.schema.utils.NodeNamespaceContext;
import org.apache.ws.commons.schema.utils.TargetNamespaceValidator;
import org.apache.ws.commons.schema.utils.XDOMUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SchemaBuilder {
    Document doc;
    XmlSchema schema;
    XmlSchemaCollection collection;
    private final TargetNamespaceValidator validator;
    DocumentBuilderFactory docFac;
    private ExtensionRegistry extReg = null;

    public ExtensionRegistry getExtReg() {
        return this.extReg;
    }

    public void setExtReg(ExtensionRegistry extReg) {
        this.extReg = extReg;
    }

    SchemaBuilder(XmlSchemaCollection collection, TargetNamespaceValidator validator) {
        this.collection = collection;
        this.validator = validator;
        if (collection.getExtReg() != null) {
            this.extReg = collection.getExtReg();
        }
        this.schema = new XmlSchema(collection);
    }

    XmlSchema build(Document doc, String uri, ValidationEventHandler veh) {
        Element schemaEl = doc.getDocumentElement();
        return this.handleXmlSchemaElement(schemaEl, uri);
    }

    XmlSchema handleXmlSchemaElement(Element schemaEl, String uri) {
        this.schema.setNamespaceContext(new NodeNamespaceContext(schemaEl));
        this.setNamespaceAttributes(this.schema, schemaEl);
        XmlSchemaCollection.SchemaKey schemaKey = new XmlSchemaCollection.SchemaKey(this.schema.logicalTargetNamespace, uri);
        if (!this.collection.containsSchema(schemaKey)) {
            this.collection.addSchema(schemaKey, this.schema);
        }
        this.schema.setElementFormDefault(this.getFormDefault(schemaEl, "elementFormDefault"));
        this.schema.setAttributeFormDefault(this.getFormDefault(schemaEl, "attributeFormDefault"));
        this.schema.setBlockDefault(this.getDerivation(schemaEl, "blockDefault"));
        this.schema.setFinalDefault(this.getDerivation(schemaEl, "finalDefault"));
        if (schemaEl.hasAttribute("id")) {
            this.schema.id = schemaEl.getAttribute("id");
        }
        this.schema.setSourceURI(uri);
        Element el = XDOMUtil.getFirstChildElementNS((Node)schemaEl, "http://www.w3.org/2001/XMLSchema");
        if (el == null && XDOMUtil.getFirstChildElementNS((Node)schemaEl, "http://www.w3.org/1999/XMLSchema") != null) {
            throw new XmlSchemaException("Schema defined using \"http://www.w3.org/1999/XMLSchema\" is not supported. Please update the schema to the \"http://www.w3.org/2001/XMLSchema\" namespace");
        }
        while (el != null) {
            XmlSchemaAnnotated group;
            XmlSchemaType type;
            if (el.getLocalName().equals("simpleType")) {
                type = this.handleSimpleType(this.schema, el, schemaEl);
                this.schema.addType(type);
                this.schema.items.add(type);
                this.collection.resolveType(type.getQName(), type);
            } else if (el.getLocalName().equals("complexType")) {
                type = this.handleComplexType(this.schema, el, schemaEl);
                this.schema.addType(type);
                this.schema.items.add(type);
                this.collection.resolveType(type.getQName(), type);
            } else if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(this.schema, el, schemaEl, true);
                if (element.qualifiedName != null) {
                    this.schema.elements.collection.put(element.qualifiedName, element);
                } else if (element.refName != null) {
                    this.schema.elements.collection.put(element.refName, element);
                }
                this.schema.items.add(element);
            } else if (el.getLocalName().equals("include")) {
                XmlSchemaInclude include = this.handleInclude(this.schema, el, schemaEl);
                this.schema.includes.add(include);
                this.schema.items.add(include);
            } else if (el.getLocalName().equals("import")) {
                XmlSchemaImport schemaImport = this.handleImport(this.schema, el, schemaEl);
                this.schema.includes.add(schemaImport);
                this.schema.items.add(schemaImport);
            } else if (el.getLocalName().equals("group")) {
                group = this.handleGroup(this.schema, el, schemaEl);
                this.schema.groups.collection.put(new QName(this.schema.getTargetNamespace(), group.name), group);
                this.schema.items.add(group);
            } else if (el.getLocalName().equals("attributeGroup")) {
                group = this.handleAttributeGroup(this.schema, el, schemaEl);
                this.schema.attributeGroups.collection.put(new QName(this.schema.getTargetNamespace(), ((XmlSchemaAttributeGroup)group).name), group);
                this.schema.items.add(group);
            } else if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(this.schema, el, schemaEl);
                this.schema.attributes.collection.put(attr.qualifiedName, attr);
                this.schema.items.add(attr);
            } else if (el.getLocalName().equals("redefine")) {
                XmlSchemaRedefine redefine = this.handleRedefine(this.schema, el, schemaEl);
                this.schema.includes.add(redefine);
            } else if (el.getLocalName().equals("notation")) {
                XmlSchemaNotation notation = this.handleNotation(el);
                this.schema.notations.collection.put(new QName(this.schema.getTargetNamespace(), notation.name), notation);
                this.schema.items.add(notation);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                this.schema.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        this.processExtensibilityComponents(this.schema, schemaEl);
        return this.schema;
    }

    private XmlSchemaNotation handleNotation(Element notationEl) {
        Element annotationEl;
        XmlSchemaNotation notation = new XmlSchemaNotation();
        if (notationEl.hasAttribute("id")) {
            notation.id = notationEl.getAttribute("id");
        }
        if (notationEl.hasAttribute("name")) {
            notation.name = notationEl.getAttribute("name");
        }
        if (notationEl.hasAttribute("public")) {
            notation.publicNotation = notationEl.getAttribute("public");
        }
        if (notationEl.hasAttribute("system")) {
            notation.system = notationEl.getAttribute("system");
        }
        if ((annotationEl = XDOMUtil.getFirstChildElementNS(notationEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            notation.setAnnotation(annotation);
        }
        return notation;
    }

    private XmlSchemaRedefine handleRedefine(XmlSchema schema, Element redefineEl, Element schemaEl) {
        XmlSchemaRedefine redefine = new XmlSchemaRedefine();
        redefine.schemaLocation = redefineEl.getAttribute("schemaLocation");
        TargetNamespaceValidator validator = this.newIncludeValidator(schema);
        redefine.schema = this.resolveXmlSchema(schema.logicalTargetNamespace, redefine.schemaLocation, validator);
        Element el = XDOMUtil.getFirstChildElementNS((Node)redefineEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            XmlSchemaAnnotated group;
            XmlSchemaType type;
            if (el.getLocalName().equals("simpleType")) {
                type = this.handleSimpleType(schema, el, schemaEl);
                redefine.schemaTypes.collection.put(type.getQName(), type);
                redefine.items.add(type);
            } else if (el.getLocalName().equals("complexType")) {
                type = this.handleComplexType(schema, el, schemaEl);
                redefine.schemaTypes.collection.put(type.getQName(), type);
                redefine.items.add(type);
            } else if (el.getLocalName().equals("group")) {
                group = this.handleGroup(schema, el, schemaEl);
                redefine.groups.collection.put(group.name, group);
                redefine.items.add(group);
            } else if (el.getLocalName().equals("attributeGroup")) {
                group = this.handleAttributeGroup(schema, el, schemaEl);
                redefine.attributeGroups.collection.put(((XmlSchemaAttributeGroup)group).name, group);
                redefine.items.add(group);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                redefine.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return redefine;
    }

    void setNamespaceAttributes(XmlSchema schema, Element schemaEl) {
        if (schemaEl.getAttributeNode("targetNamespace") != null) {
            String contain = schemaEl.getAttribute("targetNamespace");
            schema.setTargetNamespace(contain);
        }
        if (this.validator != null) {
            this.validator.validate(schema);
        }
    }

    XmlSchemaSimpleType handleSimpleType(XmlSchema schema, Element simpleEl, Element schemaEl) {
        Element restrictionEl;
        Element simpleTypeAnnotationEl;
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(schema);
        if (simpleEl.hasAttribute("name")) {
            simpleType.name = simpleEl.getAttribute("name");
        }
        if (simpleEl.hasAttribute("final")) {
            String finalstr = simpleEl.getAttribute("final");
            if (finalstr.equalsIgnoreCase("all") | finalstr.equalsIgnoreCase("#all")) {
                simpleType.setFinal(new XmlSchemaDerivationMethod("all"));
            } else {
                simpleType.setFinal(new XmlSchemaDerivationMethod(finalstr));
            }
        }
        if ((simpleTypeAnnotationEl = XDOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation simpleTypeAnnotation = this.handleAnnotation(simpleTypeAnnotationEl);
            simpleType.setAnnotation(simpleTypeAnnotation);
        }
        if ((restrictionEl = XDOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "restriction")) != null) {
            XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
            Element restAnnotationEl = XDOMUtil.getFirstChildElementNS(restrictionEl, "http://www.w3.org/2001/XMLSchema", "annotation");
            if (restAnnotationEl != null) {
                XmlSchemaAnnotation restAnnotation = this.handleAnnotation(restAnnotationEl);
                restriction.setAnnotation(restAnnotation);
            }
            Element inlineSimpleType = XDOMUtil.getFirstChildElementNS(restrictionEl, "http://www.w3.org/2001/XMLSchema", "simpleType");
            if (restrictionEl.hasAttribute("base")) {
                NodeNamespaceContext ctx = new NodeNamespaceContext(restrictionEl);
                restriction.baseTypeName = this.getRefQName(restrictionEl.getAttribute("base"), ctx);
            } else if (inlineSimpleType != null) {
                restriction.baseType = this.handleSimpleType(schema, inlineSimpleType, schemaEl);
            }
            Element el = XDOMUtil.getFirstChildElementNS((Node)restrictionEl, "http://www.w3.org/2001/XMLSchema");
            while (el != null) {
                if (!el.getLocalName().equals("annotation") && !el.getLocalName().equals("simpleType")) {
                    XmlSchemaFacet facet = XmlSchemaFacet.construct(el);
                    Element annotation = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (annotation != null) {
                        XmlSchemaAnnotation facetAnnotation = this.handleAnnotation(annotation);
                        facet.setAnnotation(facetAnnotation);
                    }
                    restriction.facets.add(facet);
                }
                el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
            }
            simpleType.content = restriction;
        } else {
            Element listEl = XDOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "list");
            if (listEl != null) {
                XmlSchemaSimpleTypeList list = new XmlSchemaSimpleTypeList();
                if (listEl.hasAttribute("itemType")) {
                    String name = listEl.getAttribute("itemType");
                    list.itemTypeName = this.getRefQName(name, listEl);
                } else {
                    Element inlineListType = XDOMUtil.getFirstChildElementNS(listEl, "http://www.w3.org/2001/XMLSchema", "simpleType");
                    if (inlineListType != null) {
                        list.itemType = this.handleSimpleType(schema, inlineListType, schemaEl);
                    }
                }
                Element listAnnotationEl = XDOMUtil.getFirstChildElementNS(listEl, "http://www.w3.org/2001/XMLSchema", "annotation");
                if (listAnnotationEl != null) {
                    XmlSchemaAnnotation listAnnotation = this.handleAnnotation(listAnnotationEl);
                    list.setAnnotation(listAnnotation);
                }
                simpleType.content = list;
            } else {
                Element unionEl = XDOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "union");
                if (unionEl != null) {
                    XmlSchemaSimpleTypeUnion union = new XmlSchemaSimpleTypeUnion();
                    if (unionEl.hasAttribute("memberTypes")) {
                        String memberTypes;
                        union.memberTypesSource = memberTypes = unionEl.getAttribute("memberTypes");
                        Vector<QName> v = new Vector<QName>();
                        StringTokenizer tokenizer = new StringTokenizer(memberTypes, " ");
                        while (tokenizer.hasMoreTokens()) {
                            String member = tokenizer.nextToken();
                            v.add(this.getRefQName(member, unionEl));
                        }
                        union.memberTypesQNames = new QName[v.size()];
                        v.copyInto(union.memberTypesQNames);
                    }
                    Element inlineUnionType = XDOMUtil.getFirstChildElementNS(unionEl, "http://www.w3.org/2001/XMLSchema", "simpleType");
                    while (inlineUnionType != null) {
                        XmlSchemaSimpleType unionSimpleType = this.handleSimpleType(schema, inlineUnionType, schemaEl);
                        union.baseTypes.add(unionSimpleType);
                        if (unionSimpleType.name != null) {
                            union.memberTypesSource = union.memberTypesSource + " " + unionSimpleType.name;
                        }
                        inlineUnionType = XDOMUtil.getNextSiblingElementNS(inlineUnionType, "http://www.w3.org/2001/XMLSchema", "simpleType");
                    }
                    Element unionAnnotationEl = XDOMUtil.getFirstChildElementNS(unionEl, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (unionAnnotationEl != null) {
                        XmlSchemaAnnotation unionAnnotation = this.handleAnnotation(unionAnnotationEl);
                        union.setAnnotation(unionAnnotation);
                    }
                    simpleType.content = union;
                }
            }
        }
        this.processExtensibilityComponents(simpleType, simpleEl);
        return simpleType;
    }

    private QName getRefQName(String pName, Node pNode) {
        return this.getRefQName(pName, new NodeNamespaceContext(pNode));
    }

    private QName getRefQName(String pName, NamespaceContext pContext) {
        String prefix;
        String localName;
        String uri;
        int offset = pName.indexOf(58);
        if (offset == -1) {
            uri = pContext.getNamespaceURI("");
            if ("".equals(uri)) {
                return new QName(this.schema.logicalTargetNamespace, pName);
            }
            localName = pName;
            prefix = "";
        } else {
            prefix = pName.substring(0, offset);
            uri = pContext.getNamespaceURI(prefix);
            if ((uri == null || "".equals(uri)) && this.schema.parent != null && this.schema.parent.getNamespaceContext() != null) {
                uri = this.schema.parent.getNamespaceContext().getNamespaceURI(prefix);
            }
            if (uri == null || "".equals(uri)) {
                throw new IllegalStateException("The prefix " + prefix + " is not bound.");
            }
            localName = pName.substring(offset + 1);
        }
        return new QName(uri, localName, prefix);
    }

    XmlSchemaComplexType handleComplexType(XmlSchema schema, Element complexEl, Element schemaEl) {
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema);
        if (complexEl.hasAttribute("name")) {
            ct.name = complexEl.getAttribute("name");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)complexEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                ct.particle = this.handleSequence(schema, el, schemaEl);
            } else if (el.getLocalName().equals("choice")) {
                ct.particle = this.handleChoice(schema, el, schemaEl);
            } else if (el.getLocalName().equals("all")) {
                ct.particle = this.handleAll(schema, el, schemaEl);
            } else if (el.getLocalName().equals("attribute")) {
                ct.attributes.add(this.handleAttribute(schema, el, schemaEl));
            } else if (el.getLocalName().equals("attributeGroup")) {
                ct.attributes.add(this.handleAttributeGroupRef(el));
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                ct.particle = group.particle == null ? group : group.particle;
            } else if (el.getLocalName().equals("simpleContent")) {
                ct.contentModel = this.handleSimpleContent(schema, el, schemaEl);
            } else if (el.getLocalName().equals("complexContent")) {
                ct.contentModel = this.handleComplexContent(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                ct.setAnnotation(this.handleAnnotation(el));
            } else if (el.getLocalName().equals("anyAttribute")) {
                ct.setAnyAttribute(this.handleAnyAttribute(schema, el, schemaEl));
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        if (complexEl.hasAttribute("block")) {
            String blockStr = complexEl.getAttribute("block");
            if (blockStr.equalsIgnoreCase("all") | blockStr.equalsIgnoreCase("#all")) {
                ct.setBlock(new XmlSchemaDerivationMethod("all"));
            } else {
                ct.setBlock(new XmlSchemaDerivationMethod(blockStr));
            }
        }
        if (complexEl.hasAttribute("final")) {
            String finalstr = complexEl.getAttribute("final");
            if (finalstr.equalsIgnoreCase("all") | finalstr.equalsIgnoreCase("#all")) {
                ct.setFinal(new XmlSchemaDerivationMethod("all"));
            } else {
                ct.setFinal(new XmlSchemaDerivationMethod(finalstr));
            }
        }
        if (complexEl.hasAttribute("abstract")) {
            String abs = complexEl.getAttribute("abstract");
            if (abs.equalsIgnoreCase("true")) {
                ct.setAbstract(true);
            } else {
                ct.setAbstract(false);
            }
        }
        if (complexEl.hasAttribute("mixed")) {
            String mixed = complexEl.getAttribute("mixed");
            if (mixed.equalsIgnoreCase("true")) {
                ct.setMixed(true);
            } else {
                ct.setMixed(false);
            }
        }
        this.processExtensibilityComponents(ct, complexEl);
        return ct;
    }

    private XmlSchemaSimpleContent handleSimpleContent(XmlSchema schema, Element simpleEl, Element schemaEl) {
        XmlSchemaSimpleContent simpleContent = new XmlSchemaSimpleContent();
        Element el = XDOMUtil.getFirstChildElementNS((Node)simpleEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("restriction")) {
                simpleContent.content = this.handleSimpleContentRestriction(schema, el, schemaEl);
            } else if (el.getLocalName().equals("extension")) {
                simpleContent.content = this.handleSimpleContentExtension(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                simpleContent.setAnnotation(this.handleAnnotation(el));
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return simpleContent;
    }

    private XmlSchemaComplexContent handleComplexContent(XmlSchema schema, Element complexEl, Element schemaEl) {
        XmlSchemaComplexContent complexContent = new XmlSchemaComplexContent();
        Element el = XDOMUtil.getFirstChildElementNS((Node)complexEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("restriction")) {
                complexContent.content = this.handleComplexContentRestriction(schema, el, schemaEl);
            } else if (el.getLocalName().equals("extension")) {
                complexContent.content = this.handleComplexContentExtension(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                complexContent.setAnnotation(this.handleAnnotation(el));
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return complexContent;
    }

    private XmlSchemaSimpleContentRestriction handleSimpleContentRestriction(XmlSchema schema, Element restrictionEl, Element schemaEl) {
        XmlSchemaSimpleContentRestriction restriction = new XmlSchemaSimpleContentRestriction();
        if (restrictionEl.hasAttribute("base")) {
            String name = restrictionEl.getAttribute("base");
            restriction.baseTypeName = this.getRefQName(name, restrictionEl);
        }
        if (restrictionEl.hasAttribute("id")) {
            restriction.id = restrictionEl.getAttribute("id");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)restrictionEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                restriction.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(el);
                restriction.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("simpleType")) {
                restriction.baseType = this.handleSimpleType(schema, el, schemaEl);
            } else if (el.getLocalName().equals("anyAttribute")) {
                restriction.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                restriction.setAnnotation(this.handleAnnotation(el));
            } else {
                XmlSchemaFacet facet = XmlSchemaFacet.construct(el);
                NodeList annotations = el.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "annotation");
                if (annotations.getLength() > 0) {
                    XmlSchemaAnnotation facetAnnotation = this.handleAnnotation(el);
                    facet.setAnnotation(facetAnnotation);
                }
                restriction.facets.add(facet);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return restriction;
    }

    private XmlSchemaSimpleContentExtension handleSimpleContentExtension(XmlSchema schema, Element extEl, Element schemaEl) {
        XmlSchemaSimpleContentExtension ext = new XmlSchemaSimpleContentExtension();
        if (extEl.hasAttribute("base")) {
            String name = extEl.getAttribute("base");
            ext.baseTypeName = this.getRefQName(name, extEl);
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)extEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                ext.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(el);
                ext.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("anyAttribute")) {
                ext.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                ext.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return ext;
    }

    private XmlSchemaComplexContentRestriction handleComplexContentRestriction(XmlSchema schema, Element restrictionEl, Element schemaEl) {
        XmlSchemaComplexContentRestriction restriction = new XmlSchemaComplexContentRestriction();
        if (restrictionEl.hasAttribute("base")) {
            String name = restrictionEl.getAttribute("base");
            restriction.baseTypeName = this.getRefQName(name, restrictionEl);
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)restrictionEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                restriction.particle = this.handleSequence(schema, el, schemaEl);
            } else if (el.getLocalName().equals("choice")) {
                restriction.particle = this.handleChoice(schema, el, schemaEl);
            } else if (el.getLocalName().equals("all")) {
                restriction.particle = this.handleAll(schema, el, schemaEl);
            } else if (el.getLocalName().equals("attribute")) {
                restriction.attributes.add(this.handleAttribute(schema, el, schemaEl));
            } else if (el.getLocalName().equals("attributeGroup")) {
                restriction.attributes.add(this.handleAttributeGroupRef(el));
            } else if (el.getLocalName().equals("group")) {
                restriction.particle = this.handleGroupRef(schema, el, schemaEl);
            } else if (el.getLocalName().equals("anyAttribute")) {
                restriction.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                restriction.setAnnotation(this.handleAnnotation(el));
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return restriction;
    }

    private XmlSchemaComplexContentExtension handleComplexContentExtension(XmlSchema schema, Element extEl, Element schemaEl) {
        XmlSchemaComplexContentExtension ext = new XmlSchemaComplexContentExtension();
        if (extEl.hasAttribute("base")) {
            String name = extEl.getAttribute("base");
            ext.baseTypeName = this.getRefQName(name, extEl);
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)extEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                ext.particle = this.handleSequence(schema, el, schemaEl);
            } else if (el.getLocalName().equals("choice")) {
                ext.particle = this.handleChoice(schema, el, schemaEl);
            } else if (el.getLocalName().equals("all")) {
                ext.particle = this.handleAll(schema, el, schemaEl);
            } else if (el.getLocalName().equals("attribute")) {
                ext.attributes.add(this.handleAttribute(schema, el, schemaEl));
            } else if (el.getLocalName().equals("attributeGroup")) {
                ext.attributes.add(this.handleAttributeGroupRef(el));
            } else if (el.getLocalName().equals("group")) {
                ext.particle = this.handleGroupRef(schema, el, schemaEl);
            } else if (el.getLocalName().equals("anyAttribute")) {
                ext.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                ext.setAnnotation(this.handleAnnotation(el));
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return ext;
    }

    private XmlSchemaAttributeGroupRef handleAttributeGroupRef(Element attrGroupEl) {
        Element annotationEl;
        XmlSchemaAttributeGroupRef attrGroup = new XmlSchemaAttributeGroupRef();
        if (attrGroupEl.hasAttribute("ref")) {
            String ref = attrGroupEl.getAttribute("ref");
            attrGroup.refName = this.getRefQName(ref, attrGroupEl);
        }
        if (attrGroupEl.hasAttribute("id")) {
            attrGroup.id = attrGroupEl.getAttribute("id");
        }
        if ((annotationEl = XDOMUtil.getFirstChildElementNS(attrGroupEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            attrGroup.setAnnotation(annotation);
        }
        return attrGroup;
    }

    private XmlSchemaSequence handleSequence(XmlSchema schema, Element sequenceEl, Element schemaEl) {
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        Element el = XDOMUtil.getFirstChildElementNS((Node)sequenceEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence seq = this.handleSequence(schema, el, schemaEl);
                sequence.items.add(seq);
            } else if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(schema, el, schemaEl, false);
                sequence.items.add(element);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                sequence.items.add(group);
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choice = this.handleChoice(schema, el, schemaEl);
                sequence.items.add(choice);
            } else if (el.getLocalName().equals("any")) {
                XmlSchemaAny any = this.handleAny(schema, el, schemaEl);
                sequence.items.add(any);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                sequence.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return sequence;
    }

    private XmlSchemaAny handleAny(XmlSchema schema, Element anyEl, Element schemaEl) {
        Element annotationEl;
        XmlSchemaAny any = new XmlSchemaAny();
        if (anyEl.hasAttribute("namespace")) {
            any.namespace = anyEl.getAttribute("namespace");
        }
        if (anyEl.hasAttribute("processContents")) {
            String processContent = this.getEnumString(anyEl, "processContents");
            any.processContent = new XmlSchemaContentProcessing(processContent);
        }
        if ((annotationEl = XDOMUtil.getFirstChildElementNS(anyEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            any.setAnnotation(annotation);
        }
        any.minOccurs = this.getMinOccurs(anyEl);
        any.maxOccurs = this.getMaxOccurs(anyEl);
        return any;
    }

    private XmlSchemaChoice handleChoice(XmlSchema schema, Element choiceEl, Element schemaEl) {
        XmlSchemaChoice choice = new XmlSchemaChoice();
        if (choiceEl.hasAttribute("id")) {
            choice.id = choiceEl.getAttribute("id");
        }
        choice.minOccurs = this.getMinOccurs(choiceEl);
        choice.maxOccurs = this.getMaxOccurs(choiceEl);
        Element el = XDOMUtil.getFirstChildElementNS((Node)choiceEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence seq = this.handleSequence(schema, el, schemaEl);
                choice.items.add(seq);
            } else if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(schema, el, schemaEl, false);
                choice.items.add(element);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                choice.items.add(group);
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choiceItem = this.handleChoice(schema, el, schemaEl);
                choice.items.add(choiceItem);
            } else if (el.getLocalName().equals("any")) {
                XmlSchemaAny any = this.handleAny(schema, el, schemaEl);
                choice.items.add(any);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                choice.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return choice;
    }

    private XmlSchemaAll handleAll(XmlSchema schema, Element allEl, Element schemaEl) {
        XmlSchemaAll all = new XmlSchemaAll();
        Element el = XDOMUtil.getFirstChildElementNS((Node)allEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(schema, el, schemaEl, false);
                all.items.add(element);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                all.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return all;
    }

    private XmlSchemaGroup handleGroup(XmlSchema schema, Element groupEl, Element schemaEl) {
        XmlSchemaGroup group = new XmlSchemaGroup();
        group.name = groupEl.getAttribute("name");
        Element el = XDOMUtil.getFirstChildElementNS((Node)groupEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("all")) {
                group.particle = this.handleAll(schema, el, schemaEl);
            } else if (el.getLocalName().equals("sequence")) {
                group.particle = this.handleSequence(schema, el, schemaEl);
            } else if (el.getLocalName().equals("choice")) {
                group.particle = this.handleChoice(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation groupAnnotation = this.handleAnnotation(el);
                group.setAnnotation(groupAnnotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return group;
    }

    private XmlSchemaAttributeGroup handleAttributeGroup(XmlSchema schema, Element groupEl, Element schemaEl) {
        XmlSchemaAttributeGroup attrGroup = new XmlSchemaAttributeGroup();
        if (groupEl.hasAttribute("name")) {
            attrGroup.name = groupEl.getAttribute("name");
        }
        if (groupEl.hasAttribute("id")) {
            attrGroup.id = groupEl.getAttribute("id");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)groupEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                attrGroup.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroupRef = this.handleAttributeGroupRef(el);
                attrGroup.attributes.add(attrGroupRef);
            } else if (el.getLocalName().equals("anyAttribute")) {
                attrGroup.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                attrGroup.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return attrGroup;
    }

    private XmlSchemaAnyAttribute handleAnyAttribute(XmlSchema schema, Element anyAttrEl, Element schemaEl) {
        Element annotationEl;
        XmlSchemaAnyAttribute anyAttr = new XmlSchemaAnyAttribute();
        if (anyAttrEl.hasAttribute("namespace")) {
            anyAttr.namespace = anyAttrEl.getAttribute("namespace");
        }
        if (anyAttrEl.hasAttribute("processContents")) {
            String contentProcessing = this.getEnumString(anyAttrEl, "processContents");
            anyAttr.processContent = new XmlSchemaContentProcessing(contentProcessing);
        }
        if (anyAttrEl.hasAttribute("id")) {
            anyAttr.id = anyAttrEl.getAttribute("id");
        }
        if ((annotationEl = XDOMUtil.getFirstChildElementNS(anyAttrEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            anyAttr.setAnnotation(annotation);
        }
        return anyAttr;
    }

    private XmlSchemaGroupRef handleGroupRef(XmlSchema schema, Element groupEl, Element schemaEl) {
        XmlSchemaGroupRef group = new XmlSchemaGroupRef();
        Element annotationEl = XDOMUtil.getFirstChildElementNS(groupEl, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotationEl != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            group.setAnnotation(annotation);
        }
        if (groupEl.hasAttribute("ref")) {
            String ref = groupEl.getAttribute("ref");
            group.refName = this.getRefQName(ref, groupEl);
            return group;
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)groupEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                group.particle = this.handleSequence(schema, el, schemaEl);
            } else if (el.getLocalName().equals("all")) {
                group.particle = this.handleAll(schema, el, schemaEl);
            } else if (el.getLocalName().equals("choice")) {
                group.particle = this.handleChoice(schema, el, schemaEl);
            }
            el = XDOMUtil.getNextSiblingElement(el);
        }
        return group;
    }

    private QName newLocalQName(String pLocalName) {
        String uri = this.schema.logicalTargetNamespace;
        if (uri == null) {
            uri = "";
        }
        return new QName(uri, pLocalName);
    }

    private XmlSchemaAttribute handleAttribute(XmlSchema schema, Element attrEl, Element schemaEl) {
        Element annotationEl;
        Element simpleTypeEl;
        String name;
        XmlSchemaAttribute attr = new XmlSchemaAttribute();
        if (attrEl.hasAttribute("name")) {
            String name2;
            attr.name = name2 = attrEl.getAttribute("name");
        }
        boolean isQualified = schema.getAttributeFormDefault().getValue().equals("qualified");
        if (attr.name != null) {
            name = attr.name;
            QName qName = attr.qualifiedName = isQualified ? this.newLocalQName(name) : new QName(name);
        }
        if (attrEl.hasAttribute("type")) {
            name = attrEl.getAttribute("type");
            attr.schemaTypeName = this.getRefQName(name, attrEl);
        }
        if (attrEl.hasAttribute("default")) {
            attr.defaultValue = attrEl.getAttribute("default");
        }
        if (attrEl.hasAttribute("fixed")) {
            attr.fixedValue = attrEl.getAttribute("fixed");
        }
        if (attrEl.hasAttribute("form")) {
            String formValue = this.getEnumString(attrEl, "form");
            attr.form = new XmlSchemaForm(formValue);
        }
        if (attrEl.hasAttribute("id")) {
            attr.id = attrEl.getAttribute("id");
        }
        if (attrEl.hasAttribute("use")) {
            String useType = this.getEnumString(attrEl, "use");
            attr.use = new XmlSchemaUse(useType);
        }
        if (attrEl.hasAttribute("ref")) {
            name = attrEl.getAttribute("ref");
            attr.refName = this.getRefQName(name, attrEl);
            attr.name = name;
        }
        if ((simpleTypeEl = XDOMUtil.getFirstChildElementNS(attrEl, "http://www.w3.org/2001/XMLSchema", "simpleType")) != null) {
            attr.schemaType = this.handleSimpleType(schema, simpleTypeEl, schemaEl);
        }
        if ((annotationEl = XDOMUtil.getFirstChildElementNS(attrEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            attr.setAnnotation(annotation);
        }
        NamedNodeMap attrNodes = attrEl.getAttributes();
        Vector<Attr> attrs = new Vector<Attr>();
        NodeNamespaceContext ctx = null;
        for (int i = 0; i < attrNodes.getLength(); ++i) {
            String namespace;
            Attr att = (Attr)attrNodes.item(i);
            String attName = att.getName();
            if (attName.equals("name") || attName.equals("type") || attName.equals("default") || attName.equals("fixed") || attName.equals("form") || attName.equals("id") || attName.equals("use") || attName.equals("ref")) continue;
            attrs.add(att);
            String value = att.getValue();
            if (value.indexOf(":") <= -1) continue;
            String prefix = value.substring(0, value.indexOf(":"));
            if (ctx == null) {
                ctx = new NodeNamespaceContext(attrEl);
            }
            if ("".equals(namespace = ctx.getNamespaceURI(prefix))) continue;
            Attr nsAttr = attrEl.getOwnerDocument().createAttribute("xmlns:" + prefix);
            nsAttr.setValue(namespace);
            attrs.add(nsAttr);
        }
        if (attrs.size() > 0) {
            attr.setUnhandledAttributes(attrs.toArray(new Attr[0]));
        }
        return attr;
    }

    XmlSchemaElement handleElement(XmlSchema schema, Element el, Element schemaEl, boolean isGlobal) {
        Element uniqueEl;
        Element keyrefEl;
        Element annotationEl;
        XmlSchemaElement element = new XmlSchemaElement();
        if (el.getAttributeNode("name") != null) {
            element.name = el.getAttribute("name");
        }
        boolean isQualified = schema.getElementFormDefault().getValue().equals("qualified");
        if (el.hasAttribute("form")) {
            String formDef = el.getAttribute("form");
            element.form = new XmlSchemaForm(formDef);
            isQualified = formDef.equals("qualified");
        }
        if (element.name != null) {
            String name = element.name;
            QName qName = element.qualifiedName = isQualified || isGlobal ? this.newLocalQName(name) : new QName("", name);
        }
        if ((annotationEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            element.setAnnotation(annotation);
        }
        if (el.getAttributeNode("type") != null) {
            String typeName = el.getAttribute("type");
            element.schemaTypeName = this.getRefQName(typeName, el);
            QName typeQName = element.schemaTypeName;
            XmlSchemaType type = this.collection.getTypeByQName(typeQName);
            if (type == null) {
                this.collection.addUnresolvedType(typeQName, element);
            }
            element.schemaType = type;
        } else if (el.getAttributeNode("ref") != null) {
            String refName = el.getAttribute("ref");
            QName refQName = this.getRefQName(refName, el);
            element.setRefName(refQName);
            element.name = refQName.getLocalPart();
        }
        Element simpleTypeEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "simpleType");
        if (simpleTypeEl != null) {
            XmlSchemaSimpleType simpleType = this.handleSimpleType(schema, simpleTypeEl, schemaEl);
            element.schemaType = simpleType;
            element.schemaTypeName = simpleType.getQName();
        } else {
            Element complexTypeEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "complexType");
            if (complexTypeEl != null) {
                element.schemaType = this.handleComplexType(schema, complexTypeEl, schemaEl);
            }
        }
        Element keyEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "key");
        if (keyEl != null) {
            while (keyEl != null) {
                element.constraints.add(this.handleConstraint(keyEl, "Key"));
                keyEl = XDOMUtil.getNextSiblingElement((Node)keyEl, "key");
            }
        }
        if ((keyrefEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "keyref")) != null) {
            while (keyrefEl != null) {
                XmlSchemaKeyref keyRef = (XmlSchemaKeyref)this.handleConstraint(keyrefEl, "Keyref");
                if (keyrefEl.hasAttribute("refer")) {
                    String name = keyrefEl.getAttribute("refer");
                    keyRef.refer = this.getRefQName(name, el);
                }
                element.constraints.add(keyRef);
                keyrefEl = XDOMUtil.getNextSiblingElement((Node)keyrefEl, "keyref");
            }
        }
        if ((uniqueEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "unique")) != null) {
            while (uniqueEl != null) {
                element.constraints.add(this.handleConstraint(uniqueEl, "Unique"));
                uniqueEl = XDOMUtil.getNextSiblingElement((Node)uniqueEl, "unique");
            }
        }
        if (el.hasAttribute("abstract")) {
            element.isAbstract = Boolean.valueOf(el.getAttribute("abstract"));
        }
        if (el.hasAttribute("block")) {
            element.block = this.getDerivation(el, "block");
        }
        if (el.hasAttribute("default")) {
            element.defaultValue = el.getAttribute("default");
        }
        if (el.hasAttribute("final")) {
            element.finalDerivation = this.getDerivation(el, "final");
        }
        if (el.hasAttribute("fixed")) {
            element.fixedValue = el.getAttribute("fixed");
        }
        if (el.hasAttribute("id")) {
            element.id = el.getAttribute("id");
        }
        if (el.hasAttribute("nillable")) {
            element.isNillable = Boolean.valueOf(el.getAttribute("nillable"));
        }
        if (el.hasAttribute("substitutionGroup")) {
            String substitutionGroup = el.getAttribute("substitutionGroup");
            element.setSubstitutionGroup(this.getRefQName(substitutionGroup, el));
        }
        element.minOccurs = this.getMinOccurs(el);
        element.maxOccurs = this.getMaxOccurs(el);
        this.processExtensibilityComponents(element, el);
        return element;
    }

    private XmlSchemaIdentityConstraint handleConstraint(Element constraintEl, String type) {
        try {
            XmlSchemaIdentityConstraint constraint = (XmlSchemaIdentityConstraint)Class.forName("org.apache.ws.commons.schema.XmlSchema" + type).newInstance();
            if (constraintEl.hasAttribute("name")) {
                constraint.name = constraintEl.getAttribute("name");
            }
            if (constraintEl.hasAttribute("refer")) {
                String name = constraintEl.getAttribute("refer");
                ((XmlSchemaKeyref)constraint).refer = this.getRefQName(name, constraintEl);
            }
            Element el = XDOMUtil.getFirstChildElementNS((Node)constraintEl, "http://www.w3.org/2001/XMLSchema");
            while (el != null) {
                XmlSchemaAnnotation annotation;
                Element annotationEl;
                if (el.getLocalName().equals("selector")) {
                    XmlSchemaXPath selectorXPath = new XmlSchemaXPath();
                    selectorXPath.xpath = el.getAttribute("xpath");
                    annotationEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (annotationEl != null) {
                        annotation = this.handleAnnotation(annotationEl);
                        selectorXPath.setAnnotation(annotation);
                    }
                    constraint.selector = selectorXPath;
                } else if (el.getLocalName().equals("field")) {
                    XmlSchemaXPath fieldXPath = new XmlSchemaXPath();
                    fieldXPath.xpath = el.getAttribute("xpath");
                    constraint.fields.add(fieldXPath);
                    annotationEl = XDOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (annotationEl != null) {
                        annotation = this.handleAnnotation(annotationEl);
                        fieldXPath.setAnnotation(annotation);
                    }
                } else if (el.getLocalName().equals("annotation")) {
                    XmlSchemaAnnotation constraintAnnotation = this.handleAnnotation(el);
                    constraint.setAnnotation(constraintAnnotation);
                }
                el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
            }
            return constraint;
        }
        catch (ClassNotFoundException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    XmlSchemaImport handleImport(XmlSchema schema, Element importEl, Element schemaEl) {
        XmlSchemaImport schemaImport = new XmlSchemaImport();
        Element annotationEl = XDOMUtil.getFirstChildElementNS(importEl, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotationEl != null) {
            XmlSchemaAnnotation importAnnotation = this.handleAnnotation(annotationEl);
            schemaImport.setAnnotation(importAnnotation);
        }
        final String uri = schemaImport.namespace = importEl.getAttribute("namespace");
        schemaImport.schemaLocation = importEl.getAttribute("schemaLocation");
        TargetNamespaceValidator validator = new TargetNamespaceValidator(){

            private boolean isEmpty(String pValue) {
                return pValue == null || "".equals(pValue);
            }

            public void validate(XmlSchema pSchema) {
                boolean valid = this.isEmpty(uri) ? this.isEmpty(pSchema.syntacticalTargetNamespace) : pSchema.syntacticalTargetNamespace.equals(uri);
                if (!valid) {
                    throw new XmlSchemaException("An imported schema was announced to have the namespace " + uri + ", but has the namespace " + pSchema.syntacticalTargetNamespace);
                }
            }
        };
        if (schemaImport.schemaLocation != null && !schemaImport.schemaLocation.equals("")) {
            schemaImport.schema = schema.getSourceURI() != null ? this.resolveXmlSchema(uri, schemaImport.schemaLocation, schema.getSourceURI(), validator) : this.resolveXmlSchema(schemaImport.namespace, schemaImport.schemaLocation, validator);
        }
        return schemaImport;
    }

    XmlSchemaInclude handleInclude(XmlSchema schema, Element includeEl, Element schemaEl) {
        XmlSchemaInclude include = new XmlSchemaInclude();
        Element annotationEl = XDOMUtil.getFirstChildElementNS(includeEl, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotationEl != null) {
            XmlSchemaAnnotation includeAnnotation = this.handleAnnotation(annotationEl);
            include.setAnnotation(includeAnnotation);
        }
        include.schemaLocation = includeEl.getAttribute("schemaLocation");
        TargetNamespaceValidator validator = this.newIncludeValidator(schema);
        include.schema = schema.getSourceURI() != null ? this.resolveXmlSchema(schema.logicalTargetNamespace, include.schemaLocation, schema.getSourceURI(), validator) : this.resolveXmlSchema(schema.logicalTargetNamespace, include.schemaLocation, validator);
        this.processExtensibilityComponents(include, includeEl);
        return include;
    }

    private TargetNamespaceValidator newIncludeValidator(final XmlSchema schema) {
        return new TargetNamespaceValidator(){

            private boolean isEmpty(String pValue) {
                return pValue == null || "".equals(pValue);
            }

            public void validate(XmlSchema pSchema) {
                if (this.isEmpty(pSchema.syntacticalTargetNamespace)) {
                    pSchema.logicalTargetNamespace = schema.logicalTargetNamespace;
                } else if (!pSchema.syntacticalTargetNamespace.equals(schema.logicalTargetNamespace)) {
                    String msg = "An included schema was announced to have the default target namespace";
                    if (!this.isEmpty(schema.logicalTargetNamespace)) {
                        msg = msg + " or the target namespace " + schema.logicalTargetNamespace;
                    }
                    throw new XmlSchemaException(msg + ", but has the target namespace " + pSchema.logicalTargetNamespace);
                }
            }
        };
    }

    XmlSchemaAnnotation handleAnnotation(Element annotEl) {
        XmlSchemaObjectCollection content = new XmlSchemaObjectCollection();
        Element appinfo = XDOMUtil.getFirstChildElementNS(annotEl, "http://www.w3.org/2001/XMLSchema", "appinfo");
        while (appinfo != null) {
            XmlSchemaAppInfo appInfoObj = this.handleAppInfo(appinfo);
            if (appInfoObj != null) {
                content.add(appInfoObj);
            }
            appinfo = XDOMUtil.getNextSiblingElementNS(appinfo, "http://www.w3.org/2001/XMLSchema", "appinfo");
        }
        Element documentation = XDOMUtil.getFirstChildElementNS(annotEl, "http://www.w3.org/2001/XMLSchema", "documentation");
        while (documentation != null) {
            XmlSchemaDocumentation docsObj = this.handleDocumentation(documentation);
            if (docsObj != null) {
                content.add(docsObj);
            }
            documentation = XDOMUtil.getNextSiblingElementNS(documentation, "http://www.w3.org/2001/XMLSchema", "documentation");
        }
        XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
        annotation.items = content;
        this.processExtensibilityComponents(annotation, annotEl);
        return annotation;
    }

    XmlSchemaAppInfo handleAppInfo(Element content) {
        XmlSchemaAppInfo appInfo = new XmlSchemaAppInfo();
        NodeList markup = this.getChild(content);
        if (!(content.hasAttribute("source") || markup != null && markup.getLength() > 0)) {
            return null;
        }
        appInfo.setSource(this.getAttribute(content, "source"));
        appInfo.setMarkup(markup);
        return appInfo;
    }

    XmlSchemaDocumentation handleDocumentation(Element content) {
        XmlSchemaDocumentation documentation = new XmlSchemaDocumentation();
        NodeList markup = this.getChild(content);
        if (!(content.hasAttribute("source") || content.hasAttribute("xml:lang") || markup != null && markup.getLength() > 0)) {
            return null;
        }
        documentation.setSource(this.getAttribute(content, "source"));
        documentation.setLanguage(this.getAttribute(content, "xml:lang"));
        documentation.setMarkup(this.getChild(content));
        return documentation;
    }

    private String getAttribute(Element content, String attrName) {
        if (content.hasAttribute(attrName)) {
            return content.getAttribute(attrName);
        }
        return null;
    }

    private NodeList getChild(Element content) {
        NodeList childs = content.getChildNodes();
        if (childs.getLength() > 0) {
            return childs;
        }
        return null;
    }

    long getMinOccurs(Element el) {
        try {
            if (el.getAttributeNode("minOccurs") != null) {
                String value = el.getAttribute("minOccurs");
                if (value.equals("unbounded")) {
                    return Long.MAX_VALUE;
                }
                return Long.parseLong(value);
            }
            return 1L;
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    long getMaxOccurs(Element el) {
        try {
            if (el.getAttributeNode("maxOccurs") != null) {
                String value = el.getAttribute("maxOccurs");
                if (value.equals("unbounded")) {
                    return Long.MAX_VALUE;
                }
                return Long.parseLong(value);
            }
            return 1L;
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    XmlSchemaForm getFormDefault(Element el, String attrName) {
        if (el.getAttributeNode(attrName) != null) {
            String value = el.getAttribute(attrName);
            return new XmlSchemaForm(value);
        }
        return new XmlSchemaForm("unqualified");
    }

    XmlSchemaDerivationMethod getDerivation(Element el, String attrName) {
        if (el.hasAttribute(attrName) && !el.getAttribute(attrName).equals("")) {
            String derivationMethod = el.getAttribute(attrName).trim();
            if (derivationMethod.equals("#all")) {
                return new XmlSchemaDerivationMethod("all");
            }
            return new XmlSchemaDerivationMethod(derivationMethod);
        }
        return new XmlSchemaDerivationMethod("none");
    }

    String getEnumString(Element el, String attrName) {
        if (el.hasAttribute(attrName)) {
            return el.getAttribute(attrName).trim();
        }
        return "none";
    }

    XmlSchema resolveXmlSchema(String targetNamespace, String schemaLocation, String baseUri, TargetNamespaceValidator validator) {
        InputSource source = this.collection.schemaResolver.resolveEntity(targetNamespace, schemaLocation, baseUri);
        String systemId = source.getSystemId() == null ? schemaLocation : source.getSystemId();
        XmlSchemaCollection.SchemaKey key = new XmlSchemaCollection.SchemaKey(targetNamespace, systemId);
        XmlSchema schema = this.collection.getSchema(key);
        if (schema != null) {
            return schema;
        }
        if (this.collection.check(key)) {
            this.collection.push(key);
            try {
                XmlSchema xmlSchema = this.collection.read(source, null, validator);
                return xmlSchema;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.collection.pop();
            }
        }
        return null;
    }

    XmlSchema resolveXmlSchema(String targetNamespace, String schemaLocation, TargetNamespaceValidator validator) {
        return this.resolveXmlSchema(targetNamespace, schemaLocation, this.collection.baseUri, validator);
    }

    private void processExtensibilityComponents(XmlSchemaObject schemaObject, Element parentElement) {
        if (this.extReg != null) {
            NamedNodeMap attributes = parentElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String namespaceURI = attribute.getNamespaceURI();
                String name = attribute.getLocalName();
                if (namespaceURI == null || "".equals(namespaceURI) || name.startsWith("xmlns") || "http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) continue;
                QName qName = new QName(namespaceURI, name);
                this.extReg.deserializeExtension(schemaObject, qName, attribute);
            }
            NodeList allChildren = parentElement.getChildNodes();
            for (int i = 0; i < allChildren.getLength(); ++i) {
                if (allChildren.item(i).getNodeType() != 1) continue;
                Element extElement = (Element)allChildren.item(i);
                String namespaceURI = extElement.getNamespaceURI();
                String name = extElement.getLocalName();
                if (namespaceURI == null || "http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) continue;
                QName qName = new QName(namespaceURI, name);
                this.extReg.deserializeExtension(schemaObject, qName, extElement);
            }
        }
    }
}

