/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.truth.xml.Filter;
import org.apache.axiom.truth.xml.spi.Event;
import org.apache.axiom.truth.xml.spi.Traverser;
import org.apache.axiom.truth.xml.spi.TraverserException;

final class RedundantNamespaceDeclarationFilter
extends Filter {
    private static final Map<String, String> implicitNamespaces = new HashMap<String, String>();
    private final List<Map<String, String>> stack = new ArrayList<Map<String, String>>(10);

    RedundantNamespaceDeclarationFilter(Traverser parent) {
        super(parent);
        this.stack.add(implicitNamespaces);
    }

    private String lookupNamespaceURI(String prefix) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            String namespaceURI;
            Map<String, String> namespaces = this.stack.get(i);
            if (namespaces == null || (namespaceURI = namespaces.get(prefix)) == null) continue;
            return namespaceURI;
        }
        return null;
    }

    @Override
    public Event next() throws TraverserException {
        Event event = super.next();
        if (event == Event.START_ELEMENT) {
            Map<String, String> namespaces = super.getNamespaces();
            if (namespaces != null) {
                Iterator<Map.Entry<String, String>> it = namespaces.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> namespace = it.next();
                    if (!namespace.getValue().equals(this.lookupNamespaceURI(namespace.getKey()))) continue;
                    it.remove();
                }
                if (namespaces.isEmpty()) {
                    namespaces = null;
                }
            }
            this.stack.add(namespaces);
        } else if (event == Event.END_ELEMENT) {
            this.stack.remove(this.stack.size() - 1);
        }
        return event;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.stack.get(this.stack.size() - 1);
    }

    static {
        implicitNamespaces.put("", "");
        implicitNamespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        implicitNamespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
    }
}

