/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.truth.xml.CoalescingFilter;
import org.apache.axiom.truth.xml.Filter;
import org.apache.axiom.truth.xml.RedundantNamespaceDeclarationFilter;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.truth.xml.spi.Event;
import org.apache.axiom.truth.xml.spi.Traverser;
import org.apache.axiom.truth.xml.spi.TraverserException;
import org.apache.axiom.truth.xml.spi.XML;

public final class XMLSubject
extends Subject {
    private final XML xml;
    private boolean ignoreComments;
    private boolean ignoreElementContentWhitespace;
    private boolean ignoreWhitespace;
    private boolean ignoreWhitespaceInPrologAndEpilog;
    private boolean ignorePrologAndEpilog;
    private boolean ignoreNamespaceDeclarations;
    private boolean ignoreNamespacePrefixes;
    private boolean ignoreRedundantNamespaceDeclarations;
    private boolean expandEntityReferences;
    private boolean treatWhitespaceAsText;

    XMLSubject(FailureMetadata metadata, Object subject) {
        super(metadata, subject);
        this.xml = XMLTruth.xml(subject);
    }

    public XMLSubject ignoringComments() {
        return this.ignoringComments(true);
    }

    public XMLSubject ignoringComments(boolean value) {
        this.ignoreComments = value;
        return this;
    }

    public XMLSubject ignoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace(true);
    }

    public XMLSubject ignoringElementContentWhitespace(boolean value) {
        this.ignoreElementContentWhitespace = true;
        return this;
    }

    public XMLSubject ignoringWhitespace() {
        return this.ignoringWhitespace(true);
    }

    public XMLSubject ignoringWhitespace(boolean value) {
        this.ignoreWhitespace = value;
        return this;
    }

    public XMLSubject ignoringWhitespaceInPrologAndEpilog() {
        return this.ignoringWhitespaceInPrologAndEpilog(true);
    }

    public XMLSubject ignoringWhitespaceInPrologAndEpilog(boolean value) {
        this.ignoreWhitespaceInPrologAndEpilog = value;
        return this;
    }

    public XMLSubject ignoringPrologAndEpilog() {
        return this.ignoringPrologAndEpilog(true);
    }

    public XMLSubject ignoringPrologAndEpilog(boolean value) {
        this.ignorePrologAndEpilog = value;
        return this;
    }

    public XMLSubject ignoringNamespaceDeclarations() {
        return this.ignoringNamespaceDeclarations(true);
    }

    public XMLSubject ignoringNamespaceDeclarations(boolean value) {
        this.ignoreNamespaceDeclarations = value;
        return this;
    }

    public XMLSubject ignoringNamespacePrefixes() {
        return this.ignoringNamespacePrefixes(true);
    }

    public XMLSubject ignoringNamespacePrefixes(boolean value) {
        this.ignoreNamespacePrefixes = value;
        return this;
    }

    public XMLSubject ignoringRedundantNamespaceDeclarations() {
        return this.ignoringRedundantNamespaceDeclarations(true);
    }

    public XMLSubject ignoringRedundantNamespaceDeclarations(boolean value) {
        this.ignoreRedundantNamespaceDeclarations = value;
        return this;
    }

    public XMLSubject expandingEntityReferences() {
        return this.expandingEntityReferences(true);
    }

    public XMLSubject expandingEntityReferences(boolean value) {
        this.expandEntityReferences = value;
        return this;
    }

    public XMLSubject treatingElementContentWhitespaceAsText() {
        return this.treatingElementContentWhitespaceAsText(true);
    }

    public XMLSubject treatingElementContentWhitespaceAsText(boolean value) {
        this.treatWhitespaceAsText = value;
        return this;
    }

    private Traverser createTraverser(XML xml) throws TraverserException {
        Traverser traverser = xml.createTraverser(this.expandEntityReferences);
        if (this.ignoreWhitespaceInPrologAndEpilog || this.ignorePrologAndEpilog) {
            final boolean onlyWhitespace = !this.ignorePrologAndEpilog;
            traverser = new Filter(traverser){
                private int depth;

                @Override
                public Event next() throws TraverserException {
                    Event event;
                    block5: while ((event = super.next()) != null) {
                        switch (event) {
                            case START_ELEMENT: {
                                ++this.depth;
                                break block5;
                            }
                            case END_ELEMENT: {
                                --this.depth;
                                break block5;
                            }
                            default: {
                                if (onlyWhitespace) break block5;
                            }
                            case WHITESPACE: {
                                if (this.depth == 0) continue block5;
                            }
                        }
                    }
                    return event;
                }
            };
        }
        final HashSet<Event> ignoredEvents = new HashSet<Event>();
        if (this.ignoreComments) {
            ignoredEvents.add(Event.COMMENT);
        }
        if (this.ignoreWhitespace || this.ignoreElementContentWhitespace) {
            ignoredEvents.add(Event.WHITESPACE);
        }
        if (!ignoredEvents.isEmpty()) {
            traverser = new Filter(traverser){

                @Override
                public Event next() throws TraverserException {
                    Event event;
                    while (ignoredEvents.contains((Object)(event = super.next()))) {
                    }
                    return event;
                }
            };
        }
        traverser = new CoalescingFilter(traverser);
        if (this.ignoreWhitespace) {
            traverser = new Filter(traverser){

                @Override
                public Event next() throws TraverserException {
                    Event event = super.next();
                    if (event == Event.TEXT) {
                        String text = this.getText();
                        for (int i = 0; i < text.length(); ++i) {
                            if (" \r\n\t".indexOf(text.charAt(i)) != -1) continue;
                            return Event.TEXT;
                        }
                        return super.next();
                    }
                    return event;
                }
            };
        }
        if (this.ignoreRedundantNamespaceDeclarations && !this.ignoreNamespaceDeclarations) {
            traverser = new RedundantNamespaceDeclarationFilter(traverser);
        }
        return traverser;
    }

    private static Map<QName, String> extractPrefixes(Set<QName> qnames) {
        HashMap<QName, String> result = new HashMap<QName, String>();
        for (QName qname : qnames) {
            result.put(qname, qname.getPrefix());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void hasSameContentAs(Object other) {
        try {
            Traverser actual = this.createTraverser(this.xml);
            XML expectedXML = XMLTruth.xml(other);
            Traverser expected = this.createTraverser(expectedXML);
            block10: while (true) {
                Event actualEvent = actual.next();
                Event expectedEvent = expected.next();
                if (expectedEvent == Event.WHITESPACE || expectedEvent == Event.TEXT) {
                    if (!this.xml.isReportingElementContentWhitespace()) {
                        Truth.assertThat((Comparable)((Object)actualEvent)).isEqualTo((Object)Event.TEXT);
                    } else if (this.treatWhitespaceAsText || !expectedXML.isReportingElementContentWhitespace()) {
                        Truth.assertThat((Comparable)((Object)actualEvent)).isAnyOf((Object)Event.WHITESPACE, (Object)Event.TEXT, new Object[0]);
                    } else {
                        Truth.assertThat((Comparable)((Object)actualEvent)).isEqualTo((Object)expectedEvent);
                    }
                } else {
                    Truth.assertThat((Comparable)((Object)actualEvent)).isEqualTo((Object)expectedEvent);
                }
                if (expectedEvent == null) return;
                switch (expectedEvent) {
                    case DOCUMENT_TYPE: {
                        Truth.assertThat((String)actual.getRootName()).isEqualTo((Object)expected.getRootName());
                        Truth.assertThat((String)actual.getPublicId()).isEqualTo((Object)expected.getPublicId());
                        Truth.assertThat((String)actual.getSystemId()).isEqualTo((Object)expected.getSystemId());
                        continue block10;
                    }
                    case START_ELEMENT: {
                        QName actualQName = actual.getQName();
                        Map<QName, String> actualAttributes = actual.getAttributes();
                        QName expectedQName = expected.getQName();
                        Map<QName, String> expectedAttributes = expected.getAttributes();
                        Truth.assertThat((Object)actualQName).isEqualTo((Object)expectedQName);
                        Truth.assertThat(actualAttributes).isEqualTo(expectedAttributes);
                        if (!this.ignoreNamespacePrefixes) {
                            Truth.assertThat((String)actualQName.getPrefix()).isEqualTo((Object)expectedQName.getPrefix());
                            if (expectedAttributes != null) {
                                Truth.assertThat(XMLSubject.extractPrefixes(actualAttributes.keySet())).isEqualTo(XMLSubject.extractPrefixes(expectedAttributes.keySet()));
                            }
                        }
                        if (this.ignoreNamespaceDeclarations) continue block10;
                        Truth.assertThat(actual.getNamespaces()).isEqualTo(expected.getNamespaces());
                        continue block10;
                    }
                    case END_ELEMENT: {
                        continue block10;
                    }
                    case WHITESPACE: 
                    case TEXT: 
                    case COMMENT: 
                    case CDATA_SECTION: {
                        Truth.assertThat((String)actual.getText()).isEqualTo((Object)expected.getText());
                        continue block10;
                    }
                    case ENTITY_REFERENCE: {
                        if (this.expandEntityReferences) {
                            throw new IllegalStateException();
                        }
                        Truth.assertThat((String)actual.getEntityName()).isEqualTo((Object)expected.getEntityName());
                        continue block10;
                    }
                    case PROCESSING_INSTRUCTION: {
                        Truth.assertThat((String)actual.getPITarget()).isEqualTo((Object)expected.getPITarget());
                        Truth.assertThat((String)actual.getPIData()).isEqualTo((Object)expected.getPIData());
                        continue block10;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (TraverserException ex) {
            throw new RuntimeException(ex);
        }
    }
}

