/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.truth.xml.DOMXML;
import org.apache.axiom.truth.xml.Parsable;
import org.apache.axiom.truth.xml.StAXXML;
import org.apache.axiom.truth.xml.XMLStreamReaderProvider;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.spi.XML;
import org.apache.axiom.truth.xml.spi.XMLFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class XMLTruth {
    private static final Subject.Factory<XMLSubject, Object> SUBJECT_FACTORY = new Subject.Factory<XMLSubject, Object>(){

        public XMLSubject createSubject(FailureMetadata metadata, Object that) {
            return new XMLSubject(metadata, that);
        }
    };
    private static final List<XMLFactory<?>> factories = new ArrayList();

    private XMLTruth() {
    }

    public static Subject.Factory<XMLSubject, Object> xml() {
        return SUBJECT_FACTORY;
    }

    public static <T> Object xml(Class<T> type, T object) {
        return XMLTruth.createXML(type, object);
    }

    private static <T> XML createXML(Class<T> type, T object) {
        XMLFactory<?> factory = null;
        for (XMLFactory<?> candidate : factories) {
            Class<T> expectedType = candidate.getExpectedType();
            if (type != null && !expectedType.isAssignableFrom(type) || !expectedType.isInstance(object)) continue;
            if (factory != null) {
                throw new IllegalArgumentException("Multiple matching XMLFactory instances found");
            }
            factory = candidate;
        }
        if (factory == null) {
            throw new IllegalArgumentException("No XMLFactory found for type " + object.getClass().getName());
        }
        return XMLTruth.createXML0(factory, object);
    }

    static XML xml(Object object) {
        return XMLTruth.createXML(null, object);
    }

    private static <T> XML createXML0(XMLFactory<T> factory, Object object) {
        return factory.createXML(factory.getExpectedType().cast(object));
    }

    static {
        factories.add(new XMLFactory<XML>(){

            @Override
            public Class<XML> getExpectedType() {
                return XML.class;
            }

            @Override
            public XML createXML(XML xml) {
                return xml;
            }
        });
        factories.add(new XMLFactory<InputStream>(){

            @Override
            public Class<InputStream> getExpectedType() {
                return InputStream.class;
            }

            @Override
            public XML createXML(final InputStream in) {
                return new StAXXML(new Parsable(){

                    @Override
                    XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                        return factory.createXMLStreamReader(in);
                    }
                });
            }
        });
        factories.add(new XMLFactory<Reader>(){

            @Override
            public Class<Reader> getExpectedType() {
                return Reader.class;
            }

            @Override
            public XML createXML(final Reader reader) {
                return new StAXXML(new Parsable(){

                    @Override
                    XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                        return factory.createXMLStreamReader(reader);
                    }
                });
            }
        });
        factories.add(new XMLFactory<StreamSource>(){

            @Override
            public Class<StreamSource> getExpectedType() {
                return StreamSource.class;
            }

            @Override
            public XML createXML(final StreamSource source) {
                return new StAXXML(new Parsable(){

                    @Override
                    XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                        return factory.createXMLStreamReader(source);
                    }
                });
            }
        });
        factories.add(new XMLFactory<InputSource>(){

            @Override
            public Class<InputSource> getExpectedType() {
                return InputSource.class;
            }

            @Override
            public XML createXML(InputSource is) {
                StreamSource source = new StreamSource();
                source.setInputStream(is.getByteStream());
                source.setReader(is.getCharacterStream());
                source.setPublicId(is.getPublicId());
                source.setSystemId(is.getSystemId());
                return XMLTruth.xml(source);
            }
        });
        factories.add(new XMLFactory<URL>(){

            @Override
            public Class<URL> getExpectedType() {
                return URL.class;
            }

            @Override
            public XML createXML(URL url) {
                return XMLTruth.xml(new StreamSource(url.toString()));
            }
        });
        factories.add(new XMLFactory<String>(){

            @Override
            public Class<String> getExpectedType() {
                return String.class;
            }

            @Override
            public XML createXML(String xml) {
                return XMLTruth.xml(new StringReader(xml));
            }
        });
        factories.add(new XMLFactory<byte[]>(){

            @Override
            public Class<byte[]> getExpectedType() {
                return byte[].class;
            }

            @Override
            public XML createXML(byte[] bytes) {
                return XMLTruth.xml(new ByteArrayInputStream(bytes));
            }
        });
        factories.add(new XMLFactory<Document>(){

            @Override
            public Class<Document> getExpectedType() {
                return Document.class;
            }

            @Override
            public XML createXML(Document document) {
                return new DOMXML(document);
            }
        });
        factories.add(new XMLFactory<Element>(){

            @Override
            public Class<Element> getExpectedType() {
                return Element.class;
            }

            @Override
            public XML createXML(Element element) {
                return new DOMXML(element);
            }
        });
        factories.add(new XMLFactory<XMLStreamReader>(){

            @Override
            public Class<XMLStreamReader> getExpectedType() {
                return XMLStreamReader.class;
            }

            @Override
            public XML createXML(final XMLStreamReader source) {
                return new StAXXML(new XMLStreamReaderProvider(){

                    @Override
                    XMLStreamReader getXMLStreamReader(boolean expandEntityReferences) throws XMLStreamException {
                        if (expandEntityReferences) {
                            throw new UnsupportedOperationException("Can't expand entity references on a user supplied XMLStreamReader");
                        }
                        return source;
                    }
                });
            }
        });
        for (XMLFactory factory : ServiceLoader.load(XMLFactory.class, XMLTruth.class.getClassLoader())) {
            factories.add(factory);
        }
    }
}

