/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;

public class ByteStreamComparator
extends OutputStream {
    private final InputStream in;
    private final String name1;
    private final String name2;
    private final byte[] compareBuffer = new byte[1024];
    private int position;

    public ByteStreamComparator(InputStream in, String name1, String name2) {
        this.in = in;
        this.name1 = name1;
        this.name2 = name2;
    }

    @Deprecated
    public ByteStreamComparator(InputStream in) {
        this(in, "s1", "s2");
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            int c = this.in.read(this.compareBuffer, 0, Math.min(this.compareBuffer.length, len));
            if (c == -1) {
                Assert.fail((String)("The two streams have different lengths: len(" + this.name1 + ") = " + this.position + " < len(" + this.name2 + ")"));
            }
            for (int i = 0; i < c; ++i) {
                if (buffer[off] != this.compareBuffer[i]) {
                    Assert.fail((String)("Byte mismatch: " + this.name1 + "[" + this.position + "] = " + this.compareBuffer[i] + " != " + this.name2 + "[" + this.position + "] = " + buffer[off]));
                }
                ++off;
                --len;
                ++this.position;
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.in.read() != -1) {
            Assert.fail((String)("The two streams have different lengths: len(" + this.name1 + ") > len(" + this.name2 + ") = " + this.position));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }
}

