/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.stax;

import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.testutils.stax.AttributeSortingXMLStreamReaderFilter;
import org.apache.axiom.testutils.stax.Normalizer;
import org.junit.Assert;

public class XMLStreamReaderComparator {
    private XMLStreamReader expected;
    private XMLStreamReader actual;
    private boolean compareEntityReplacementValue = true;
    private boolean compareCharacterEncodingScheme = true;
    private boolean compareEncoding = true;
    private boolean sortAttributes = false;
    private final LinkedList<QName> path = new LinkedList();
    private final Set<String> prefixes = new HashSet<String>();
    private final Set<String> namespaceURIs = new HashSet<String>();

    public XMLStreamReaderComparator(XMLStreamReader expected, XMLStreamReader actual) {
        this.expected = expected;
        this.actual = actual;
    }

    private String getLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("event type ");
        buffer.append(this.expected.getEventType());
        buffer.append("; location ");
        for (QName qname : this.path) {
            buffer.append('/');
            buffer.append(qname);
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] invoke(String methodName, Class<?>[] paramTypes, Object[] args) throws Exception {
        Throwable actualException;
        Object actualResult;
        Throwable expectedException;
        Object expectedResult;
        Method method = XMLStreamReader.class.getMethod(methodName, paramTypes);
        try {
            expectedResult = method.invoke((Object)this.expected, args);
            expectedException = null;
        }
        catch (InvocationTargetException ex) {
            expectedResult = null;
            expectedException = ex.getCause();
        }
        try {
            actualResult = method.invoke((Object)this.actual, args);
            actualException = null;
        }
        catch (InvocationTargetException ex) {
            actualResult = null;
            actualException = ex.getCause();
        }
        if (expectedException == null) {
            if (actualException == null) return new Object[]{expectedResult, actualResult};
            actualException.printStackTrace(System.out);
            Assert.fail((String)("Method " + methodName + " threw unexpected exception " + actualException.getClass().getName() + " (" + this.getLocation() + ")"));
            return null;
        } else if (actualException == null) {
            Assert.fail((String)("Expected " + methodName + " to throw " + expectedException.getClass().getName() + ", but the method returned normally (" + this.getLocation() + ")"));
            return null;
        } else {
            Assert.assertEquals((String)("Unexpected exception thrown by " + methodName), expectedException.getClass(), actualException.getClass());
        }
        return null;
    }

    private Object[] invoke(String methodName) throws Exception {
        return this.invoke(methodName, new Class[0], new Object[0]);
    }

    private Object assertSameResult(String methodName, Class<?>[] paramTypes, Object[] args, Normalizer normalizer) throws Exception {
        Object[] results = this.invoke(methodName, paramTypes, args);
        if (results != null) {
            Object expected = normalizer.normalize(results[0]);
            Object actual = normalizer.normalize(results[1]);
            Assert.assertEquals((String)("Return value of " + methodName + " for arguments " + Arrays.asList(args) + " (" + this.getLocation() + ")"), (Object)expected, (Object)actual);
            return results[0];
        }
        return null;
    }

    private Object assertSameResult(String methodName, Class<?>[] paramTypes, Object[] args) throws Exception {
        return this.assertSameResult(methodName, paramTypes, args, Normalizer.IDENTITY);
    }

    private Object assertSameResult(String methodName, Normalizer normalizer) throws Exception {
        return this.assertSameResult(methodName, new Class[0], new Object[0], normalizer);
    }

    private Object assertSameResult(String methodName) throws Exception {
        return this.assertSameResult(methodName, Normalizer.IDENTITY);
    }

    private Set<String> toPrefixSet(Iterator<?> it) {
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            set.add(prefix == null ? "" : prefix);
        }
        return set;
    }

    private void compareNamespaceContexts(NamespaceContext expected, NamespaceContext actual) {
        for (String prefix : this.prefixes) {
            if (prefix == null) continue;
            Assert.assertEquals((String)("Namespace URI for prefix '" + prefix + "' (" + this.getLocation() + ")"), (Object)expected.getNamespaceURI(prefix), (Object)actual.getNamespaceURI(prefix));
        }
        for (String namespaceURI : this.namespaceURIs) {
            if (namespaceURI == null || namespaceURI.length() <= 0) continue;
            Set<String> prefixes = this.toPrefixSet(expected.getPrefixes(namespaceURI));
            Assert.assertEquals((String)("Prefixes for namespace URI '" + namespaceURI + "' (" + this.getLocation() + ")"), prefixes, this.toPrefixSet(actual.getPrefixes(namespaceURI)));
            if (prefixes.size() <= 1) {
                Assert.assertEquals((String)("Prefix for namespace URI '" + namespaceURI + "' (" + this.getLocation() + ")"), (Object)expected.getPrefix(namespaceURI), (Object)actual.getPrefix(namespaceURI));
                continue;
            }
            Truth.assertThat((String)actual.getPrefix(namespaceURI)).isIn(prefixes);
        }
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void setCompareEntityReplacementValue(boolean value) {
        this.compareEntityReplacementValue = value;
    }

    public void setCompareCharacterEncodingScheme(boolean value) {
        this.compareCharacterEncodingScheme = value;
    }

    public void setCompareEncoding(boolean value) {
        this.compareEncoding = value;
    }

    public void setSortAttributes(boolean sortAttributes) {
        this.sortAttributes = sortAttributes;
    }

    public void compare() throws Exception {
        if (this.sortAttributes) {
            this.expected = new AttributeSortingXMLStreamReaderFilter(this.expected);
            this.actual = new AttributeSortingXMLStreamReaderFilter(this.actual);
        }
        while (true) {
            int expectedNextEvent;
            int i;
            int eventType;
            if ((eventType = ((Integer)this.assertSameResult("getEventType")).intValue()) == 1) {
                this.path.addLast(this.expected.getName());
            }
            if (this.compareCharacterEncodingScheme) {
                this.assertSameResult("getCharacterEncodingScheme");
            }
            if (this.compareEncoding) {
                this.assertSameResult("getEncoding", Normalizer.LOWER_CASE);
            }
            Integer attributeCount = (Integer)this.assertSameResult("getAttributeCount");
            for (i = 0; i < (attributeCount == null ? 1 : attributeCount); ++i) {
                Class[] paramTypes = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{new Integer(i)};
                this.assertSameResult("getAttributeLocalName", paramTypes, args);
                this.assertSameResult("getAttributeName", paramTypes, args);
                this.namespaceURIs.add((String)this.assertSameResult("getAttributeNamespace", paramTypes, args));
                this.prefixes.add((String)this.assertSameResult("getAttributePrefix", paramTypes, args, Normalizer.EMPTY_STRING_TO_NULL));
                this.assertSameResult("getAttributeType", paramTypes, args);
                this.assertSameResult("getAttributeValue", paramTypes, args);
                this.assertSameResult("isAttributeSpecified", paramTypes, args);
            }
            if (attributeCount != null) {
                for (i = 0; i < attributeCount; ++i) {
                    QName qname = this.expected.getAttributeName(i);
                    this.assertSameResult("getAttributeValue", new Class[]{String.class, String.class}, new Object[]{qname.getNamespaceURI(), qname.getLocalPart()});
                }
            }
            this.assertSameResult("getLocalName");
            this.assertSameResult("getName");
            Integer namespaceCount = (Integer)this.assertSameResult("getNamespaceCount");
            if (namespaceCount != null) {
                HashMap<String, String> expectedNamespaces = new HashMap<String, String>();
                HashMap<String, String> actualNamespaces = new HashMap<String, String>();
                for (int i2 = 0; i2 < namespaceCount; ++i2) {
                    String expectedPrefix = this.expected.getNamespacePrefix(i2);
                    String expectedNamespaceURI = this.expected.getNamespaceURI(i2);
                    if (expectedNamespaceURI != null && expectedNamespaceURI.length() == 0) {
                        expectedNamespaceURI = null;
                    }
                    String actualPrefix = this.actual.getNamespacePrefix(i2);
                    String actualNamespaceURI = this.actual.getNamespaceURI(i2);
                    if (actualNamespaceURI != null && actualNamespaceURI.length() == 0) {
                        actualNamespaceURI = null;
                    }
                    expectedNamespaces.put(expectedPrefix, expectedNamespaceURI);
                    actualNamespaces.put(actualPrefix, actualNamespaceURI);
                    this.prefixes.add(expectedPrefix);
                    this.namespaceURIs.add(expectedNamespaceURI);
                }
                Assert.assertEquals(expectedNamespaces, actualNamespaces);
            }
            this.namespaceURIs.add((String)this.assertSameResult("getNamespaceURI"));
            this.assertSameResult("getPIData");
            this.assertSameResult("getPITarget");
            this.prefixes.add((String)this.assertSameResult("getPrefix"));
            if (eventType != 9 || this.compareEntityReplacementValue) {
                this.assertSameResult("getText", eventType == 11 ? Normalizer.DTD : Normalizer.IDENTITY);
            }
            Integer textLength = (Integer)this.assertSameResult("getTextLength");
            Object[] textStart = this.invoke("getTextStart");
            Object[] textCharacters = this.invoke("getTextCharacters");
            if (textLength != null) {
                Assert.assertEquals((Object)new String((char[])textCharacters[0], (int)((Integer)textStart[0]), (int)textLength), (Object)new String((char[])textCharacters[1], (int)((Integer)textStart[1]), (int)textLength));
            }
            this.assertSameResult("hasName");
            this.assertSameResult("hasText");
            this.assertSameResult("isCharacters");
            this.assertSameResult("isEndElement");
            this.assertSameResult("isStartElement");
            this.assertSameResult("isWhiteSpace");
            if (eventType == 1 || eventType == 2) {
                for (String prefix : this.prefixes) {
                    if (prefix == null || prefix.equals("xml")) continue;
                    this.assertSameResult("getNamespaceURI", new Class[]{String.class}, new Object[]{prefix});
                }
            }
            this.compareNamespaceContexts(this.expected.getNamespaceContext(), this.actual.getNamespaceContext());
            if (eventType == 2) {
                this.path.removeLast();
            }
            this.assertSameResult("hasNext");
            try {
                expectedNextEvent = this.expected.next();
            }
            catch (IllegalStateException ex) {
                expectedNextEvent = -1;
            }
            catch (NoSuchElementException ex) {
                expectedNextEvent = -1;
            }
            if (expectedNextEvent == -1) {
                try {
                    this.actual.next();
                }
                catch (IllegalStateException ex) {
                    break;
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                Assert.fail((String)"Expected reader to throw IllegalStateException or NoSuchElementException");
                continue;
            }
            Assert.assertEquals((String)("Event type at " + this.getLocation()), (long)expectedNextEvent, (long)this.actual.next());
        }
    }
}

