/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws;

import org.apache.axiom.testutils.suite.MatrixTestSuiteBuilder;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.springws.MessageFactoryConfigurator;
import org.apache.axiom.ts.springws.scenario.ScenarioConfig;
import org.apache.axiom.ts.springws.scenario.broker.BrokerScenarioTest;
import org.apache.axiom.ts.springws.scenario.castor.CastorTest;
import org.apache.axiom.ts.springws.scenario.jaxb2.JAXB2Test;
import org.apache.axiom.ts.springws.scenario.jdom.ClientServerTest;
import org.apache.axiom.ts.springws.scenario.secureecho.SecureEchoTest;
import org.apache.axiom.ts.springws.scenario.soapaction.SoapActionTest;
import org.apache.axiom.ts.springws.scenario.validation.ValidationTest;
import org.apache.axiom.ts.springws.scenario.wsadom.WSAddressingDOMTest;
import org.apache.axiom.ts.springws.soap.messagefactory.TestCreateWebServiceMessage;
import org.apache.axiom.ts.springws.soap.messagefactory.TestCreateWebServiceMessageFromInputStream;
import org.apache.axiom.ts.springws.soap.messagefactory.TestCreateWebServiceMessageFromInputStreamMTOM;
import org.apache.axiom.ts.springws.soap.messagefactory.TestCreateWebServiceMessageFromInputStreamVersionMismatch;

public class SpringWSTestSuiteBuilder
extends MatrixTestSuiteBuilder {
    private final MessageFactoryConfigurator messageFactoryConfigurator;
    private final MessageFactoryConfigurator altMessageFactoryConfigurator;

    public SpringWSTestSuiteBuilder(MessageFactoryConfigurator messageFactoryConfigurator, MessageFactoryConfigurator altMessageFactoryConfigurator) {
        this.messageFactoryConfigurator = messageFactoryConfigurator;
        this.altMessageFactoryConfigurator = altMessageFactoryConfigurator;
    }

    protected void addTests() {
        this.addSimpleTests(this.messageFactoryConfigurator, SOAPSpec.SOAP11);
        this.addSimpleTests(this.messageFactoryConfigurator, SOAPSpec.SOAP12);
        this.addTest(new TestCreateWebServiceMessageFromInputStreamMTOM(this.messageFactoryConfigurator));
        this.addScenarioTests(new ScenarioConfig(this.altMessageFactoryConfigurator, this.messageFactoryConfigurator), SOAPSpec.SOAP11);
        this.addScenarioTests(new ScenarioConfig(this.altMessageFactoryConfigurator, this.messageFactoryConfigurator), SOAPSpec.SOAP12);
        if (this.altMessageFactoryConfigurator != this.messageFactoryConfigurator) {
            this.addScenarioTests(new ScenarioConfig(this.messageFactoryConfigurator, this.altMessageFactoryConfigurator), SOAPSpec.SOAP11);
            this.addScenarioTests(new ScenarioConfig(this.messageFactoryConfigurator, this.altMessageFactoryConfigurator), SOAPSpec.SOAP12);
        }
    }

    private void addSimpleTests(MessageFactoryConfigurator mfc, SOAPSpec spec) {
        this.addTest(new TestCreateWebServiceMessage(mfc, spec));
        this.addTest(new TestCreateWebServiceMessageFromInputStream(mfc, spec));
        this.addTest(new TestCreateWebServiceMessageFromInputStreamVersionMismatch(mfc, spec));
    }

    private void addScenarioTests(ScenarioConfig config, SOAPSpec spec) {
        this.addTest(new ClientServerTest(config, spec));
        this.addTest(new WSAddressingDOMTest(config, spec));
        this.addTest(new JAXB2Test(config, spec));
        this.addTest(new CastorTest(config, spec));
        this.addTest(new BrokerScenarioTest(config, spec));
        this.addTest(new ValidationTest(config, spec));
        this.addTest(new SecureEchoTest(config, spec));
        this.addTest(new SoapActionTest(config, spec));
    }
}

