/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws.scenario;

import javax.servlet.Servlet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.springws.SpringWSTestCase;
import org.apache.axiom.ts.springws.scenario.ScenarioConfig;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.env.MockPropertySource;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.ws.transport.http.MessageDispatcherServlet;

public abstract class ScenarioTestCase
extends SpringWSTestCase {
    private final ScenarioConfig config;
    private Server server;
    protected GenericXmlApplicationContext context;

    public ScenarioTestCase(ScenarioConfig config, SOAPSpec spec) {
        super(spec);
        this.config = config;
        this.addTestParameter("client", config.getClientMessageFactoryConfigurator().getName());
        this.addTestParameter("server", config.getServerMessageFactoryConfigurator().getName());
    }

    protected void setUp() throws Exception {
        this.server = new Server();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("jetty");
        this.server.setThreadPool((ThreadPool)threadPool);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(0);
        this.server.setConnectors(new Connector[]{connector});
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.server, "/");
        MessageDispatcherServlet servlet = new MessageDispatcherServlet();
        servlet.setContextClass(GenericWebApplicationContext.class);
        servlet.setContextInitializers(new ApplicationContextInitializer[]{new ApplicationContextInitializer<ConfigurableApplicationContext>(){

            public void initialize(ConfigurableApplicationContext applicationContext) {
                ScenarioTestCase.this.configureContext((GenericApplicationContext)((GenericWebApplicationContext)applicationContext), ScenarioTestCase.this.config.getServerMessageFactoryConfigurator(), (Resource)new ClassPathResource("server.xml", ((Object)((Object)ScenarioTestCase.this)).getClass()));
            }
        }});
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setName("spring-ws");
        servletHolder.setInitOrder(1);
        handler.addServlet(servletHolder, "/*");
        this.server.start();
        this.context = new GenericXmlApplicationContext();
        MockPropertySource propertySource = new MockPropertySource("client-properties");
        propertySource.setProperty("port", (Object)connector.getLocalPort());
        this.context.getEnvironment().getPropertySources().replace("systemEnvironment", (PropertySource)propertySource);
        this.configureContext((GenericApplicationContext)this.context, this.config.getClientMessageFactoryConfigurator(), (Resource)new ClassPathResource("client.xml", ((Object)((Object)this)).getClass()));
        this.context.refresh();
    }

    protected void tearDown() throws Exception {
        this.context.close();
        this.context = null;
        this.server.stop();
        this.server = null;
    }
}

