/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws.scenario.jdom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;

@Endpoint
public class CalculatorEndpoint {
    private static final Log log = LogFactory.getLog(CalculatorEndpoint.class);
    private static final String NAMESPACE_URI = "urn:calculator";
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"c", (String)"urn:calculator");
    private XPathExpression<Element> operandExpression = XPathFactory.instance().compile("c:Operand", Filters.element(), null, new Namespace[]{NAMESPACE});

    @PayloadRoot(namespace="urn:calculator", localPart="AddRequest")
    @ResponsePayload
    public Element add(@RequestPayload Element addRequest) throws Exception {
        log.debug((Object)"Endpoint invoked");
        double sum = 0.0;
        for (Element operand : this.operandExpression.evaluate((Object)addRequest)) {
            sum += Double.parseDouble(operand.getTextNormalize());
        }
        Element response = new Element("AddResponse", NAMESPACE);
        response.setText(String.valueOf(sum));
        return response;
    }
}

