/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws.soap.messagefactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import org.apache.axiom.ts.soap.SOAPSample;
import org.springframework.ws.transport.TransportInputStream;

final class TransportInputStreamImpl
extends TransportInputStream {
    private final SOAPSample sample;

    TransportInputStreamImpl(SOAPSample sample) {
        this.sample = sample;
    }

    protected InputStream createInputStream() throws IOException {
        return this.sample.getInputStream();
    }

    public Iterator<String> getHeaderNames() throws IOException {
        return Collections.singleton("Content-Type").iterator();
    }

    public Iterator<String> getHeaders(String name) throws IOException {
        if (name.equalsIgnoreCase("Content-Type")) {
            return Collections.singleton(this.sample.getSOAPSpec().getContentType() + "; charset=\"" + this.sample.getEncoding() + "\"").iterator();
        }
        return Collections.emptySet().iterator();
    }
}

