/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.ts.soap.SOAPFaultChild;
import org.apache.axiom.ts.soap.SOAPSpec;

public abstract class SOAPElementType
extends Multiton {
    public static final SOAPElementType ENVELOPE = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getEnvelopeQName();
        }
    };
    public static final SOAPElementType HEADER = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getHeaderQName();
        }
    };
    public static final SOAPElementType BODY = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getBodyQName();
        }
    };
    public static final SOAPElementType FAULT = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getFaultQName();
        }
    };
    public static final SOAPElementType VALUE = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getFaultValueQName();
        }
    };
    public static final SOAPElementType SUB_CODE = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getFaultSubCodeQName();
        }
    };
    public static final SOAPElementType TEXT = new SOAPElementType(){

        @Override
        public QName getQName(SOAPSpec spec) {
            return spec.getFaultTextQName();
        }
    };
    private static final SOAPElementType[] allTypes = new SOAPElementType[]{ENVELOPE, HEADER, BODY, FAULT, SOAPFaultChild.CODE, VALUE, SUB_CODE, SOAPFaultChild.REASON, TEXT, SOAPFaultChild.NODE, SOAPFaultChild.ROLE, SOAPFaultChild.DETAIL};
    private final List<SOAPElementType> parentTypes = new ArrayList<SOAPElementType>();
    private final List<SOAPElementType> childTypes = new ArrayList<SOAPElementType>();

    SOAPElementType() {
    }

    private static void addRelation(SOAPElementType parentType, SOAPElementType childType) {
        parentType.childTypes.add(childType);
        childType.parentTypes.add(parentType);
    }

    public static SOAPElementType[] getAll() {
        return (SOAPElementType[])allTypes.clone();
    }

    public abstract QName getQName(SOAPSpec var1);

    public SOAPElementType[] getParentTypes() {
        return this.parentTypes.toArray(new SOAPElementType[this.parentTypes.size()]);
    }

    public SOAPElementType[] getChildTypes() {
        return this.childTypes.toArray(new SOAPElementType[this.childTypes.size()]);
    }

    static {
        SOAPElementType.addRelation(ENVELOPE, HEADER);
        SOAPElementType.addRelation(ENVELOPE, BODY);
        SOAPElementType.addRelation(BODY, FAULT);
        SOAPElementType.addRelation(FAULT, SOAPFaultChild.CODE);
        SOAPElementType.addRelation(SOAPFaultChild.CODE, SOAPFaultChild.VALUE);
        SOAPElementType.addRelation(SOAPFaultChild.CODE, SOAPFaultChild.SUB_CODE);
        SOAPElementType.addRelation(SOAPFaultChild.SUB_CODE, SOAPFaultChild.VALUE);
        SOAPElementType.addRelation(SOAPFaultChild.SUB_CODE, SOAPFaultChild.SUB_CODE);
        SOAPElementType.addRelation(FAULT, SOAPFaultChild.REASON);
        SOAPElementType.addRelation(SOAPFaultChild.REASON, SOAPFaultChild.TEXT);
        SOAPElementType.addRelation(FAULT, SOAPFaultChild.NODE);
        SOAPElementType.addRelation(FAULT, SOAPFaultChild.ROLE);
        SOAPElementType.addRelation(FAULT, SOAPFaultChild.DETAIL);
    }
}

