/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.buildutils.classes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.buildutils.classes.GetDataHandlerBridgeMethodInjector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

@Mojo(name="post-process-classes", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class PostProcessMojo
extends AbstractMojo {
    @Parameter(property="project.build.outputDirectory", required=true, readonly=true)
    private File classesDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.classesDir.exists()) {
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(new String[]{"**/*.class"});
        ds.setBasedir(this.classesDir);
        ds.scan();
        for (String relativePath : ds.getIncludedFiles()) {
            ClassWriter classWriter;
            File file = new File(this.classesDir, relativePath);
            try (FileInputStream in = new FileInputStream(file);){
                ClassReader classReader = new ClassReader((InputStream)in);
                Object classVisitor = classWriter = new ClassWriter(classReader, 0);
                if (relativePath.equals("org/apache/axiom/om/OMText.class") || relativePath.equals("org/apache/axiom/om/impl/llom/AxiomCharacterDataNodeImpl.class") || relativePath.equals("org/apache/axiom/om/impl/dom/DOMTextNodeImpl.class")) {
                    classVisitor = new GetDataHandlerBridgeMethodInjector((ClassVisitor)classVisitor);
                }
                classReader.accept((ClassVisitor)classVisitor, 0);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to read " + relativePath + ": " + ex.getMessage(), (Exception)ex);
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                ((OutputStream)out).write(classWriter.toByteArray());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to write " + relativePath + ": " + ex.getMessage(), (Exception)ex);
            }
        }
    }
}

