/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.commons.io.input.ReaderInputStream;

public class TextBlob
implements Blob {
    private final String content;
    private final Charset charset;

    public TextBlob(String content, Charset charset) {
        this.content = content;
        this.charset = charset;
    }

    public InputStream getInputStream() throws IOException {
        return new ReaderInputStream((Reader)new StringReader(this.content), this.charset);
    }

    public void writeTo(OutputStream out) throws StreamCopyException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, this.charset);
            writer.write(this.content);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            throw new StreamCopyException(2, ex);
        }
    }

    public long getSize() {
        return -1L;
    }
}

