/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom.util;

import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.exception.XMLComparisonException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLComparator {
    private static final Log log = LogFactory.getLog(XMLComparator.class);
    private Vector ignorableNamespaceList = new Vector();

    public void addIgnorableNamespace(String nsURI) {
        this.ignorableNamespaceList.add(nsURI);
    }

    public void clearIgnorableNamespaces() {
        this.ignorableNamespaceList.clear();
    }

    public boolean compare(OMElement elementOne, OMElement elementTwo) throws XMLComparisonException {
        if (this.isIgnorable(elementOne) || this.isIgnorable(elementTwo)) {
            return true;
        }
        if (elementOne == null && elementTwo == null) {
            log.info((Object)"Both Elements are null.");
            return true;
        }
        if (elementOne == null && elementTwo != null) {
            throw new XMLComparisonException("Element One is null and Element Two is not null");
        }
        if (elementOne != null && elementTwo == null) {
            throw new XMLComparisonException("Element Two is null and Element One is not null");
        }
        log.info((Object)("Now Checking " + elementOne.getLocalName() + " and " + elementTwo.getLocalName() + "============================="));
        log.info((Object)"Comparing Element Names .......");
        this.compare("Elements names are not equal. ", elementOne.getLocalName(), elementTwo.getLocalName());
        log.info((Object)"Comparing Namespaces .........");
        this.compare("Element namespaces are not equal", elementOne.getNamespace(), elementTwo.getNamespace());
        log.info((Object)"Comparing attributes .....");
        this.compareAllAttributes(elementOne, elementTwo);
        log.info((Object)"Comparing texts .....");
        this.compare("Elements texts are not equal ", elementOne.getText().trim(), elementTwo.getText().trim());
        log.info((Object)"Comparing Children ......");
        this.compareAllChildren(elementOne, elementTwo);
        return true;
    }

    private void compareAllAttributes(OMElement elementOne, OMElement elementTwo) throws XMLComparisonException {
        this.compareAttibutes(elementOne, elementTwo);
        this.compareAttibutes(elementTwo, elementOne);
    }

    private void compareAllChildren(OMElement elementOne, OMElement elementTwo) throws XMLComparisonException {
        this.compareChildren(elementOne, elementTwo);
        this.compareChildren(elementTwo, elementOne);
    }

    private boolean isIgnorable(OMElement elt) {
        if (elt != null) {
            OMNamespace namespace = elt.getNamespace();
            if (namespace != null) {
                return this.ignorableNamespaceList.contains(namespace.getNamespaceURI());
            }
            return false;
        }
        return false;
    }

    private void compareChildren(OMElement elementOne, OMElement elementTwo) throws XMLComparisonException {
        if (this.isIgnorable(elementOne) || this.isIgnorable(elementTwo)) {
            return;
        }
        Iterator elementOneChildren = elementOne.getChildren();
        while (elementOneChildren.hasNext()) {
            OMNode omNode = (OMNode)elementOneChildren.next();
            if (!(omNode instanceof OMElement)) continue;
            OMElement elementOneChild = (OMElement)omNode;
            OMElement elementTwoChild = null;
            if (!this.isIgnorable(elementOneChild) && !this.isIgnorable(elementTwoChild = elementTwo.getFirstChildWithName(elementOneChild.getQName())) && elementTwoChild == null) {
                throw new XMLComparisonException(" There is no " + elementOneChild.getLocalName() + " element under " + elementTwo.getLocalName());
            }
            this.compare(elementOneChild, elementTwoChild);
        }
    }

    private void compareAttibutes(OMElement elementOne, OMElement elementTwo) throws XMLComparisonException {
        int elementOneAtribCount = 0;
        int elementTwoAtribCount = 0;
        Iterator attributes = elementOne.getAllAttributes();
        while (attributes.hasNext()) {
            OMAttribute omAttribute = (OMAttribute)attributes.next();
            OMAttribute attr = elementTwo.getAttribute(omAttribute.getQName());
            if (attr == null) {
                throw new XMLComparisonException("Attributes are not the same in two elements. Attribute " + omAttribute.getLocalName() + " != ");
            }
            ++elementOneAtribCount;
        }
        Iterator elementTwoIter = elementTwo.getAllAttributes();
        while (elementTwoIter.hasNext()) {
            elementTwoIter.next();
            ++elementTwoAtribCount;
        }
        if (elementOneAtribCount != elementTwoAtribCount) {
            throw new XMLComparisonException("Attributes are not the same in two elements.");
        }
    }

    private void compare(String failureNotice, String one, String two) throws XMLComparisonException {
        if (!one.equals(two)) {
            throw new XMLComparisonException(failureNotice + one + " != " + two);
        }
    }

    private void compare(String failureNotice, OMNamespace one, OMNamespace two) throws XMLComparisonException {
        if (one == null && two == null) {
            return;
        }
        if (one != null && two == null) {
            throw new XMLComparisonException("First Namespace is NOT null. But the second is null");
        }
        if (one == null && two != null) {
            throw new XMLComparisonException("First Namespace is null. But the second is NOT null");
        }
        if (!one.getNamespaceURI().equals(two.getNamespaceURI())) {
            throw new XMLComparisonException(failureNotice + one + " != " + two);
        }
    }
}

