/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSourcedElementImpl
extends OMElementImpl {
    private final OMDataSource dataSource;
    private OMNamespace definedNamespace = null;
    private QName definedQName = null;
    private boolean isParserSet;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl == null ? (class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl = OMSourcedElementImpl.class$("org.apache.axiom.om.impl.llom.OMSourcedElementImpl")) : class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl));
    static /* synthetic */ Class class$org$apache$axiom$om$impl$llom$OMSourcedElementImpl;

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory, OMDataSource source) {
        super(localName, null, factory);
        this.dataSource = source;
        this.definedNamespace = ns;
    }

    public OMSourcedElementImpl(QName qName, OMFactory factory, OMDataSource source) {
        super(qName.getLocalPart(), null, factory);
        this.dataSource = source;
        this.definedQName = qName;
    }

    private String getPrintableName() {
        String uri = this.getNamespace().getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return this.getLocalName();
        }
        return "{" + uri + '}' + this.getLocalName();
    }

    private XMLStreamReader getDirectReader() {
        try {
            if (this.isDataSourceConsumed()) {
                return super.getXMLStreamReader();
            }
            return this.dataSource.getReader();
        }
        catch (XMLStreamException e) {
            log.error((Object)("Could not get parser from data source for element " + this.getPrintableName()), (Throwable)e);
            throw new RuntimeException("Error obtaining parser from data source:" + e.getMessage());
        }
    }

    private void forceExpand() {
        if (!this.isParserSet) {
            String uri;
            if (log.isDebugEnabled()) {
                log.debug((Object)("forceExpand: expanding element " + this.getPrintableName()));
            }
            XMLStreamReader reader = this.getDirectReader();
            try {
                if (reader.getEventType() != 1) {
                    while (reader.next() != 1) {
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)("forceExpand: error parsing data soruce document for element " + this.getLocalName()), (Throwable)e);
                throw new RuntimeException("Error parsing data source document:" + e.getMessage());
            }
            if (!reader.getLocalName().equals(this.getLocalName())) {
                log.error((Object)("forceExpand: expected element name " + this.getLocalName() + ", found " + reader.getLocalName()));
                throw new RuntimeException("Element name from data source is " + reader.getLocalName() + ", not the expected " + this.getLocalName());
            }
            String readerURI = reader.getNamespaceURI();
            readerURI = readerURI == null ? "" : readerURI;
            if (!readerURI.equals(uri = this.getNamespace().getNamespaceURI())) {
                log.error((Object)("forceExpand: expected element namespace " + this.getLocalName() + ", found " + uri));
                throw new RuntimeException("Element namespace from data source is " + readerURI + ", not the expected " + uri);
            }
            this.isParserSet = true;
            super.setBuilder((OMXMLParserWrapper)new StAXOMBuilder(this.getOMFactory(), reader, (OMElement)this));
            this.setComplete(false);
        }
    }

    public boolean isExpanded() {
        return this.isParserSet;
    }

    private boolean isDataSourceConsumed() {
        return this.isExpanded();
    }

    public Iterator getChildElements() {
        this.forceExpand();
        return super.getChildElements();
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.declareNamespace(uri, prefix);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        this.forceExpand();
        return super.declareDefaultNamespace(uri);
    }

    public OMNamespace getDefaultNamespace() {
        this.forceExpand();
        return super.getDefaultNamespace();
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        this.forceExpand();
        return super.declareNamespace(namespace);
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.findNamespace(uri, prefix);
    }

    public OMNamespace findNamespaceURI(String prefix) {
        this.forceExpand();
        return super.findNamespaceURI(prefix);
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        this.forceExpand();
        return super.getAllDeclaredNamespaces();
    }

    public Iterator getAllAttributes() {
        this.forceExpand();
        return super.getAllAttributes();
    }

    public OMAttribute getAttribute(QName qname) {
        this.forceExpand();
        return super.getAttribute(qname);
    }

    public String getAttributeValue(QName qname) {
        this.forceExpand();
        return super.getAttributeValue(qname);
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        this.forceExpand();
        return super.addAttribute(attr);
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace namespace) {
        this.forceExpand();
        return super.addAttribute(attributeName, value, namespace);
    }

    public void removeAttribute(OMAttribute attr) {
        this.forceExpand();
        super.removeAttribute(attr);
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        throw new UnsupportedOperationException("Builder cannot be set for element backed by data source");
    }

    public OMXMLParserWrapper getBuilder() {
        this.forceExpand();
        return super.getBuilder();
    }

    public void setFirstChild(OMNode node) {
        this.forceExpand();
        super.setFirstChild(node);
    }

    public OMElement getFirstElement() {
        this.forceExpand();
        return super.getFirstElement();
    }

    public XMLStreamReader getXMLStreamReader() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting XMLStreamReader for " + this.getPrintableName()));
        }
        if (this.isParserSet) {
            return super.getXMLStreamReader();
        }
        return this.getDirectReader();
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting XMLStreamReader without caching for " + this.getPrintableName()));
        }
        if (this.isParserSet) {
            return super.getXMLStreamReaderWithoutCaching();
        }
        return this.getDirectReader();
    }

    public void setText(String text) {
        this.forceExpand();
        super.setText(text);
    }

    public void setText(QName text) {
        this.forceExpand();
        super.setText(text);
    }

    public String getText() {
        this.forceExpand();
        return super.getText();
    }

    public QName getTextAsQName() {
        this.forceExpand();
        return super.getTextAsQName();
    }

    public String getLocalName() {
        return super.getLocalName();
    }

    public void setLocalName(String localName) {
        super.setLocalName(localName);
    }

    public OMNamespace getNamespace() throws OMException {
        if (this.definedNamespace == null && this.definedQName != null) {
            this.definedNamespace = this.factory.createOMNamespace(this.definedQName.getNamespaceURI(), this.definedQName.getPrefix());
        }
        return this.definedNamespace;
    }

    public void setNamespace(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespace(namespace);
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespaceWithNoFindInCurrentScope(namespace);
    }

    public QName getQName() {
        if (this.isExpanded()) {
            return super.getQName();
        }
        if (this.getNamespace() != null) {
            return new QName(this.definedNamespace.getNamespaceURI(), this.getLocalName());
        }
        return new QName(this.getLocalName());
    }

    public String toStringWithConsume() throws XMLStreamException {
        if (this.isDataSourceConsumed()) {
            return super.toStringWithConsume();
        }
        StringWriter writer = new StringWriter();
        XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter((Writer)writer);
        this.dataSource.serialize(writer2);
        writer2.flush();
        return writer.toString();
    }

    public QName resolveQName(String qname) {
        this.forceExpand();
        return super.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        this.forceExpand();
        return super.cloneOMElement();
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public void discard() throws OMException {
        this.setComplete(true);
        super.detach();
    }

    public int getType() {
        return super.getType();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        if (this.isDataSourceConsumed()) {
            super.internalSerialize(writer);
        } else {
            this.internalSerializeAndConsume(writer);
        }
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (this.isDataSourceConsumed()) {
            super.internalSerialize(writer, cache);
        } else {
            this.internalSerializeAndConsume(writer);
        }
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to XMLStreamWriter"));
        }
        if (this.isDataSourceConsumed()) {
            super.internalSerializeAndConsume(writer);
        } else {
            this.dataSource.serialize(writer);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerializeAndConsume(xmlWriter);
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(output);
    }

    public void serialize(Writer writer) throws XMLStreamException {
        this.serializeAndConsume(writer);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        this.serializeAndConsume(output, format);
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        this.serializeAndConsume(writer, format);
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerializeAndConsume(xmlWriter);
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to output stream"));
        }
        if (this.isDataSourceConsumed()) {
            super.serializeAndConsume(output, new OMOutputFormat());
        } else {
            this.dataSource.serialize(output, new OMOutputFormat());
        }
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to writer"));
        }
        if (this.isDataSourceConsumed()) {
            super.serializeAndConsume(writer);
        } else {
            this.dataSource.serialize(writer, new OMOutputFormat());
        }
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize formatted " + this.getPrintableName() + " to output stream"));
        }
        if (this.isDataSourceConsumed()) {
            super.serializeAndConsume(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    public void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize formatted " + this.getPrintableName() + " to writer"));
        }
        if (this.isDataSourceConsumed()) {
            super.serializeAndConsume(writer, format);
        } else {
            this.dataSource.serialize(writer, format);
        }
    }

    public void addChild(OMNode omNode) {
        this.forceExpand();
        super.addChild(omNode);
    }

    public Iterator getChildrenWithName(QName elementQName) {
        this.forceExpand();
        return super.getChildrenWithName(elementQName);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        this.forceExpand();
        return super.getFirstChildWithName(elementQName);
    }

    public Iterator getChildren() {
        this.forceExpand();
        return super.getChildren();
    }

    public OMNode getFirstOMChild() {
        this.forceExpand();
        return super.getFirstOMChild();
    }

    public void buildNext() {
        this.forceExpand();
        super.buildNext();
    }

    public OMNode detach() throws OMException {
        boolean complete = this.isComplete();
        this.setComplete(true);
        OMNode result = super.detach();
        this.setComplete(complete);
        return result;
    }

    public OMNode getNextOMSibling() throws OMException {
        return super.getNextOMSibling();
    }

    public String getTrimmedText() {
        this.forceExpand();
        return super.getTrimmedText();
    }

    OMNamespace handleNamespace(QName qname) {
        this.forceExpand();
        return super.handleNamespace(qname);
    }

    public boolean isComplete() {
        if (this.isParserSet) {
            return super.isComplete();
        }
        return true;
    }

    public String toString() {
        this.forceExpand();
        return super.toString();
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    public void build() throws OMException {
        super.build();
    }

    protected void notifyChildComplete() {
        super.notifyChildComplete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

