/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import org.apache.axiom.om.util.UUIDGenerator;

public class OMOutputFormat {
    private String mimeBoundary = null;
    private String rootContentId = null;
    private int nextid = 0;
    private boolean doOptimize;
    private boolean doingSWA;
    private boolean isSoap11 = true;
    public static final String DEFAULT_CHAR_SET_ENCODING = "utf-8";
    private String charSetEncoding;
    private String xmlVersion;
    private boolean ignoreXMLDeclaration = false;

    public boolean isOptimized() {
        return this.doOptimize;
    }

    public String getContentType() {
        String SOAPContentType = this.isSoap11 ? "text/xml" : "application/soap+xml";
        if (this.isOptimized()) {
            return this.getContentTypeForMTOM(SOAPContentType);
        }
        if (this.isDoingSWA()) {
            return this.getContentTypeForSwA(SOAPContentType);
        }
        return SOAPContentType;
    }

    public String getMimeBoundary() {
        if (this.mimeBoundary == null) {
            this.mimeBoundary = "MIMEBoundary" + UUIDGenerator.getUUID().replace(':', '_');
        }
        return this.mimeBoundary;
    }

    public String getRootContentId() {
        if (this.rootContentId == null) {
            this.rootContentId = "0." + UUIDGenerator.getUUID() + "@apache.org";
        }
        return this.rootContentId;
    }

    public String getNextContentId() {
        ++this.nextid;
        return this.nextid + "." + UUIDGenerator.getUUID() + "@apache.org";
    }

    public String getCharSetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.charSetEncoding = charSetEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public void setSOAP11(boolean b) {
        this.isSoap11 = b;
    }

    public boolean isSOAP11() {
        return this.isSoap11;
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.ignoreXMLDeclaration;
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.ignoreXMLDeclaration = ignoreXMLDeclaration;
    }

    public void setDoOptimize(boolean b) {
        this.doOptimize = b;
    }

    public boolean isDoingSWA() {
        return this.doingSWA;
    }

    public void setDoingSWA(boolean doingSWA) {
        this.doingSWA = doingSWA;
    }

    public String getContentTypeForMTOM(String SOAPContentType) {
        StringBuffer sb = new StringBuffer();
        sb.append("multipart/related");
        sb.append("; ");
        sb.append("boundary=");
        sb.append(this.getMimeBoundary());
        sb.append("; ");
        sb.append("type=\"application/xop+xml\"");
        sb.append("; ");
        sb.append("start=\"<" + this.getRootContentId() + ">\"");
        sb.append("; ");
        sb.append("start-info=\"" + SOAPContentType + "\"");
        return sb.toString();
    }

    public String getContentTypeForSwA(String SOAPContentType) {
        StringBuffer sb = new StringBuffer();
        sb.append("multipart/related");
        sb.append("; ");
        sb.append("boundary=");
        sb.append(this.getMimeBoundary());
        sb.append("; ");
        sb.append("type=\"" + SOAPContentType + "\"");
        sb.append("; ");
        sb.append("start=\"<" + this.getRootContentId() + ">\"");
        return sb.toString();
    }
}

