/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.OMException;

public class DataHandlerReaderUtils {
    private DataHandlerReaderUtils() {
    }

    public static DataHandlerReader getDataHandlerReader(final XMLStreamReader reader) {
        Boolean isDataHandlerAware;
        try {
            DataHandlerReader dhr = (DataHandlerReader)reader.getProperty(DataHandlerReader.PROPERTY);
            if (dhr != null) {
                return dhr;
            }
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            isDataHandlerAware = (Boolean)reader.getProperty("IsDatahandlersAwareParsing");
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        if (isDataHandlerAware != null && isDataHandlerAware.booleanValue()) {
            return new DataHandlerReader(){

                public boolean isBinary() {
                    return (Boolean)reader.getProperty("Axiom.IsBinary");
                }

                public boolean isOptimized() {
                    return true;
                }

                public boolean isDeferred() {
                    return false;
                }

                public String getContentID() {
                    return null;
                }

                public DataHandler getDataHandler() {
                    return (DataHandler)reader.getProperty("Axiom.DataHandler");
                }

                public DataHandlerProvider getDataHandlerProvider() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    public static Object processGetProperty(DataHandlerReader extension, String propertyName) {
        if (extension == null || propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (propertyName.equals(DataHandlerReader.PROPERTY)) {
            return extension;
        }
        if (propertyName.equals("IsDatahandlersAwareParsing")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("Axiom.IsBinary")) {
            return extension.isBinary();
        }
        if (propertyName.equals("Axiom.DataHandler")) {
            try {
                return extension.getDataHandler();
            }
            catch (XMLStreamException ex) {
                throw new OMException(ex);
            }
        }
        return null;
    }
}

