/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.traverse;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;

public class OMChildrenQNameIterator
extends OMChildrenIterator {
    private QName givenQName;
    private boolean needToMoveForward = true;
    private boolean isMatchingNodeFound = false;

    public OMChildrenQNameIterator(OMNode currentChild, QName givenQName) {
        super(currentChild);
        this.givenQName = givenQName;
    }

    public boolean hasNext() {
        while (this.needToMoveForward) {
            if (this.currentChild != null) {
                if (this.currentChild instanceof OMElement) {
                    QName thisQName = ((OMElement)this.currentChild).getQName();
                    if (this.givenQName == null || thisQName.equals(this.givenQName)) {
                        this.isMatchingNodeFound = true;
                        this.needToMoveForward = false;
                        break;
                    }
                }
                this.currentChild = this.currentChild.getNextOMSibling();
                this.needToMoveForward = this.currentChild != null;
                this.isMatchingNodeFound = this.needToMoveForward;
                continue;
            }
            this.needToMoveForward = false;
        }
        return this.isMatchingNodeFound;
    }

    public Object next() {
        this.needToMoveForward = true;
        this.isMatchingNodeFound = false;
        this.nextCalled = true;
        this.removeCalled = false;
        this.lastChild = this.currentChild;
        this.currentChild = this.currentChild.getNextOMSibling();
        return this.lastChild;
    }
}

