/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXUtils {
    private static final Pool xmlInputFactoryPool = new Pool(new ObjectCreator[]{new ObjectCreator(){

        public Object newObject() {
            return AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader savedClassLoader = currentThread.getContextClassLoader();
                    XMLInputFactory factory = null;
                    try {
                        currentThread.setContextClassLoader((class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils).getClassLoader());
                        factory = XMLInputFactory.newInstance();
                    }
                    finally {
                        currentThread.setContextClassLoader(savedClassLoader);
                    }
                    return factory;
                }
            });
        }
    }, new ObjectCreator(){

        public Object newObject() {
            return XMLInputFactory.newInstance();
        }
    }});
    private static final Pool xmlOutputFactoryPool = new Pool(new ObjectCreator[]{new ObjectCreator(){

        public Object newObject() {
            return AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ 4 this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader savedClassLoader = currentThread.getContextClassLoader();
                    XMLOutputFactory factory = null;
                    try {
                        currentThread.setContextClassLoader((class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils).getClassLoader());
                        factory = XMLOutputFactory.newInstance();
                    }
                    finally {
                        currentThread.setContextClassLoader(savedClassLoader);
                    }
                    return factory;
                }
            });
        }
    }, new ObjectCreator(){

        public Object newObject() {
            return XMLOutputFactory.newInstance();
        }
    }});
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils));
    private static boolean isDebugEnabled = log.isDebugEnabled();
    static /* synthetic */ Class class$org$apache$axiom$om$util$StAXUtils;

    public static XMLInputFactory getXMLInputFactory() {
        return (XMLInputFactory)xmlInputFactoryPool.getInstance();
    }

    public static void releaseXMLInputFactory(XMLInputFactory factory) {
        xmlInputFactoryPool.releaseInstance(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(in, encoding);
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
            }
            XMLStreamReader xMLStreamReader = reader;
            return xMLStreamReader;
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(in);
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
            }
            XMLStreamReader xMLStreamReader = reader;
            return xMLStreamReader;
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(Reader in) throws XMLStreamException {
        XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(in);
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
            }
            XMLStreamReader xMLStreamReader = reader;
            return xMLStreamReader;
        }
        finally {
            StAXUtils.releaseXMLInputFactory(inputFactory);
        }
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return (XMLOutputFactory)xmlOutputFactoryPool.getInstance();
    }

    public static void releaseXMLOutputFactory(XMLOutputFactory factory) {
        xmlOutputFactoryPool.releaseInstance(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out);
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
            }
            XMLStreamWriter xMLStreamWriter = writer;
            return xMLStreamWriter;
        }
        finally {
            StAXUtils.releaseXMLOutputFactory(outputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) throws XMLStreamException {
        XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out, encoding);
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
            }
            XMLStreamWriter xMLStreamWriter = writer;
            return xMLStreamWriter;
        }
        finally {
            StAXUtils.releaseXMLOutputFactory(outputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(Writer out) throws XMLStreamException {
        XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out);
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
            }
            XMLStreamWriter xMLStreamWriter = writer;
            return xMLStreamWriter;
        }
        finally {
            StAXUtils.releaseXMLOutputFactory(outputFactory);
        }
    }

    public static void reset() {
        xmlOutputFactoryPool.clear();
        xmlInputFactoryPool.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Pool {
        private final int MAX_POOL_SIZE = 100;
        private final List objects = new ArrayList();
        private final ObjectCreator objectCreator;

        Pool(ObjectCreator[] creators) {
            ObjectCreator oc = null;
            for (int i = 0; i < creators.length; ++i) {
                try {
                    creators[i].newObject();
                    oc = creators[i];
                    break;
                }
                catch (Throwable t) {
                    continue;
                }
            }
            if (oc == null) {
                throw new IllegalStateException("No valid ObjectCreator found.");
            }
            this.objectCreator = oc;
        }

        synchronized Object getInstance() {
            int size = this.objects.size();
            if (size > 0) {
                return this.objects.remove(size - 1);
            }
            return this.objectCreator.newObject();
        }

        synchronized void releaseInstance(Object object) {
            if (this.objects.size() < 100) {
                this.objects.add(object);
            }
        }

        synchronized void clear() {
            this.objects.clear();
        }
    }

    private static interface ObjectCreator {
        public Object newObject();
    }
}

