/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.util.stax.dialect.Scanner;

final class XLXP1DTDReaderImpl
implements DTDReader {
    private final XMLStreamReader reader;
    private String rootName;
    private String publicId;
    private String systemId;

    XLXP1DTDReaderImpl(XMLStreamReader reader) {
        this.reader = reader;
    }

    private void parse() {
        if (this.rootName == null) {
            try {
                Scanner scanner = new Scanner((String)this.reader.getProperty("javax.xml.stream.dtd.declaration"));
                scanner.expect("<!DOCTYPE");
                scanner.skipSpace();
                this.rootName = scanner.getName();
                scanner.skipSpace();
                switch (scanner.peek()) {
                    case 83: {
                        scanner.expect("SYSTEM");
                        scanner.skipSpace();
                        this.systemId = scanner.getQuotedString();
                        break;
                    }
                    case 80: {
                        scanner.expect("PUBLIC");
                        scanner.skipSpace();
                        this.publicId = scanner.getQuotedString();
                        scanner.skipSpace();
                        this.systemId = scanner.getQuotedString();
                    }
                }
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException("Unable to parse DOCTYPE declaration", ex);
            }
        }
    }

    public String getRootName() {
        this.parse();
        return this.rootName;
    }

    public String getPublicId() {
        this.parse();
        return this.publicId;
    }

    public String getSystemId() {
        this.parse();
        return this.systemId;
    }
}

