/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.builder;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.exception.OMBuilderException;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public abstract class SOAPBuilderHelper {
    protected StAXSOAPModelBuilder builder;
    protected XMLStreamReader parser;

    protected SOAPBuilderHelper(StAXSOAPModelBuilder builder) {
        this.builder = builder;
    }

    public abstract OMElement handleEvent(XMLStreamReader var1, OMElement var2, int var3) throws SOAPProcessingException;

    protected void processNamespaceData(OMElement node, boolean checkSOAPNamespace) {
        this.builder.processNamespaceData(node);
        if (checkSOAPNamespace && node.getNamespace() != null && !node.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !node.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw new OMBuilderException("invalid SOAP namespace URI");
        }
    }

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            OMNamespace ns = null;
            String uri = this.parser.getAttributeNamespace(i);
            if (uri != null && uri.hashCode() != 0) {
                ns = node.findNamespace(uri, this.parser.getAttributePrefix(i));
            }
            node.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), ns);
        }
    }
}

