/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.PushbackFilePartInputStream;
import org.apache.axiom.om.OMException;

public class PartOnFile
implements Part {
    File cacheFile;
    Part bodyPart;
    String contentType;
    String contentID;
    Hashtable headers = new Hashtable();

    public PartOnFile(PushbackFilePartInputStream inStream, String repoDir) {
        if (repoDir == null) {
            repoDir = ".";
        }
        try {
            File repoDirFile = null;
            if (repoDir != null && !(repoDirFile = new File(repoDir)).exists()) {
                repoDirFile.mkdirs();
            }
            if (!repoDirFile.isDirectory()) {
                throw new IllegalArgumentException("Given Axis2 Attachment File Cache Location " + repoDir + "  should be a directory.");
            }
            this.cacheFile = File.createTempFile("Axis2", ".att", repoDirFile);
            FileOutputStream fileOutStream = new FileOutputStream(this.cacheFile);
            int value = this.parseTheHeaders(inStream);
            fileOutStream.write(value);
            while (!inStream.getBoundaryStatus()) {
                value = inStream.read();
                if (inStream.getBoundaryStatus()) continue;
                fileOutStream.write(value);
            }
            fileOutStream.flush();
            fileOutStream.close();
        }
        catch (IOException e) {
            throw new OMException("Error creating temporary File.", e);
        }
    }

    private int parseTheHeaders(InputStream inStream) throws IOException {
        int value;
        boolean readingHeaders = true;
        StringBuffer header = new StringBuffer();
        while (readingHeaders & (value = inStream.read()) != -1) {
            if (value == 13) {
                value = inStream.read();
                if (value == 10) {
                    value = inStream.read();
                    if (value == 13) {
                        value = inStream.read();
                        if (value != 10) continue;
                        this.putToMap(header);
                        readingHeaders = false;
                        continue;
                    }
                    this.putToMap(header);
                    header = new StringBuffer();
                    header.append((char)value);
                    continue;
                }
                header.append(13);
                header.append(value);
                continue;
            }
            header.append((char)value);
        }
        return value;
    }

    private void putToMap(StringBuffer header) {
        String headerString = header.toString();
        int delimiter = headerString.indexOf(":");
        String name = headerString.substring(0, delimiter).trim();
        String value = headerString.substring(delimiter + 1, headerString.length()).trim();
        Header headerObj = new Header(name, value);
        this.headers.put(name, headerObj);
    }

    public String getContentID() {
        Header cID = (Header)this.headers.get("Content-ID");
        if (cID == null && (cID = (Header)this.headers.get("Content-Id")) == null && (cID = (Header)this.headers.get("Content-id")) == null) {
            cID = (Header)this.headers.get("content-id");
        }
        return cID.getValue();
    }

    public int getSize() throws MessagingException {
        return (int)this.cacheFile.length();
    }

    public int getLineCount() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public String getFileName() throws MessagingException {
        return this.cacheFile.getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return new FileInputStream(this.cacheFile);
    }

    public DataHandler getDataHandler() throws MessagingException {
        CachedFileDataSource dataSource = new CachedFileDataSource(this.cacheFile);
        dataSource.setContentType(this.getContentType());
        return new DataHandler((DataSource)dataSource);
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException, MessagingException {
        this.getDataHandler().writeTo(outStream);
    }

    public String getHeader(String arg0) throws MessagingException {
        return ((Header)this.headers.get(arg0)).getValue();
    }

    public void addHeader(String arg0, String arg1) throws MessagingException {
        Header headerObj = new Header(arg0, arg1);
        this.headers.put(arg0, headerObj);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.elements();
    }

    public String getContentType() throws MessagingException {
        Header cType = (Header)this.headers.get("Content-Type");
        if (cType == null && (cType = (Header)this.headers.get("Content-type")) == null) {
            cType = (Header)this.headers.get("content-type");
        }
        return cType.getValue();
    }
}

