/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.wicket.util.crypt.AbstractCrypt;
import org.apache.wicket.util.lang.Args;

public class SunJceCrypt
extends AbstractCrypt {
    private static final int DEFAULT_ITERATION_COUNT = 17;
    public static final String DEFAULT_CRYPT_METHOD = "PBEWithMD5AndDES";
    @Deprecated
    public static final byte[] SALT = new byte[]{21, -116, -93, 74, 102, 81, 42, -68};
    private final String cryptMethod;
    private final int iterationCount;
    private final byte[] salt;

    @Deprecated(forRemoval=true)
    public SunJceCrypt() {
        this(DEFAULT_CRYPT_METHOD);
    }

    public SunJceCrypt(byte[] salt, int iterationCount) {
        this(DEFAULT_CRYPT_METHOD, salt, iterationCount);
    }

    @Deprecated(forRemoval=true)
    public SunJceCrypt(String cryptMethod) {
        this(cryptMethod, SALT, 17);
    }

    public SunJceCrypt(String cryptMethod, byte[] salt, int iterationCount) {
        this.cryptMethod = Args.notNull(cryptMethod, "Crypt method");
        this.salt = Args.notNull(salt, "salt");
        this.iterationCount = Args.withinRange(1, Integer.MAX_VALUE, iterationCount, "iterationCount");
    }

    @Override
    protected byte[] crypt(byte[] input, int mode) throws GeneralSecurityException {
        SecretKey key = this.generateSecretKey();
        AlgorithmParameterSpec spec = this.createParameterSpec();
        Cipher ciph = this.createCipher(key, spec, mode);
        return ciph.doFinal(input);
    }

    protected Cipher createCipher(SecretKey key, AlgorithmParameterSpec spec, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.cryptMethod);
        cipher.init(mode, (Key)key, spec);
        return cipher;
    }

    protected SecretKey generateSecretKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.cryptMethod);
        KeySpec spec = this.createKeySpec();
        return keyFactory.generateSecret(spec);
    }

    protected AlgorithmParameterSpec createParameterSpec() {
        return new PBEParameterSpec(this.salt, this.iterationCount);
    }

    protected KeySpec createKeySpec() {
        return new PBEKeySpec(this.getKey().toCharArray());
    }

    public static byte[] randomSalt() {
        byte[] salt = new byte[8];
        new Random().nextBytes(salt);
        return salt;
    }
}

