/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SpringWebApplicationFactory
implements IWebApplicationFactory {
    private ConfigurableWebApplicationContext additionalContext;

    protected final String getContextConfigLocation(WicketFilter filter) {
        return filter.getFilterConfig().getInitParameter("contextConfigLocation");
    }

    protected ConfigurableWebApplicationContext newApplicationContext() {
        return new XmlWebApplicationContext();
    }

    public WebApplication createApplication(WicketFilter filter) {
        ServletContext sc = filter.getFilterConfig().getServletContext();
        WebApplicationContext ac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        if (this.getContextConfigLocation(filter) != null) {
            this.additionalContext = this.createWebApplicationContext(ac, filter);
        }
        String beanName = filter.getFilterConfig().getInitParameter("applicationBean");
        return this.createApplication((ApplicationContext)(this.additionalContext != null ? this.additionalContext : ac), beanName);
    }

    private WebApplication createApplication(ApplicationContext ac, String beanName) {
        if (beanName != null) {
            WebApplication application = (WebApplication)ac.getBean(beanName);
            if (application == null) {
                throw new IllegalArgumentException("Unable to find WebApplication bean with name [" + beanName + "]");
            }
            return application;
        }
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ac, WebApplication.class, (boolean)false, (boolean)false);
        if (beans.size() == 0) {
            throw new IllegalStateException("bean of type [" + WebApplication.class.getName() + "] not found");
        }
        if (beans.size() > 1) {
            throw new IllegalStateException("more then one bean of type [" + WebApplication.class.getName() + "] found, must have only one");
        }
        return (WebApplication)beans.values().iterator().next();
    }

    protected final ConfigurableWebApplicationContext createWebApplicationContext(WebApplicationContext parent, WicketFilter filter) throws BeansException {
        ConfigurableWebApplicationContext wac = this.newApplicationContext();
        wac.setParent((ApplicationContext)parent);
        wac.setServletContext(filter.getFilterConfig().getServletContext());
        wac.setConfigLocation(this.getContextConfigLocation(filter));
        this.postProcessWebApplicationContext(wac, filter);
        wac.refresh();
        return wac;
    }

    protected void postProcessWebApplicationContext(ConfigurableWebApplicationContext wac, WicketFilter filter) {
    }

    public void destroy() {
        if (this.additionalContext != null) {
            this.additionalContext.close();
        }
    }
}

