/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.strategies;

import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.models.ISecureModel;
import org.apache.wicket.security.strategies.LoginException;

public abstract class WaspAuthorizationStrategy
implements IAuthorizationStrategy,
Serializable {
    public abstract boolean isComponentAuthorized(Component var1, WaspAction var2);

    public abstract boolean isModelAuthorized(ISecureModel var1, Component var2, WaspAction var3);

    public abstract boolean isClassAuthorized(Class var1, WaspAction var2);

    public abstract boolean isComponentAuthenticated(Component var1);

    public abstract boolean isModelAuthenticated(IModel var1, Component var2);

    public abstract boolean isClassAuthenticated(Class var1);

    public abstract boolean isUserAuthenticated();

    public abstract void login(Object var1) throws LoginException;

    public abstract boolean logoff(Object var1);

    public abstract void destroy();

    public boolean isActionAuthorized(Component component, Action action) {
        if (component != null) {
            ISecurityCheck check = this.getSecurityCheck(component);
            if (check != null) {
                return check.isActionAuthorized(this.getActionFactory().getAction(action));
            }
            IModel model = component.getModel();
            if (model instanceof ISecureModel) {
                return ((ISecureModel)model).isAuthorized(component, this.getActionFactory().getAction(action));
            }
        }
        return true;
    }

    protected final ISecurityCheck getSecurityCheck(Component component) {
        if (component instanceof ISecureComponent) {
            return ((ISecureComponent)component).getSecurityCheck();
        }
        return SecureComponentHelper.getSecurityCheck(component);
    }

    protected final ActionFactory getActionFactory() {
        return ((WaspApplication)Application.get()).getActionFactory();
    }
}

