/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.strategies;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.security.actions.Access;
import org.apache.wicket.security.checks.ClassSecurityCheck;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.ISecurePage;
import org.apache.wicket.security.strategies.SecurityException;
import org.apache.wicket.security.strategies.WaspAuthorizationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassAuthorizationStrategy
extends WaspAuthorizationStrategy {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)ClassAuthorizationStrategy.class);
    private Class secureClass = ISecurePage.class;
    private Map cache = new HashMap(100);
    static /* synthetic */ Class class$org$apache$wicket$security$checks$ISecurityCheck;

    public ClassAuthorizationStrategy() {
    }

    public ClassAuthorizationStrategy(Class secureClass) {
        if (secureClass != null) {
            if (ISecureComponent.class.isAssignableFrom(secureClass)) {
                this.secureClass = secureClass;
            } else {
                throw new IllegalArgumentException("securePageClass must be an ISecureComponent class.");
            }
        }
    }

    public boolean isInstantiationAuthorized(Class c) {
        if (c != null && this.secureClass.isAssignableFrom(c)) {
            ISecurityCheck[] checks = this.getClassChecks(c);
            for (int i = 0; i < checks.length; ++i) {
                if (checks[i].isActionAuthorized(this.getActionFactory().getAction(class$org$apache$wicket$security$actions$Access == null ? ClassAuthorizationStrategy.class$("org.apache.wicket.security.actions.Access") : class$org$apache$wicket$security$actions$Access))) continue;
                return false;
            }
            if (checks.length == 0) {
                return new ClassSecurityCheck(c).isActionAuthorized(this.getActionFactory().getAction(Access.class));
            }
            return true;
        }
        return true;
    }

    protected final ISecurityCheck[] getClassChecks(Class clazz) {
        ISecurityCheck[] checks = (ISecurityCheck[])this.cache.get(clazz);
        if (checks != null) {
            return checks;
        }
        List list = this.getClassChecks(clazz, new ArrayList());
        checks = list == null ? new ISecurityCheck[]{} : list.toArray(new ISecurityCheck[list.size()]);
        this.cache.put(clazz, checks);
        return checks;
    }

    protected List getClassChecks(Class clazz, List list) {
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!Modifier.isStatic(fields[i].getModifiers()) || !Modifier.isFinal(fields[i].getModifiers()) || !(class$org$apache$wicket$security$checks$ISecurityCheck == null ? ClassAuthorizationStrategy.class$("org.apache.wicket.security.checks.ISecurityCheck") : class$org$apache$wicket$security$checks$ISecurityCheck).isAssignableFrom(fields[i].getType())) continue;
                try {
                    fields[i].setAccessible(true);
                    Object check = fields[i].get(null);
                    if (check == null) continue;
                    list.add(check);
                    continue;
                }
                catch (SecurityException e) {
                    log.error(this.getExceptionMessage(fields[i]), (Throwable)e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.error(this.getExceptionMessage(fields[i]), (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    log.error(this.getExceptionMessage(fields[i]), (Throwable)e);
                }
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.getClassChecks(interfaces[i], list);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    protected String getExceptionMessage(Field field) {
        if (field == null) {
            return "unable to process unknown field";
        }
        return "Unable to process " + field.getDeclaringClass().getName() + "#" + field.getName();
    }

    public void destroy() {
        this.cache.clear();
    }
}

