/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.login.http;

import org.apache.wicket.Application;
import org.apache.wicket.IPageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.security.WaspSession;
import org.apache.wicket.security.strategies.LoginException;
import org.apache.wicket.security.strategies.WaspAuthorizationStrategy;
import org.apache.wicket.util.crypt.Base64;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAuthenticationLoginPage
extends WebPage {
    private static final Logger log = LoggerFactory.getLogger((Class)HttpAuthenticationLoginPage.class);
    private boolean doAuthentication = false;

    public HttpAuthenticationLoginPage() {
    }

    protected HttpAuthenticationLoginPage(IModel model) {
        super(model);
    }

    protected HttpAuthenticationLoginPage(IPageMap pageMap) {
        super(pageMap);
    }

    protected HttpAuthenticationLoginPage(PageParameters parameters) {
        super(parameters);
    }

    protected HttpAuthenticationLoginPage(IPageMap pageMap, IModel model) {
        super(pageMap, model);
    }

    protected void configureResponse() {
        super.configureResponse();
        if (this.doAuthentication && this.getWebRequestCycle().getResponse() instanceof WebResponse) {
            WebResponse response = this.getWebRequestCycle().getWebResponse();
            WebRequest request = this.getWebRequestCycle().getWebRequest();
            String auth = request.getHttpServletRequest().getHeader("Authorization");
            if (Strings.isEmpty((CharSequence)auth)) {
                this.requestAuthentication(request, response);
            } else {
                int index = auth.indexOf(32);
                if (index < 1) {
                    this.requestAuthentication(request, response);
                }
                String type = auth.substring(0, index);
                try {
                    this.handleAuthentication(request, response, type, auth.substring(index + 1));
                }
                catch (LoginException e) {
                    log.error(type + " Http authentication failed", (Throwable)e);
                    this.error(e);
                    this.requestAuthentication(request, response);
                }
            }
        }
    }

    protected final void doAuthentication() {
        this.doAuthentication = true;
    }

    protected void requestAuthentication(WebRequest request, WebResponse response) {
        response.getHttpServletResponse().setStatus(401);
        this.addBasicHeaders(request, response);
    }

    protected void addBasicHeaders(WebRequest request, WebResponse response) {
        response.getHttpServletResponse().addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm(request, response) + "\"");
    }

    public abstract String getRealm(WebRequest var1, WebResponse var2);

    protected void handleAuthentication(WebRequest request, WebResponse response, String scheme, String param) throws LoginException {
        if (!this.handleBasicAuthentication(request, response, scheme, param)) {
            return;
        }
        log.error("Unsupported Http authentication type: " + scheme);
        throw new RestartResponseAtInterceptPageException(Application.get().getApplicationSettings().getAccessDeniedPage());
    }

    protected boolean handleBasicAuthentication(WebRequest request, WebResponse response, String scheme, String param) throws LoginException {
        if (!"Basic".equalsIgnoreCase(scheme)) {
            return true;
        }
        if (param == null) {
            log.error("Username, password not supplied");
            return false;
        }
        byte[] decoded = Base64.decodeBase64((byte[])param.getBytes());
        String[] split = new String(decoded).split(":");
        if (split == null || split.length != 2) {
            throw new LoginException("Could not decrypt username / password");
        }
        Object loginContext = this.getBasicLoginContext(split[0], split[1]);
        Session session = Session.get();
        if (session instanceof WaspSession) {
            if (!this.isAuthenticated()) {
                ((WaspSession)session).login(loginContext);
            }
            if (!this.continueToOriginalDestination()) {
                throw new RestartResponseAtInterceptPageException(Application.get().getHomePage());
            }
        } else {
            log.error("Unable to find WaspSession");
        }
        return false;
    }

    protected boolean isAuthenticated() {
        WaspAuthorizationStrategy strategy = (WaspAuthorizationStrategy)Session.get().getAuthorizationStrategy();
        return strategy.isClassAuthenticated(Application.get().getHomePage());
    }

    protected abstract Object getBasicLoginContext(String var1, String var2);
}

