/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.swarm.strategies;

import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.components.ISecurePage;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.hive.Hive;
import org.apache.wicket.security.hive.HiveMind;
import org.apache.wicket.security.hive.authentication.LoginContainer;
import org.apache.wicket.security.hive.authentication.LoginContext;
import org.apache.wicket.security.hive.authentication.Subject;
import org.apache.wicket.security.hive.authorization.Permission;
import org.apache.wicket.security.hive.authorization.permissions.ComponentPermission;
import org.apache.wicket.security.hive.authorization.permissions.DataPermission;
import org.apache.wicket.security.models.ISecureModel;
import org.apache.wicket.security.strategies.ClassAuthorizationStrategy;
import org.apache.wicket.security.strategies.LoginException;
import org.apache.wicket.security.strategies.SecurityException;
import org.apache.wicket.security.swarm.actions.SwarmAction;
import org.apache.wicket.security.swarm.models.SwarmModel;

public class SwarmStrategy
extends ClassAuthorizationStrategy {
    private static final long serialVersionUID = 1L;
    private Object hiveQueen;
    private LoginContainer loginContainer;

    public SwarmStrategy(Object hiveQueen) {
        this(ISecurePage.class, hiveQueen);
    }

    public SwarmStrategy(Class secureClass, Object hiveQueen) {
        super(secureClass);
        this.hiveQueen = hiveQueen;
        this.loginContainer = new LoginContainer();
    }

    protected final Hive getHive() {
        Hive hive = HiveMind.getHive(this.hiveQueen);
        if (hive == null) {
            throw new SecurityException("No hive registered for " + this.hiveQueen);
        }
        return hive;
    }

    public final Subject getSubject() {
        return this.loginContainer.getSubject();
    }

    public boolean hasPermission(Permission permission) {
        if (permission == null) {
            throw new SecurityException("permission is not allowed to be null");
        }
        return this.getHive().hasPermission(this.getSubject(), permission);
    }

    public boolean isClassAuthenticated(Class clazz) {
        return this.loginContainer.isClassAuthenticated(clazz);
    }

    public boolean isClassAuthorized(Class clazz, WaspAction action) {
        return this.hasPermission(new ComponentPermission(SecureComponentHelper.alias((Class)clazz), (SwarmAction)action));
    }

    public boolean isComponentAuthenticated(Component component) {
        return this.loginContainer.isComponentAuthenticated(component);
    }

    public boolean isComponentAuthorized(Component component, WaspAction action) {
        return this.hasPermission(new ComponentPermission(component, (SwarmAction)action));
    }

    public boolean isModelAuthenticated(IModel model, Component component) {
        return this.loginContainer.isModelAuthenticated(model, component);
    }

    public boolean isModelAuthorized(ISecureModel model, Component component, WaspAction action) {
        DataPermission permission = model instanceof SwarmModel ? new DataPermission(component, (SwarmModel)model, (SwarmAction)action) : new DataPermission(String.valueOf(model), action.getName());
        return this.hasPermission(permission);
    }

    public void login(Object context) throws LoginException {
        if (!(context instanceof LoginContext)) {
            throw new SecurityException("Unable to process login with context: " + context);
        }
        this.loginContainer.login((LoginContext)context);
    }

    public boolean logoff(Object context) {
        if (context instanceof LoginContext) {
            return this.loginContainer.logoff((LoginContext)context);
        }
        throw new SecurityException("Unable to process logoff with context: " + context);
    }

    protected final LoginContainer getLoginContainer() {
        return this.loginContainer;
    }

    public boolean isUserAuthenticated() {
        return this.getSubject() != null;
    }
}

