/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.swarm.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.security.actions.Access;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.AllActions;
import org.apache.wicket.security.actions.Enable;
import org.apache.wicket.security.actions.Inherit;
import org.apache.wicket.security.actions.RegistrationException;
import org.apache.wicket.security.actions.Render;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.swarm.actions.SwarmAction;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwarmActionFactory
implements ActionFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)SwarmActionFactory.class);
    protected static final int maxAssingableAction = (int)Math.pow(2.0, 30.0);
    private Map stringValues = new HashMap(10);
    private Map cachedActions = new HashMap();
    private Map registeredActions = new HashMap();
    private int power = -1;
    private int maxAction = 0;

    public SwarmActionFactory() {
        try {
            this.register(Access.class, "access");
            this.register(Inherit.class, "inherit");
            this.register(Render.class, "render");
            this.register(Enable.class, new ImpliesOtherAction(this.nextPowerOf2(), "enable", (ActionFactory)this, Render.class));
        }
        catch (RegistrationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public WaspAction getAction(Action action) {
        if (action instanceof SwarmAction) {
            return (SwarmAction)action;
        }
        if (action != null) {
            try {
                return this.getAction(action.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public WaspAction getAction(String actions) {
        String saveActions = this.convertWicket2Wasp(actions);
        SwarmAction sa = this.getCachedAction(saveActions);
        if (sa == null) {
            int actionValues = this.parseActions(saveActions);
            String nameValues = this.buildActionString(actionValues);
            sa = new SwarmAction(actionValues, nameValues);
            this.cacheAction(saveActions, sa);
        }
        return sa;
    }

    protected final synchronized void cacheAction(String name, SwarmAction action) {
        this.cachedActions.put(name, action);
    }

    protected final synchronized SwarmAction getCachedAction(String name) {
        return (SwarmAction)((Object)this.cachedActions.get(name));
    }

    public SwarmAction getAction(int actions) {
        SwarmAction ja = this.getCachedAction(actions);
        if (ja == null) {
            if (actions > this.maxAction) {
                throw new IllegalArgumentException("Max value for actions = " + this.maxAction + ", you used " + actions);
            }
            if (actions < 0) {
                throw new IllegalArgumentException("Min value for actions = 0, you used " + actions);
            }
            ja = new SwarmAction(actions, this.buildActionString(actions));
            this.cacheAction(new Integer(actions), ja);
        }
        return ja;
    }

    protected final synchronized void cacheAction(Integer actions, SwarmAction ja) {
        this.cachedActions.put(actions, ja);
    }

    protected final synchronized SwarmAction getCachedAction(int actions) {
        return (SwarmAction)((Object)this.cachedActions.get(new Integer(actions)));
    }

    protected final String valueOf(Integer action) {
        return (String)this.stringValues.get(action);
    }

    protected String buildActionString(int actions) {
        AppendingStringBuffer buff = new AppendingStringBuffer(this.power > 0 ? 10 * this.power : 10);
        for (int i = -1; i < this.power; ++i) {
            this.appendActionString(buff, actions, ((SwarmAction)((Object)this.registeredActions.get(new Integer(i)))).actions());
        }
        if (buff.length() > 0) {
            buff.delete(buff.length() - 2, buff.length());
        }
        return buff.toString();
    }

    protected final void appendActionString(AppendingStringBuffer buff, int actions, int waspAction) {
        if (this.implies(actions, waspAction)) {
            buff.append(this.valueOf(new Integer(waspAction))).append(", ");
        }
    }

    protected final boolean implies(int actions, int action) {
        return (actions & action) == action;
    }

    protected int parseActions(String actions) {
        int sum = 0;
        if (actions != null) {
            String[] actionz = actions.split(",");
            String action = null;
            Set keys = this.stringValues.keySet();
            for (int i = 0; i < actionz.length && !(action = actionz[i].trim()).equals(""); ++i) {
                if (action.equals("all")) {
                    return ((SwarmAction)this.getAction(AllActions.class)).actions();
                }
                boolean found = false;
                Iterator it = keys.iterator();
                while (it.hasNext() && !found) {
                    Integer key = (Integer)it.next();
                    if (!action.equalsIgnoreCase(this.valueOf(key))) continue;
                    sum |= key.intValue();
                    found = true;
                }
                if (found) continue;
                throw new IllegalArgumentException("Invalid action: " + action + " in: " + actions);
            }
        }
        return sum;
    }

    public synchronized WaspAction getAction(Class waspActionClass) {
        if (AllActions.class.isAssignableFrom(waspActionClass)) {
            WaspAction all = (WaspAction)this.registeredActions.get(Access.class);
            Iterator it = this.registeredActions.keySet().iterator();
            Object action = null;
            while (it.hasNext()) {
                action = it.next();
                if (!(action instanceof Class)) continue;
                all = all.add((WaspAction)this.registeredActions.get(action));
            }
            return all;
        }
        WaspAction action = (WaspAction)this.registeredActions.get(waspActionClass);
        if (action == null) {
            throw new IllegalArgumentException("" + waspActionClass + " is not registered");
        }
        return action;
    }

    public synchronized WaspAction register(Class waspActionClass, String name) throws RegistrationException {
        if (AllActions.class.isAssignableFrom(waspActionClass)) {
            throw new RegistrationException("Can not register 'all' actions");
        }
        WaspAction temp = (WaspAction)this.registeredActions.get(waspActionClass);
        if (temp != null) {
            return temp;
        }
        if (WaspAction.class.isAssignableFrom(waspActionClass)) {
            if (this.power > 30) {
                throw new RegistrationException("Can not register more then 32 different actions.");
            }
            int action = this.nextPowerOf2();
            return this.register(waspActionClass, new SwarmAction(action, name));
        }
        throw new RegistrationException(waspActionClass + " is not a " + WaspAction.class.getName());
    }

    public final int getNumberOfRegisteredClasses() {
        return this.power + 1;
    }

    protected final int nextPowerOf2() {
        return (int)Math.pow(2.0, this.power);
    }

    protected final String convertWicket2Wasp(String name) {
        if (name == null) {
            return "";
        }
        return name.toLowerCase();
    }

    protected final synchronized SwarmAction register(Class waspActionClass, SwarmAction action) throws RegistrationException {
        if (AllActions.class.isAssignableFrom(waspActionClass)) {
            throw new RegistrationException("Can not register 'all' actions");
        }
        if (this.power > 30) {
            throw new RegistrationException("Can not register more then 32 different actions.");
        }
        int assignedPowerOf2 = this.nextPowerOf2();
        if (assignedPowerOf2 > maxAssingableAction) {
            throw new RegistrationException("Unable to register an action with a base value greater then " + maxAssingableAction);
        }
        if (assignedPowerOf2 < 0) {
            throw new RegistrationException(assignedPowerOf2 + " is not a positive value");
        }
        Integer powerOf2 = new Integer(action.actions());
        if (!this.implies(powerOf2, assignedPowerOf2)) {
            throw new RegistrationException("Unable to register action '" + action.getName() + "' with value " + powerOf2 + " expected " + assignedPowerOf2 + " or more.");
        }
        this.stringValues.put(powerOf2, action.getName());
        this.registeredActions.put(new Integer(this.power), action);
        this.registeredActions.put(waspActionClass, action);
        this.maxAction += assignedPowerOf2;
        ++this.power;
        return action;
    }

    public List getRegisteredActions() {
        ArrayList<WaspAction> actions = new ArrayList<WaspAction>(this.getNumberOfRegisteredClasses());
        Iterator it = this.registeredActions.keySet().iterator();
        Object action = null;
        while (it.hasNext()) {
            action = it.next();
            if (!(action instanceof Class)) continue;
            actions.add(this.getAction((Class)action));
        }
        return actions;
    }

    public void destroy() {
        this.power = 31;
        this.maxAction = 0;
        this.registeredActions.clear();
        this.cachedActions.clear();
        this.stringValues.clear();
        this.registeredActions = null;
        this.cachedActions = null;
        this.stringValues = null;
    }

    protected static class ImpliesOtherAction
    extends SwarmAction {
        private static final long serialVersionUID = 1L;

        public ImpliesOtherAction(int actions, String name, ActionFactory factory, Class otherAction) {
            super(actions | ((SwarmAction)factory.getAction(otherAction)).actions(), name);
        }

        public ImpliesOtherAction(int actions, String name, ActionFactory factory, Class[] otherActions) {
            super(actions | ImpliesOtherAction.bitwiseOr(factory, otherActions), name);
        }

        private static final int bitwiseOr(ActionFactory factory, Class[] otherActions) {
            int result = 0;
            if (otherActions != null) {
                for (int i = 0; i < otherActions.length; ++i) {
                    Class action = otherActions[i];
                    result |= ((SwarmAction)factory.getAction(action)).actions();
                }
            }
            return result;
        }
    }
}

