/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.security.hive.BasicHive;
import org.apache.wicket.security.hive.Hive;
import org.apache.wicket.security.hive.SimpleCachingHive;
import org.apache.wicket.security.hive.authorization.EverybodyPrincipal;
import org.apache.wicket.security.hive.authorization.Permission;
import org.apache.wicket.security.hive.authorization.Principal;
import org.apache.wicket.security.hive.config.HiveFactory;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFileHiveFactory
implements HiveFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)PolicyFileHiveFactory.class);
    private Set policyFiles;
    private Set inputStreams;
    private Set inputReaders;
    private static final Pattern principalPattern = Pattern.compile("\\s*(?:grant(?:\\s+principal\\s+([^\"]+)\\s+\"([^\"]+)\")?){1}\\s*");
    private static final Pattern permissionPattern = Pattern.compile("\\s*(?:permission\\s+([^\",]+?)\\s+(?:(?:\"([^\"]+)\"){1}?(?:\\s*,\\s*\"([^\"]*)\")?)?\\s*;){1}\\s*");
    private static final Pattern aliasPattern = Pattern.compile("(\\$\\{[^\"\\{\\}\\$]+?\\})+?");
    private static final Class[] stringArgs1 = new Class[]{String.class};
    private static final Class[] stringArgs2 = new Class[]{String.class, String.class};
    private Map aliases = new HashMap();
    private boolean useHiveCache = true;
    private boolean closeInputStreams = true;
    private int currentLineNr;

    public PolicyFileHiveFactory() {
        this.policyFiles = new HashSet();
        this.inputStreams = new HashSet();
        this.inputReaders = new HashSet();
        this.setAlias("ComponentPermission", "org.apache.wicket.security.hive.authorization.permissions.ComponentPermission");
        this.setAlias("DataPermission", "org.apache.wicket.security.hive.authorization.permissions.DataPermission");
        this.setAlias("AllPermissions", "org.apache.wicket.security.hive.authorization.permissions.AllPermissions");
    }

    public final boolean addPolicyFile(URL file) {
        if (file == null) {
            log.warn("Can not add null as an url.");
            return false;
        }
        return this.policyFiles.add(file);
    }

    protected final Set getPolicyFiles() {
        return Collections.unmodifiableSet(this.policyFiles);
    }

    public final boolean addStream(InputStream stream) {
        if (stream == null) {
            log.warn("Can not add null as a stream.");
            return false;
        }
        return this.inputStreams.add(stream);
    }

    protected final Set getStreams() {
        return Collections.unmodifiableSet(this.inputStreams);
    }

    public final boolean addReader(Reader input) {
        if (input == null) {
            log.warn("Can not add null as a reader.");
            return false;
        }
        return this.inputReaders.add(input);
    }

    protected final Set getReaders() {
        return Collections.unmodifiableSet(this.inputReaders);
    }

    public final String getAlias(String key) {
        return (String)this.aliases.get(key);
    }

    public final String setAlias(String key, String value) {
        return this.aliases.put(key, value);
    }

    protected final int getCurrentLineNr() {
        return this.currentLineNr;
    }

    private String resolveAliases(String raw) {
        String temp;
        Matcher m = aliasPattern.matcher(raw);
        AppendingStringBuffer buff = new AppendingStringBuffer(raw.length() + 30);
        int index = 0;
        while (m.find()) {
            if (m.start() > index) {
                buff.append(raw.substring(index, m.start()));
            } else if (m.start() == index) {
                String key = raw.substring(m.start() + 2, m.end() - 1);
                String alias = this.getAlias(key);
                if (alias == null) {
                    alias = key;
                    if (log.isDebugEnabled()) {
                        log.debug("failed to resolve alias: " + key);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("resolved alias: " + key + " to " + alias);
                }
                buff.ensureCapacity(buff.length() + alias.length());
                buff.append(alias);
            } else {
                throw new IllegalStateException("These aliases are not supported: " + raw);
            }
            index = m.end();
        }
        if (index < raw.length()) {
            buff.append(raw.substring(index, raw.length()));
        }
        if ((temp = buff.toString()).indexOf("${") >= 0) {
            throw new IllegalStateException("Nesting aliases is not supported: " + raw);
        }
        return temp;
    }

    public Hive createHive() {
        Closeable stream;
        BasicHive hive = this.isUsingHiveCache() ? new SimpleCachingHive() : new BasicHive();
        boolean readAnything = false;
        Iterator it = this.policyFiles.iterator();
        while (it.hasNext()) {
            readAnything = true;
            URL file = (URL)it.next();
            try {
                this.readPolicyFile(file, hive);
            }
            catch (IOException e) {
                log.error("Could not read from " + file, (Throwable)e);
            }
        }
        it = this.inputStreams.iterator();
        while (it.hasNext()) {
            readAnything = true;
            stream = (InputStream)it.next();
            try {
                this.readInputStream((InputStream)stream, hive);
            }
            catch (IOException e) {
                log.error("Could not read from stream", (Throwable)e);
            }
        }
        this.inputStreams.clear();
        it = this.inputReaders.iterator();
        while (it.hasNext()) {
            readAnything = true;
            stream = (Reader)it.next();
            try {
                this.readInputReader((Reader)stream, hive);
            }
            catch (IOException e) {
                log.error("Could not read from reader", (Throwable)e);
            }
        }
        this.inputReaders.clear();
        if (!readAnything) {
            log.warn("No policyFiles or inputstreams were added to the factory!");
        }
        return hive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void readPolicyFile(URL file, BasicHive hive) throws IOException {
        this.notifyFileStart(file);
        InputStream stream = null;
        try {
            stream = file.openStream();
            this.readStream(stream, hive);
            Object var5_4 = null;
            this.notifyFileClose(file, this.currentLineNr);
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.notifyFileClose(file, this.currentLineNr);
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void readInputStream(InputStream stream, BasicHive hive) throws IOException {
        this.notifyStreamStart(stream);
        try {
            this.readStream(stream, hive);
            Object var4_3 = null;
            this.notifyStreamEnd(stream, this.currentLineNr);
            if (!this.closeInputStreams) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.notifyStreamEnd(stream, this.currentLineNr);
            if (!this.closeInputStreams) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void readInputReader(Reader input, BasicHive hive) throws IOException {
        this.notifyReaderStart(input);
        try {
            this.readReader(input, hive);
            Object var4_3 = null;
            this.notifyReaderEnd(input, this.currentLineNr);
            if (!this.closeInputStreams) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.notifyReaderEnd(input, this.currentLineNr);
            if (!this.closeInputStreams) throw throwable;
            input.close();
            throw throwable;
        }
        input.close();
    }

    protected void readReader(Reader input, BasicHive hive) throws IOException {
        this.read(input, hive);
    }

    protected void notifyStreamEnd(InputStream stream, int lineNr) {
    }

    protected void notifyReaderStart(Reader input) {
    }

    protected void notifyReaderEnd(Reader input, int lineNr) {
    }

    protected void notifyStreamStart(InputStream stream) {
    }

    protected void readStream(InputStream input, BasicHive hive) throws IOException {
        this.read(new InputStreamReader(input), hive);
    }

    protected final void read(Reader input, BasicHive hive) throws IOException {
        BufferedReader reader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        boolean inPrincipalBlock = false;
        Principal principal = null;
        HashSet<Permission> permissions = null;
        this.currentLineNr = 0;
        String line = reader.readLine();
        while (line != null) {
            block41: {
                ++this.currentLineNr;
                if (inPrincipalBlock) {
                    boolean endsWith;
                    String trim = line.trim();
                    boolean startsWith = trim.startsWith("{");
                    if (startsWith) {
                        if (permissions != null || principal == null) {
                            this.skipIllegalPrincipal(this.currentLineNr, principal, permissions);
                        }
                        permissions = new HashSet<Permission>();
                    }
                    if (endsWith = trim.endsWith("};")) {
                        inPrincipalBlock = false;
                        if (permissions != null && permissions.size() > 0) {
                            hive.addPrincipal(principal, permissions);
                        } else {
                            this.skipEmptyPrincipal(this.currentLineNr, principal);
                        }
                        permissions = null;
                        principal = null;
                    }
                    if (!startsWith && !endsWith) {
                        Matcher m = permissionPattern.matcher(line);
                        if (m.matches()) {
                            String classname = m.group(1);
                            if (classname == null) {
                                this.skipPermission(this.currentLineNr, null);
                                line = reader.readLine();
                                continue;
                            }
                            Class<?> permissionClass = null;
                            try {
                                Permission temp;
                                permissionClass = Class.forName(this.resolveAliases(classname));
                                if (!(class$org$apache$wicket$security$hive$authorization$Permission == null ? PolicyFileHiveFactory.class$("org.apache.wicket.security.hive.authorization.Permission") : class$org$apache$wicket$security$hive$authorization$Permission).isAssignableFrom(permissionClass)) {
                                    this.skipPermission(this.currentLineNr, permissionClass);
                                    line = reader.readLine();
                                    continue;
                                }
                                String name = this.resolveAliases(m.group(2));
                                String actions = m.group(3);
                                Constructor<?> constructor = null;
                                Class[] args = stringArgs2;
                                if (actions == null) {
                                    args = stringArgs1;
                                }
                                try {
                                    constructor = permissionClass.getConstructor(args);
                                }
                                catch (SecurityException e) {
                                    log.error("No valid constructor found for " + permissionClass.getName(), (Throwable)e);
                                }
                                catch (NoSuchMethodException e) {
                                    log.error("No valid constructor found for " + permissionClass.getName(), (Throwable)e);
                                }
                                if (constructor == null) {
                                    this.skipPermission(this.currentLineNr, permissionClass, args);
                                    line = reader.readLine();
                                    continue;
                                }
                                Object[] argValues = new Object[]{name, actions};
                                if (actions == null) {
                                    argValues = new Object[]{name};
                                }
                                try {
                                    temp = (Permission)constructor.newInstance(argValues);
                                }
                                catch (Exception e) {
                                    this.skipPermission(this.currentLineNr, permissionClass, argValues, e);
                                    line = reader.readLine();
                                    continue;
                                }
                                if (permissions == null) {
                                    this.skipIllegalPermission(this.currentLineNr, principal, temp);
                                    line = reader.readLine();
                                    continue;
                                }
                                if (!permissions.add(temp)) {
                                    this.skipPermission(this.currentLineNr, principal, temp);
                                } else {
                                    this.notifyPermission(this.currentLineNr, principal, temp);
                                }
                                break block41;
                            }
                            catch (ClassNotFoundException e) {
                                this.skipPermission(this.currentLineNr, classname, e);
                                line = reader.readLine();
                                continue;
                            }
                        }
                        this.skipLine(this.currentLineNr, line);
                    }
                } else {
                    Matcher m = principalPattern.matcher(line);
                    if (m.matches()) {
                        block42: {
                            String classname = m.group(1);
                            if (classname == null) {
                                principal = new EverybodyPrincipal();
                            } else {
                                Class<?> principalClass = null;
                                try {
                                    principalClass = Class.forName(this.resolveAliases(classname));
                                    if (!(class$org$apache$wicket$security$hive$authorization$Principal == null ? PolicyFileHiveFactory.class$("org.apache.wicket.security.hive.authorization.Principal") : class$org$apache$wicket$security$hive$authorization$Principal).isAssignableFrom(principalClass)) {
                                        this.skipPrincipalClass(this.currentLineNr, principalClass);
                                        line = reader.readLine();
                                        continue;
                                    }
                                    Constructor<?> constructor = null;
                                    try {
                                        constructor = principalClass.getConstructor(stringArgs1);
                                    }
                                    catch (SecurityException e) {
                                        log.error("No valid constructor found for " + principalClass.getName(), (Throwable)e);
                                    }
                                    catch (NoSuchMethodException e) {
                                        log.error("No valid constructor found for " + principalClass.getName(), (Throwable)e);
                                    }
                                    if (constructor == null) {
                                        this.skipPrincipal(this.currentLineNr, principalClass);
                                        line = reader.readLine();
                                        continue;
                                    }
                                    try {
                                        principal = (Principal)constructor.newInstance(this.resolveAliases(m.group(2)));
                                        break block42;
                                    }
                                    catch (Exception e) {
                                        this.skipPrincipal(this.currentLineNr, principalClass, e);
                                        line = reader.readLine();
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    this.skipPrincipalClass(this.currentLineNr, classname, e);
                                    line = reader.readLine();
                                }
                                continue;
                            }
                        }
                        this.notifyOfPrincipal(this.currentLineNr, principal);
                        inPrincipalBlock = true;
                    } else {
                        this.skipLine(this.currentLineNr, line);
                    }
                }
            }
            line = reader.readLine();
        }
        if (inPrincipalBlock) {
            this.warnUnclosedPrincipalBlock(principal, this.currentLineNr);
            inPrincipalBlock = false;
            if (permissions != null && permissions.size() > 0) {
                hive.addPrincipal(principal, permissions);
            } else {
                this.skipEmptyPrincipal(this.currentLineNr, principal);
            }
            permissions = null;
            principal = null;
        }
    }

    protected void warnUnclosedPrincipalBlock(Principal principal, int lineNr) {
        log.warn("The principal " + principal + " running to line " + lineNr + " is not properly closed with '};'.");
    }

    protected void notifyFileClose(URL file, int lineNr) {
    }

    protected void notifyFileStart(URL file) {
    }

    protected void skipPermission(int lineNr, String classname, ClassNotFoundException e) {
        log.error("Permission class not found: " + classname + ", line " + lineNr, (Throwable)e);
    }

    protected void notifyPermission(int lineNr, Principal principal, Permission permission) {
    }

    protected void skipPermission(int lineNr, Principal principal, Permission permission) {
        log.debug(permission + " skipped because it was already added to the permission set for " + principal + ", line nr " + lineNr);
    }

    protected void skipIllegalPermission(int lineNr, Principal principal, Permission permission) {
        log.debug(permission + " skipped because the pricipal " + principal + " has not yet declared its opening block statement '{', line nr " + lineNr);
    }

    protected void skipPrincipalClass(int lineNr, String classname, ClassNotFoundException e) {
        log.error("Unable to find principal of class " + classname + " at line nr " + lineNr, (Throwable)e);
    }

    protected void skipPrincipal(int lineNr, Class principalClass) {
        log.error("No valid constructor found for " + principalClass.getName() + " at line " + lineNr);
    }

    protected void notifyOfPrincipal(int lineNr, Principal principal) {
    }

    protected void skipPrincipal(int lineNr, Class principalClass, Exception e) {
        log.error("Unable to create new instance of " + principalClass.getName() + " at line nr " + lineNr, (Throwable)e);
    }

    protected void skipPrincipalClass(int lineNr, Class principalClass) {
        log.error(principalClass.getName() + "is not a subclass of " + Principal.class.getName() + ", line nr " + lineNr);
    }

    protected void skipLine(int lineNr, String line) {
        log.debug("skipping line " + lineNr + ": " + line);
    }

    protected void skipPermission(int lineNr, Class permissionClass, Object[] argValues, Exception e) {
        log.error("Unable to create new instance of class " + permissionClass.getName() + " using the following argument(s) " + this.arrayToString(argValues) + ", line nr " + lineNr, (Throwable)e);
    }

    protected final String arrayToString(Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length < 1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(array.length * 12);
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    protected void skipPermission(int lineNr, Class permissionClass, Class[] args) {
        log.error("No constructor found matching argument(s) " + this.arrayToString(args) + " for class " + permissionClass.getName() + ", line nr " + lineNr);
    }

    protected void skipPermission(int lineNr, Class permissionClass) {
        if (permissionClass == null) {
            log.error("Missing permission class at line " + lineNr);
        } else {
            log.error(permissionClass.getName() + " is not a subclass of " + Permission.class.getName());
        }
    }

    protected void skipEmptyPrincipal(int lineNr, Principal principal) {
        if (log.isDebugEnabled()) {
            log.debug("skipping principal " + principal + ", no permissions found before line nr " + lineNr);
        }
    }

    protected void skipIllegalPrincipal(int lineNr, Principal principal, Set permissions) {
        log.error("Illegal principal block detected at line " + lineNr);
    }

    public final boolean isUsingHiveCache() {
        return this.useHiveCache;
    }

    public final void useHiveCache(boolean useCache) {
        this.useHiveCache = useCache;
    }

    public final boolean isCloseInputStreams() {
        return this.closeInputStreams;
    }

    public final void setCloseInputStreams(boolean closeInputStreams) {
        this.closeInputStreams = closeInputStreams;
    }
}

