/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.wicket.security.hive.Hive;
import org.apache.wicket.security.hive.authentication.Subject;
import org.apache.wicket.security.hive.authorization.Permission;
import org.apache.wicket.security.hive.authorization.Principal;
import org.apache.wicket.security.util.ManyToManyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHive
implements Hive {
    private static final Logger log = LoggerFactory.getLogger((Class)BasicHive.class);
    private ManyToManyMap principals = new ManyToManyMap(500);
    private boolean locked = false;

    public final void lock() {
        this.locked = true;
        if (log.isDebugEnabled()) {
            log.debug("Locking Hive, permissions can not be added anymore.");
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void addPrincipal(Principal principal, Collection permissions) {
        if (this.isLocked()) {
            throw new IllegalStateException("While the hive is locked no changes are allowed.");
        }
        if (principal == null) {
            throw new IllegalArgumentException("A principal is required.");
        }
        if (permissions == null) {
            throw new IllegalArgumentException("At least one permission is required for principal " + principal);
        }
        Iterator it = permissions.iterator();
        Permission next = null;
        boolean debug = log.isDebugEnabled();
        while (it.hasNext()) {
            next = (Permission)it.next();
            this.principals.add(next, principal);
            if (!debug) continue;
            log.debug("Adding " + next + " to " + principal);
        }
    }

    public void addPermission(Principal principal, Permission permission) {
        if (this.isLocked()) {
            throw new IllegalStateException("While the hive is locked no changes are allowed.");
        }
        if (principal == null) {
            throw new IllegalArgumentException("A principal is required.");
        }
        if (permission == null) {
            throw new IllegalArgumentException("A permission is required.");
        }
        this.principals.add(permission, principal);
        if (log.isDebugEnabled()) {
            log.debug("Adding " + permission + " to " + principal);
        }
    }

    public boolean containsPrincipal(Principal principal) {
        return this.principals.contains(principal);
    }

    protected Boolean cacheLookUp(Subject subject, Permission permission) {
        return null;
    }

    protected void cacheResult(Subject subject, Permission permission, boolean result) {
    }

    public boolean hasPermission(Subject subject, Permission permission) {
        Boolean cacheResult = this.cacheLookUp(subject, permission);
        if (cacheResult != null) {
            if (log.isDebugEnabled()) {
                log.debug(subject + " has a cached match for " + permission + ", result " + cacheResult);
            }
            return cacheResult;
        }
        if (this.hasPrincipal(subject, this.principals.get(permission))) {
            if (log.isDebugEnabled()) {
                log.debug(subject + " has an exact match for " + permission);
            }
            this.cacheResult(subject, permission, true);
            return true;
        }
        Iterator it = this.principals.iterator();
        Object temp = null;
        Permission possibleMatch = null;
        while (it.hasNext()) {
            temp = it.next();
            if (!(temp instanceof Permission) || !(possibleMatch = (Permission)temp).implies(permission) || !this.hasPrincipal(subject, this.principals.get(possibleMatch))) continue;
            if (log.isDebugEnabled()) {
                log.debug(subject + " implies " + permission);
            }
            this.cacheResult(subject, permission, true);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(subject + " does not have or implies " + permission);
        }
        this.cacheResult(subject, permission, false);
        return false;
    }

    private boolean hasPrincipal(Subject subject, Set principalSet) {
        if (!principalSet.isEmpty()) {
            Iterator it = principalSet.iterator();
            Set subjectPrincipals = subject == null ? Collections.EMPTY_SET : subject.getPrincipals();
            while (it.hasNext()) {
                Principal temp = (Principal)it.next();
                if (!subjectPrincipals.contains(temp) && !temp.implies(subject)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsPermission(Permission permission) {
        return this.principals.contains(permission);
    }
}

