/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.AbstractLockConfig;
import org.apache.velocity.tools.generic.ValueParser;

@DefaultKey(value="display")
public class DisplayTool
extends AbstractLockConfig {
    public static final String LIST_DELIM_KEY = "listDelim";
    public static final String LIST_FINAL_DELIM_KEY = "listFinalDelim";
    public static final String TRUNCATE_MAX_LENGTH_KEY = "truncateMaxLength";
    public static final String TRUNCATE_SUFFIX_KEY = "truncateSuffix";
    public static final String DEFAULT_ALTERNATE_KEY = "defaultAlternate";
    private String defaultDelim = ", ";
    private String defaultFinalDelim = " and ";
    private int defaultMaxLength = 30;
    private String defaultSuffix = "...";
    private String defaultAlternate = "null";

    protected void configure(ValueParser values) {
        String defaultAlternate;
        String truncateSuffix;
        Integer truncateMaxLength;
        String listFinalDelim;
        String listDelim = values.getString(LIST_DELIM_KEY);
        if (listDelim != null) {
            this.setListDelimiter(listDelim);
        }
        if ((listFinalDelim = values.getString(LIST_FINAL_DELIM_KEY)) != null) {
            this.setListFinalDelimiter(listFinalDelim);
        }
        if ((truncateMaxLength = values.getInteger(TRUNCATE_MAX_LENGTH_KEY)) != null) {
            this.setTruncateMaxLength(truncateMaxLength);
        }
        if ((truncateSuffix = values.getString(TRUNCATE_SUFFIX_KEY)) != null) {
            this.setTruncateSuffix(truncateSuffix);
        }
        if ((defaultAlternate = values.getString(DEFAULT_ALTERNATE_KEY)) != null) {
            this.setDefaultAlternate(defaultAlternate);
        }
    }

    protected void setListDelimiter(String delim) {
        this.defaultDelim = delim;
    }

    protected void setListFinalDelimiter(String finalDelim) {
        this.defaultFinalDelim = finalDelim;
    }

    protected void setTruncateMaxLength(int maxlen) {
        this.defaultMaxLength = maxlen;
    }

    protected void setTruncateSuffix(String suffix) {
        this.defaultSuffix = suffix;
    }

    protected void setDefaultAlternate(String dflt) {
        this.defaultAlternate = dflt;
    }

    public String list(Object list) {
        return this.list(list, this.defaultDelim, this.defaultFinalDelim);
    }

    public String list(Object list, String delim) {
        return this.list(list, delim, delim);
    }

    public String list(Object list, String delim, String finaldelim) {
        List<Object> items;
        if (list == null) {
            return null;
        }
        if (list instanceof Collection) {
            return this.format((Collection)list, delim, finaldelim);
        }
        if (list.getClass().isArray()) {
            int size = Array.getLength(list);
            items = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                items.add(Array.get(list, i));
            }
        } else {
            items = Collections.singletonList(list);
        }
        return this.format(items, delim, finaldelim);
    }

    protected String format(Collection list, String delim, String finaldelim) {
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        System.out.println("formatting " + size + " items");
        Iterator iterator = list.iterator();
        for (int i = 0; i < size; ++i) {
            sb.append(iterator.next());
            if (i < size - 2) {
                sb.append(delim);
                continue;
            }
            if (i >= size - 1) continue;
            sb.append(finaldelim);
        }
        return sb.toString();
    }

    public String truncate(Object truncateMe) {
        return this.truncate(truncateMe, this.defaultMaxLength);
    }

    public String truncate(Object truncateMe, int maxLength) {
        return this.truncate(truncateMe, maxLength, this.defaultSuffix);
    }

    public String truncate(Object truncateMe, String suffix) {
        return this.truncate(truncateMe, this.defaultMaxLength, suffix);
    }

    public String truncate(Object truncateMe, int maxLength, String suffix) {
        if (truncateMe == null) {
            return null;
        }
        String string = String.valueOf(truncateMe);
        if (string.length() <= maxLength) {
            return string;
        }
        return string.substring(0, maxLength - suffix.length()) + suffix;
    }

    public Object alt(Object checkMe) {
        return this.alt(checkMe, this.defaultAlternate);
    }

    public Object alt(Object checkMe, Object alternate) {
        if (checkMe == null) {
            return alternate;
        }
        return checkMe;
    }
}

