/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.config.FactoryConfiguration;

public abstract class FileFactoryConfiguration
extends FactoryConfiguration {
    public abstract void read(InputStream var1) throws IOException;

    public void read(String path) {
        this.read(path, true);
    }

    public void read(String path, boolean required) {
        this.read(path, required, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String path, boolean required, Log log) {
        if (path == null) {
            throw new NullPointerException("Path value cannot be null");
        }
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)("Attempting to read configuration file at: " + path));
        }
        InputStream inputStream = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fnfe) {
                    throw new IllegalStateException(fnfe);
                }
            } else {
                inputStream = this.getClass().getResourceAsStream(path);
            }
            if (inputStream == null) {
                String msg = "Could not find configuration file at: " + path;
                if (log != null) {
                    log.debug((Object)msg);
                }
                if (required) {
                    throw new ResourceNotFoundException(msg);
                }
            } else {
                this.read(inputStream);
            }
        }
        catch (IOException ioe) {
            String msg = "InputStream could not be read from file at: " + path;
            if (log != null) {
                log.debug((Object)msg, (Throwable)ioe);
            }
            if (required) {
                throw new RuntimeException(msg, ioe);
            }
        }
        finally {
            block25: {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ioe) {
                    if (log == null) break block25;
                    log.error((Object)("Failed to close input stream for " + path), (Throwable)ioe);
                }
            }
        }
    }
}

