/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.tools.ToolboxFactory;
import org.apache.velocity.tools.config.CompoundConfiguration;
import org.apache.velocity.tools.config.Data;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.apache.velocity.tools.config.XmlFactoryConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryConfiguration
extends CompoundConfiguration<ToolboxConfiguration> {
    public static final String GENERIC_CONFIGURATION_PATH = "/org/apache/velocity/tools/generic/tools.xml";
    public static final String VIEW_CONFIGURATION_PATH = "/org/apache/velocity/tools/view/tools.xml";
    public static final String STRUTS_CONFIGURATION_PATH = "/org/apache/velocity/tools/struts/tools.xml";
    private List<Data> data = new ArrayList<Data>();

    @Override
    protected ToolboxConfiguration findMatchingChild(ToolboxConfiguration newToolbox) {
        for (ToolboxConfiguration toolbox : this.getToolboxes()) {
            if (!newToolbox.getScope().equals(toolbox.getScope())) continue;
            return toolbox;
        }
        return null;
    }

    public void addData(Data datum) {
        this.data.add(datum);
    }

    public boolean removeData(Data datum) {
        return this.data.remove(datum);
    }

    public List<Data> getData() {
        return this.data;
    }

    public void addToolbox(ToolboxConfiguration toolbox) {
        this.addChild(toolbox);
    }

    public void removeToolbox(ToolboxConfiguration toolbox) {
        this.removeChild(toolbox);
    }

    public List<ToolboxConfiguration> getToolboxes() {
        return this.getChildren();
    }

    public void addConfiguration(FactoryConfiguration config) {
        super.addConfiguration(config);
        for (ToolboxConfiguration newToolbox : config.getToolboxes()) {
            ToolboxConfiguration child = this.findMatchingChild(newToolbox);
            if (child == null) {
                this.addToolbox(newToolbox);
                continue;
            }
            child.addConfiguration(newToolbox);
        }
        for (Data datum : config.getData()) {
            this.addData(datum);
        }
    }

    @Override
    public void validate() {
        super.validate();
        for (Data data : this.getData()) {
            data.validate();
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("\nFactoryConfiguration ");
        this.appendProperties(out);
        if (!this.getData().isEmpty()) {
            out.append(" including ");
            out.append(this.getData().size());
            out.append(" data");
        }
        this.appendChildren(out, "toolboxes: \n ", "\n ");
        if (!this.getData().isEmpty()) {
            for (Data datum : this.getData()) {
                out.append(datum);
                out.append("\n ");
            }
        }
        return out.toString();
    }

    public ToolboxFactory createFactory() {
        ToolboxFactory factory = new ToolboxFactory();
        factory.configure(this);
        return factory;
    }

    public static FactoryConfiguration getDefault() {
        XmlFactoryConfiguration config = new XmlFactoryConfiguration();
        config.read(GENERIC_CONFIGURATION_PATH);
        config.read(VIEW_CONFIGURATION_PATH, false);
        config.read(STRUTS_CONFIGURATION_PATH, false);
        return config;
    }

    public static ToolboxFactory createDefaultFactory() {
        ToolboxFactory factory = new ToolboxFactory();
        factory.configure(FactoryConfiguration.getDefault());
        return factory;
    }
}

