/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import org.apache.velocity.tools.config.Configuration;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyFactoryConfiguration
extends FactoryConfiguration {
    private boolean addedDefault = false;
    private EasyWrap<ToolboxConfiguration> toolbox;

    public EasyFactoryConfiguration() {
        this(false);
    }

    public EasyFactoryConfiguration(boolean startWithDefault) {
        if (startWithDefault) {
            this.addDefault();
        }
    }

    public EasyFactoryConfiguration addDefault() {
        if (!this.addedDefault) {
            this.addConfiguration(EasyFactoryConfiguration.getDefault());
            this.addedDefault = true;
        }
        return this;
    }

    public EasyWrap<ToolboxConfiguration> toolbox(String scope) {
        ToolboxConfiguration toolbox = new ToolboxConfiguration();
        toolbox.setScope(scope);
        this.addToolbox(toolbox);
        this.toolbox = new EasyWrap(this, (Configuration)toolbox, (Configuration)this);
        return this.toolbox;
    }

    public EasyWrap<ToolConfiguration> tool(String classname) {
        return this.tool(null, classname);
    }

    public EasyWrap<ToolConfiguration> tool(Class clazz) {
        return this.tool(null, clazz);
    }

    public EasyWrap<ToolConfiguration> tool(String key, String classname) {
        if (this.toolbox == null) {
            this.toolbox("request");
        }
        return this.toolbox.tool(key, classname);
    }

    public EasyWrap<ToolConfiguration> tool(String key, Class clazz) {
        return this.tool(key, clazz.getName());
    }

    public EasyFactoryConfiguration property(String name, Object value) {
        this.setProperty(name, value);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EasyWrap<C extends Configuration> {
        private C config;
        private Configuration parent;
        final /* synthetic */ EasyFactoryConfiguration this$0;

        public EasyWrap(C config, Configuration parent) {
            this.this$0 = var1_1;
            this.config = config;
            this.parent = parent;
        }

        public C getConfiguration() {
            return this.config;
        }

        public Configuration getParent() {
            return this.parent;
        }

        public C property(String name, Object value) {
            ((Configuration)this.config).setProperty(name, value);
            return this.config;
        }

        public C restrictTo(String path) {
            if (this.config instanceof ToolConfiguration) {
                ToolConfiguration tool = (ToolConfiguration)this.config;
                tool.setRestrictTo(path);
            } else if (this.config instanceof ToolboxConfiguration) {
                ToolboxConfiguration toolbox = (ToolboxConfiguration)this.config;
                for (ToolConfiguration tool : toolbox.getTools()) {
                    tool.setRestrictTo(path);
                }
            }
            throw new IllegalStateException("Wrapping unknown " + Configuration.class.getName() + ": " + this.getConfiguration());
        }

        public EasyWrap addDefault() {
            this.this$0.addDefault();
            return this;
        }

        public EasyWrap tool(Class clazz) {
            return this.tool(null, clazz);
        }

        public EasyWrap tool(String classname) {
            return this.tool(null, classname);
        }

        public EasyWrap tool(String key, Class clazz) {
            return this.tool(key, clazz.getName());
        }

        public EasyWrap tool(String key, String classname) {
            ToolConfiguration tool = new ToolConfiguration();
            if (key != null) {
                tool.setKey(key);
            }
            tool.setClassname(classname);
            if (this.config instanceof ToolConfiguration) {
                ToolboxConfiguration toolbox = (ToolboxConfiguration)this.getParent();
                toolbox.addTool(tool);
                return new EasyWrap(this.this$0, (Configuration)tool, (Configuration)toolbox);
            }
            if (this.config instanceof ToolboxConfiguration) {
                ToolboxConfiguration toolbox = (ToolboxConfiguration)this.getConfiguration();
                toolbox.addTool(tool);
                return new EasyWrap(this.this$0, (Configuration)tool, (Configuration)toolbox);
            }
            throw new IllegalStateException("Wrapping unknown " + Configuration.class.getName() + ": " + this.getConfiguration());
        }
    }
}

