/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.docanalyzer;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.uima.tools.docanalyzer.FileSelectorListener;

public class FileSelector
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = -8710960143421949274L;
    private JTextField field;
    private BrowseButton browseButton;
    private JFileChooser fileChooser;
    private FileSelectorListener fileSelectorListener;
    private String previousValue;
    private FocusListener externalFl;

    public FileSelector(String initialValue, String fileChooserTitle, int selectionMode) {
        this(initialValue, fileChooserTitle, selectionMode, null);
    }

    public FileSelector(String initialValue, String fileChooserTitle, int selectionMode, File currentDir) {
        if (currentDir == null && initialValue != null) {
            currentDir = new File(initialValue).getAbsoluteFile();
        }
        this.setLayout(new BoxLayout(this, 0));
        this.field = new JTextField(initialValue, 20);
        this.field.addFocusListener(this);
        this.add(this.field);
        this.previousValue = initialValue == null ? "" : initialValue;
        this.add(Box.createHorizontalStrut(8));
        this.browseButton = new BrowseButton("Browse..");
        this.add(this.browseButton);
        final File selected = initialValue == null ? null : new File(initialValue);
        this.fileChooser = new JFileChooser(currentDir);
        this.fileChooser.setDialogTitle(fileChooserTitle);
        this.fileChooser.setFileSelectionMode(selectionMode);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (selected != null && selected.exists()) {
                    FileSelector.this.fileChooser.setSelectedFile(selected);
                }
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = FileSelector.this.fileChooser.showOpenDialog(FileSelector.this.browseButton);
                if (returnVal == 0) {
                    File file = FileSelector.this.fileChooser.getSelectedFile();
                    String fileString = file.getAbsolutePath();
                    if (FileSelector.this.fileSelectorListener != null) {
                        boolean result = FileSelector.this.fileSelectorListener.fileSelected(FileSelector.this, fileString);
                        if (result) {
                            FileSelector.this.field.setText(fileString);
                            FileSelector.this.previousValue = fileString;
                        } else {
                            FileSelector.this.fileChooser.setSelectedFile(new File(FileSelector.this.previousValue));
                        }
                    } else {
                        FileSelector.this.field.setText(fileString);
                        FileSelector.this.previousValue = fileString;
                    }
                }
            }
        });
        this.field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String fileString = FileSelector.this.field.getText();
                if (!fileString.equals(FileSelector.this.previousValue)) {
                    if (FileSelector.this.fileSelectorListener != null) {
                        boolean result = FileSelector.this.fileSelectorListener.fileSelected(FileSelector.this, fileString);
                        if (result) {
                            FileSelector.this.previousValue = fileString;
                        } else {
                            FileSelector.this.fileChooser.setSelectedFile(FileSelector.this.previousValue == null ? null : new File(FileSelector.this.previousValue));
                        }
                    } else {
                        FileSelector.this.previousValue = fileString;
                    }
                }
            }
        });
        if (this.externalFl != null) {
            this.field.addFocusListener(this.externalFl);
        }
        this.field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String fileString = FileSelector.this.field.getText();
                    if (FileSelector.this.fileSelectorListener != null) {
                        String oldValue = FileSelector.this.previousValue;
                        FileSelector.this.previousValue = fileString;
                        boolean result = FileSelector.this.fileSelectorListener.fileSelected(FileSelector.this, fileString);
                        if (!result) {
                            FileSelector.this.previousValue = oldValue;
                            FileSelector.this.fileChooser.setSelectedFile(FileSelector.this.previousValue == null ? null : new File(FileSelector.this.previousValue));
                        }
                    } else {
                        FileSelector.this.previousValue = fileString;
                    }
                }
            }
        });
    }

    public void addFileSelectorListener(FileSelectorListener aFileSelectorListener) {
        this.fileSelectorListener = aFileSelectorListener;
    }

    public void addFocusListener(FocusListener fl) {
        this.externalFl = fl;
    }

    public void addChoosableFileFilter(FileFilter ff) {
        this.fileChooser.addChoosableFileFilter(ff);
    }

    public String getSelected() {
        return this.field.getText().trim();
    }

    public void setSelected(String s) {
        s = s.trim();
        this.field.setText(s);
        if (s.length() == 0) {
            s = System.getProperty("user.dir");
        }
        File file = new File(s);
        if (this.fileChooser.getFileSelectionMode() == 0 && file.isDirectory()) {
            this.fileChooser.setCurrentDirectory(file);
        } else {
            this.fileChooser.setSelectedFile(file);
        }
    }

    public void setEnabled(boolean onOff) {
        this.field.setEnabled(onOff);
        this.browseButton.setEnabled(onOff);
    }

    public void clear() {
        this.field.setText("");
    }

    public void focusGained(FocusEvent aEvent) {
    }

    public void focusLost(FocusEvent aEvent) {
        if (aEvent.getComponent() == this.field) {
            String path = this.getSelected();
            if (path.length() == 0) {
                path = System.getProperty("user.dir");
            }
            File file = new File(path);
            if (this.fileChooser.getFileSelectionMode() == 0 && file.isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            } else {
                this.fileChooser.setSelectedFile(file);
            }
        }
        if (this.externalFl != null) {
            this.externalFl.focusLost(aEvent);
        }
    }

    public synchronized void addDocumentListener(DocumentListener l) {
        this.field.getDocument().addDocumentListener(l);
    }

    public synchronized void removeDocumentListener(DocumentListener l) {
        this.field.getDocument().removeDocumentListener(l);
    }

    static class BrowseButton
    extends JButton {
        private static final long serialVersionUID = 7366026783079468609L;

        public BrowseButton(String s) {
            super(s);
        }

        public Insets getInsets() {
            return new Insets(3, 6, 3, 6);
        }
    }
}

