/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.textui.ResultPrinter;

public class UIMAResultPrinter
extends ResultPrinter
implements TestListener {
    private PrintStream fWriter;
    private int fColumn = 0;
    private int testCounter;
    private String currentTestClass;
    private boolean currentTestSuccess;
    private boolean abortOnFail;
    private boolean teeOutputStream;

    public UIMAResultPrinter(PrintStream writer, boolean abortOnFail, boolean teeOutputStream) {
        super(writer);
        this.fWriter = writer;
        this.testCounter = 0;
        this.currentTestClass = null;
        this.currentTestSuccess = true;
        this.abortOnFail = abortOnFail;
        this.teeOutputStream = teeOutputStream;
    }

    protected void printHeader(long runTime) {
        this.getWriter().println();
        this.getWriter().println();
        this.getWriter().println("Time: " + this.elapsedTimeAsString(runTime));
    }

    protected void printErrors(TestResult result) {
        this.printDefects(result.errors(), result.errorCount(), "error");
    }

    protected void printFailures(TestResult result) {
        this.printDefects(result.failures(), result.failureCount(), "failure");
    }

    protected void printDefects(Enumeration booBoos, int count, String type) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.getWriter().println("There was " + count + " " + type + ":");
        } else {
            this.getWriter().println("There were " + count + " " + type + "s:");
        }
        int i = 1;
        while (booBoos.hasMoreElements()) {
            this.printDefect((TestFailure)booBoos.nextElement(), i);
            ++i;
        }
    }

    public void printDefect(TestFailure booBoo, int count) {
        this.printDefectHeader(booBoo, count);
        this.printDefectTrace(booBoo);
    }

    protected void printDefectHeader(TestFailure booBoo, int count) {
        this.getWriter().print(count + ") " + String.valueOf(booBoo.failedTest()));
    }

    protected void printDefectTrace(TestFailure booBoo) {
        this.getWriter().print(BaseTestRunner.getFilteredTrace((String)booBoo.trace()));
    }

    protected void printFooter(TestResult result) {
        if (result.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            this.getWriter().println(" (" + result.runCount() + " test" + (result.runCount() == 1 ? "" : "s") + ")");
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            this.getWriter().println("Tests run: " + result.runCount() + ",  Failures: " + result.failureCount() + ",  Errors: " + result.errorCount());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public PrintStream getWriter() {
        return this.fWriter;
    }

    public void addError(Test test, Throwable t) {
        this.getWriter().print("error");
        this.currentTestSuccess = false;
        if (this.abortOnFail) {
            this.getWriter().println();
            this.getWriter().println();
            this.getWriter().println("Stop executing testcases...");
            this.getWriter().println("Print Stacktrace: ");
            this.getWriter().println();
            StackTraceElement[] stackTrace = t.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                this.getWriter().println(stackTrace[i].toString());
            }
            throw new RuntimeException("Abort on error");
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.getWriter().print("failure");
        this.currentTestSuccess = false;
        if (this.abortOnFail) {
            this.getWriter().println();
            this.getWriter().println();
            this.getWriter().println("Stop executing testcases...");
            this.getWriter().println("Print Stacktrace: ");
            this.getWriter().println();
            StackTraceElement[] stackTrace = t.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                this.getWriter().println(stackTrace[i].toString());
            }
            throw new RuntimeException("Abort on failure");
        }
    }

    public void endTest(Test test) {
        if (!this.currentTestSuccess) {
            this.currentTestSuccess = true;
        } else {
            this.getWriter().print("ok");
        }
    }

    public void startTest(Test test) {
        ++this.testCounter;
        String name = test.toString();
        String tempCurrentTestClass = name.substring(name.indexOf(40) + 1, name.lastIndexOf(41));
        String testName = name.substring(0, name.indexOf(40));
        if (!tempCurrentTestClass.equals(this.currentTestClass)) {
            this.currentTestClass = tempCurrentTestClass;
            this.getWriter().println();
            this.getWriter().println();
            this.getWriter().print(this.currentTestClass);
            this.getWriter().println();
            for (int i = 0; i < this.currentTestClass.length(); ++i) {
                this.getWriter().print("=");
            }
        }
        this.getWriter().println();
        this.getWriter().print(this.testCounter + ":  " + testName + ": ");
        if (this.fColumn++ >= 40 || this.teeOutputStream) {
            this.getWriter().println();
            this.fColumn = 0;
        }
    }
}

