/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex3;

import java.text.BreakIterator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tutorial.DateAnnot;
import org.apache.uima.tutorial.DateTimeAnnot;
import org.apache.uima.tutorial.TimeAnnot;
import org.apache.uima.util.Level;

public class TutorialDateTime
extends JCasAnnotator_ImplBase {
    JCas jcas;
    String input;
    ParsePosition pp = new ParsePosition(0);
    static final Pattern hoursMinutesPattern = Pattern.compile("(?s)\\b([0-2]?\\d:[0-5]\\d\\s*(AM\\W|PM\\W|am\\W|pm\\W)?)");
    static final DateFormat dfTimeShort = DateFormat.getTimeInstance(3, Locale.US);
    static final Pattern numericDatePattern = Pattern.compile("(?s)\\b([0-1]?\\d/[0-3]?\\d((/[1-2]\\d\\d\\d)|(/\\d\\d))?)\\W");
    final DateFormat dfDateShort = DateFormat.getDateInstance(3, Locale.US);
    static final String shortMonthNames = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Sept|Oct|Nov|Dec)";
    static final Pattern mediumDatePattern = Pattern.compile("(?s)\\b((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Sept|Oct|Nov|Dec)\\.?\\s[0-3]?\\d(((,\\s+)?[1-2]\\d\\d\\d)|((,\\s+)?\\d\\d))?)\\W");
    static final DateFormat dfDateMedium = DateFormat.getDateInstance(2, Locale.US);
    static final String longMonthNames = "(January|February|March|April|June|July|August|September|October|November|December)";
    static final Pattern longDatePattern = Pattern.compile("(?s)\\b((January|February|March|April|June|July|August|September|October|November|December)\\s[0-3]?\\d(((,\\s+)?[1-2]\\d\\d\\d)|((,\\s+)?\\d\\d))?)\\W");
    static final DateFormat dfDateLong = DateFormat.getDateInstance(1, Locale.US);
    static final NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    static final Maker dateAnnotationMaker = new Maker(){

        Annotation newAnnotation(JCas jcas, int start, int end) {
            return new DateAnnot(jcas, start, end);
        }
    };
    static final Maker timeAnnotationMaker = new Maker(){

        Annotation newAnnotation(JCas jcas, int start, int end) {
            return new TimeAnnot(jcas, start, end);
        }
    };
    static final String defaultYear = "2003";
    private static boolean warningMessageShown = false;

    public void process(JCas aJCas) {
        this.jcas = aJCas;
        this.input = this.jcas.getDocumentText();
        ResultSpecification resultSpec = this.getResultSpecification();
        boolean timeWanted = resultSpec.containsType("org.apache.uima.tutorial.TimeAnnot", aJCas.getDocumentLanguage());
        boolean dateWanted = resultSpec.containsType("org.apache.uima.tutorial.DateAnnot", aJCas.getDocumentLanguage());
        if (timeWanted) {
            this.makeAnnotations(timeAnnotationMaker, hoursMinutesPattern, dfTimeShort);
        }
        if (dateWanted) {
            this.makeAnnotations(dateAnnotationMaker, numericDatePattern, this.dfDateShort);
            this.makeAnnotations(dateAnnotationMaker, mediumDatePattern, dfDateMedium);
            this.makeAnnotations(dateAnnotationMaker, longDatePattern, dfDateLong);
        }
        if (!(timeWanted || dateWanted || warningMessageShown)) {
            String m = String.format("No output is being produced by the TutorialDateTime annotator because the Result Specification did not contain a request for the type%n  org.apache.uima.tutorial.TimeAnnot nor%n  org.apache.uima.tutorial.DateAnnot with the language '%s'%n  (Note: this message will only be shown once.)%n", aJCas.getDocumentLanguage());
            System.err.println(m);
            this.getContext().getLogger().log(Level.WARNING, m);
            warningMessageShown = true;
        }
    }

    void makeAnnotations(Maker m, BreakIterator b) {
        b.setText(this.input);
        int end = b.next();
        int start = b.first();
        while (end != -1) {
            boolean isWhitespace = true;
            for (int i = start; i < end; ++i) {
                if (Character.isWhitespace(this.input.charAt(i))) continue;
                isWhitespace = false;
                break;
            }
            if (!isWhitespace) {
                m.newAnnotation(this.jcas, start, end).addToIndexes();
            }
            start = end;
            end = b.next();
        }
    }

    void makeAnnotations(Maker m, Pattern pattern, DateFormat dateFormat) {
        Matcher matcher = pattern.matcher(this.input);
        while (matcher.find()) {
            int start = matcher.start(1);
            String matched = this.fixUpDateTimeStrings(matcher.group(1));
            DateTimeAnnot dtAnnot = (DateTimeAnnot)m.newAnnotation(this.jcas, start, matcher.end(1));
            this.pp.setIndex(0);
            Date dtSpec = dateFormat.parse(matched, this.pp);
            if (dtSpec != null) {
                dtAnnot.setShortDateString(this.dfDateShort.format(dtSpec));
            }
            dtAnnot.addToIndexes();
        }
    }

    String fixUpDateTimeStrings(String s) {
        this.pp.setIndex(0);
        if (-1 < s.indexOf(":")) {
            if (s.endsWith("AM") || s.endsWith("PM") || s.endsWith("am") || s.endsWith("pm")) {
                return s;
            }
            int hour = numberFormat.parse(s, this.pp).intValue();
            String av = 0 == hour ? " AM" : (hour < 9 ? " PM" : " AM");
            return s + av;
        }
        return s + ", " + defaultYear;
    }

    static abstract class Maker {
        Maker() {
        }

        abstract Annotation newAnnotation(JCas var1, int var2, int var3);
    }
}

