/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterDeclarations_impl;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterSettings_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;

public class ResourceMetaData_impl
extends MetaDataObject_impl
implements ResourceMetaData {
    static final long serialVersionUID = 3408359518094534817L;
    private String mUUID;
    private String mName;
    private String mDescription;
    private String mVersion;
    private String mVendor;
    private String mCopyright;
    private ConfigurationParameterDeclarations mConfigurationParameterDeclarations = new ConfigurationParameterDeclarations_impl();
    private ConfigurationParameterSettings mConfigurationParameterSettings = new ConfigurationParameterSettings_impl();
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("resourceMetaData", new PropertyXmlInfo[]{new PropertyXmlInfo("name", false), new PropertyXmlInfo("description"), new PropertyXmlInfo("version"), new PropertyXmlInfo("vendor"), new PropertyXmlInfo("copyright"), new PropertyXmlInfo("configurationParameterDeclarations", null), new PropertyXmlInfo("configurationParameterSettings", null)});

    public void resolveImports() throws InvalidXMLException {
    }

    public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
    }

    public String getUUID() {
        return this.mUUID;
    }

    public void setUUID(String aUUID) {
        this.mUUID = aUUID;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    public String getCopyright() {
        return this.mCopyright;
    }

    public void setCopyright(String aCopyright) {
        this.mCopyright = aCopyright;
    }

    public ConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.mConfigurationParameterSettings;
    }

    public void setConfigurationParameterSettings(ConfigurationParameterSettings aSettings) {
        this.mConfigurationParameterSettings = aSettings;
    }

    public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
        return this.mConfigurationParameterDeclarations;
    }

    public void setConfigurationParameterDeclarations(ConfigurationParameterDeclarations aDeclarations) {
        this.mConfigurationParameterDeclarations = aDeclarations;
    }

    public void validateConfigurationParameterSettings() throws ResourceConfigurationException {
        ConfigurationParameterDeclarations cfgParamDecls = this.getConfigurationParameterDeclarations();
        ConfigurationParameterSettings cfgParamSettings = this.getConfigurationParameterSettings();
        NameValuePair[] nvps = cfgParamSettings.getParameterSettings();
        if (nvps.length > 0) {
            this.validateConfigurationParameterSettings(nvps, null, cfgParamDecls);
        } else {
            Map<String, NameValuePair[]> settingsForGroups = cfgParamSettings.getSettingsForGroups();
            Set<Map.Entry<String, NameValuePair[]>> entrySet = settingsForGroups.entrySet();
            for (Map.Entry<String, NameValuePair[]> entry : entrySet) {
                String groupName = entry.getKey();
                nvps = entry.getValue();
                if (nvps == null) continue;
                this.validateConfigurationParameterSettings(nvps, groupName, cfgParamDecls);
            }
        }
    }

    protected void validateConfigurationParameterSettings(NameValuePair[] aNVPs, String aGroupName, ConfigurationParameterDeclarations aParamDecls) throws ResourceConfigurationException {
        for (int i = 0; i < aNVPs.length; ++i) {
            String name = aNVPs[i].getName();
            ConfigurationParameter param = aParamDecls.getConfigurationParameter(aGroupName, name);
            if (param == null) {
                if (aGroupName == null) {
                    throw new ResourceConfigurationException("nonexistent_parameter", new Object[]{name, this.getName()});
                }
                throw new ResourceConfigurationException("nonexistent_parameter_in_group", new Object[]{name, aGroupName, this.getName()});
            }
            this.validateConfigurationParameterDataTypeMatch(param, aNVPs[i]);
        }
    }

    protected void validateConfigurationParameterDataTypeMatch(ConfigurationParameter aParam, NameValuePair aNVP) throws ResourceConfigurationException {
        String paramName = aParam.getName();
        String paramType = aParam.getType();
        Class<?> valClass = aNVP.getValue().getClass();
        if (aParam.isMultiValued()) {
            if (!valClass.isArray()) {
                throw new ResourceConfigurationException("array_required", new Object[]{paramName, this.getName()});
            }
            valClass = valClass.getComponentType();
            if (Array.getLength(aNVP.getValue()) == 0 && valClass.equals(Object.class)) {
                aNVP.setValue(Array.newInstance(this.getClassForParameterType(paramType), 0));
                return;
            }
        }
        if (valClass != this.getClassForParameterType(paramType)) {
            throw new ResourceConfigurationException("parameter_type_mismatch", new Object[]{this.getName(), valClass.getName(), paramName, paramType});
        }
    }

    protected Class getClassForParameterType(String paramType) {
        if ("String".equals(paramType)) {
            return String.class;
        }
        if ("Boolean".equals(paramType)) {
            return Boolean.class;
        }
        if ("Integer".equals(paramType)) {
            return Integer.class;
        }
        if ("Float".equals(paramType)) {
            return Float.class;
        }
        return null;
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        super.buildFromXMLElement(aElement, aParser, aOptions);
        try {
            this.validateConfigurationParameterSettings();
        }
        catch (ResourceConfigurationException e) {
            throw new InvalidXMLException(e);
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    protected static XmlizationInfo getXmlizationInfoForClass() {
        return XMLIZATION_INFO;
    }
}

