/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.LanguagePrecondition;
import org.apache.uima.resource.metadata.MimeTypePrecondition;
import org.apache.uima.resource.metadata.Precondition;
import org.apache.uima.resource.metadata.impl.LanguagePrecondition_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.MimeTypePrecondition_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;

public class Capability_impl
extends MetaDataObject_impl
implements Capability {
    static final long serialVersionUID = -2821073595288674925L;
    private String mDescription;
    private TypeOrFeature[] mInputs = new TypeOrFeature[0];
    private TypeOrFeature[] mOutputs = new TypeOrFeature[0];
    private Precondition[] mPreconditions = new Precondition[0];
    private String[] mInputSofas = new String[0];
    private String[] mOutputSofas = new String[0];
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("capability", new PropertyXmlInfo[]{new PropertyXmlInfo("description"), new PropertyXmlInfo("inputs", false), new PropertyXmlInfo("outputs", false), new PropertyXmlInfo("inputSofas", "inputSofas", true, "sofaName"), new PropertyXmlInfo("outputSofas", "outputSofas", true, "sofaName"), new PropertyXmlInfo("languagesSupported", "languagesSupported", false, "language"), new PropertyXmlInfo("mimeTypesSupported", "mimeTypesSupported", true, "mimeType")});

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public TypeOrFeature[] getInputs() {
        return this.mInputs;
    }

    public TypeOrFeature[] getOutputs() {
        return this.mOutputs;
    }

    public Precondition[] getPreconditions() {
        return this.mPreconditions;
    }

    public String[] getLanguagesSupported() {
        Precondition[] preconditions = this.getPreconditions();
        for (int i = 0; i < preconditions.length; ++i) {
            if (!(preconditions[i] instanceof LanguagePrecondition)) continue;
            return ((LanguagePrecondition)preconditions[i]).getLanguages();
        }
        return new String[0];
    }

    public String[] getMimeTypesSupported() {
        Precondition[] preconditions = this.getPreconditions();
        for (int i = 0; i < preconditions.length; ++i) {
            if (!(preconditions[i] instanceof MimeTypePrecondition)) continue;
            return ((MimeTypePrecondition)preconditions[i]).getMimeTypes();
        }
        return new String[0];
    }

    public void setInputs(TypeOrFeature[] aInputs) {
        this.mInputs = aInputs;
    }

    public void setOutputs(TypeOrFeature[] aOutputs) {
        this.mOutputs = aOutputs;
    }

    public void setPreconditions(Precondition[] aPreconditions) {
        this.mPreconditions = aPreconditions;
    }

    public void setLanguagesSupported(String[] aLanguageIDs) {
        ArrayList<Precondition> preconditions = new ArrayList<Precondition>();
        Precondition[] precondArray = this.getPreconditions();
        if (precondArray != null) {
            preconditions.addAll(Arrays.asList(precondArray));
        }
        Iterator i = preconditions.iterator();
        while (i.hasNext()) {
            Precondition p = (Precondition)i.next();
            if (!(p instanceof LanguagePrecondition)) continue;
            i.remove();
        }
        if (aLanguageIDs != null && aLanguageIDs.length > 0) {
            LanguagePrecondition_impl languagePrecond = new LanguagePrecondition_impl();
            languagePrecond.setLanguages(aLanguageIDs);
            preconditions.add(languagePrecond);
        }
        Precondition[] newPrecondArray = new Precondition[preconditions.size()];
        preconditions.toArray(newPrecondArray);
        this.setPreconditions(newPrecondArray);
    }

    public void setMimeTypesSupported(String[] aMimeTypes) {
        ArrayList<Precondition> preconditions = new ArrayList<Precondition>();
        Precondition[] precondArray = this.getPreconditions();
        if (precondArray != null) {
            preconditions.addAll(Arrays.asList(precondArray));
        }
        Iterator i = preconditions.iterator();
        while (i.hasNext()) {
            Precondition p = (Precondition)i.next();
            if (!(p instanceof MimeTypePrecondition)) continue;
            i.remove();
        }
        if (aMimeTypes != null && aMimeTypes.length > 0) {
            MimeTypePrecondition_impl mimeTypePrecond = new MimeTypePrecondition_impl();
            mimeTypePrecond.setMimeTypes(aMimeTypes);
            preconditions.add(mimeTypePrecond);
        }
        Precondition[] newPrecondArray = new Precondition[preconditions.size()];
        preconditions.toArray(newPrecondArray);
        this.setPreconditions(newPrecondArray);
    }

    public void addInputType(String aTypeName, boolean aAllAnnotatorFeatures) {
        TypeOrFeature type = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        type.setType(true);
        type.setName(aTypeName);
        type.setAllAnnotatorFeatures(aAllAnnotatorFeatures);
        TypeOrFeature[] oldArr = this.getInputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = type;
        this.setInputs(newArr);
    }

    public void addInputFeature(String aFeatureName) {
        TypeOrFeature feat = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        feat.setType(false);
        feat.setName(aFeatureName);
        TypeOrFeature[] oldArr = this.getInputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = feat;
        this.setInputs(newArr);
    }

    public void addOutputType(String aTypeName, boolean aAllAnnotatorFeatures) {
        TypeOrFeature type = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        type.setType(true);
        type.setName(aTypeName);
        type.setAllAnnotatorFeatures(aAllAnnotatorFeatures);
        TypeOrFeature[] oldArr = this.getOutputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = type;
        this.setOutputs(newArr);
    }

    public void addOutputFeature(String aFeatureName) {
        TypeOrFeature feat = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        feat.setType(false);
        feat.setName(aFeatureName);
        TypeOrFeature[] oldArr = this.getOutputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = feat;
        this.setOutputs(newArr);
    }

    public void addSupportedLanguage(String aLanguage) {
        String[] oldArr = this.getLanguagesSupported();
        String[] newArr = new String[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = aLanguage;
        this.setLanguagesSupported(newArr);
    }

    public void removeSupportedLanguage(String aLanguage) {
        String[] current = this.getLanguagesSupported();
        for (int i = 0; i < current.length; ++i) {
            if (!current[i].equals(aLanguage)) continue;
            String[] newArr = new String[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setLanguagesSupported(newArr);
            break;
        }
    }

    public String[] getInputSofas() {
        return this.mInputSofas;
    }

    public String[] getOutputSofas() {
        return this.mOutputSofas;
    }

    public void setInputSofas(String[] aInputSofaNames) {
        this.mInputSofas = aInputSofaNames;
    }

    public void setOutputSofas(String[] aOutputSofaNames) {
        this.mOutputSofas = aOutputSofaNames;
    }

    public void addInputSofa(String aSofaName) {
        String[] oldArr = this.getInputSofas();
        String[] newArr = new String[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = aSofaName;
        this.setInputSofas(newArr);
    }

    public void addOutputSofa(String aSofaName) {
        String[] oldArr = this.getOutputSofas();
        String[] newArr = new String[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = aSofaName;
        this.setOutputSofas(newArr);
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

