/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.admin.LinearTypeOrderBuilder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSBagIndex;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexImpl;
import org.apache.uima.cas.impl.FSIntArrayIndex;
import org.apache.uima.cas.impl.FSIteratorAggregate;
import org.apache.uima.cas.impl.FSIteratorWrapper;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FSRBTSetIndex;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LLUnambiguousIteratorImpl;
import org.apache.uima.cas.impl.LinearTypeOrderBuilderImpl;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntSet;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.SortedIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSIndexRepositoryImpl
implements FSIndexRepositoryMgr,
LowLevelIndexRepository {
    public static final int DEFAULT_INDEX_SIZE = 100;
    private CASImpl cas;
    private TypeSystemImpl typeSystem;
    private boolean locked = false;
    private ArrayList<IndexIteratorCachePair>[] indexArray;
    int[] detectIllegalIndexUpdates;
    private HashMap<String, IndexIteratorCachePair> name2indexMap;
    private LinearTypeOrderBuilder defaultOrderBuilder = null;
    private LinearTypeOrder defaultTypeOrder = null;
    private IntVector indexUpdates;
    private BitSet indexUpdateOperation;
    private boolean logProcessed;
    private IntSet fsAddedToIndex;
    private IntSet fsDeletedFromIndex;
    private IntSet fsReindexed;
    private IntVector usedIndexes;
    private boolean[] isUsed;

    IntPointerIterator createPointerIterator(IndexIteratorCachePair iicp) {
        iicp.createIndexIteratorCache();
        if (iicp.iteratorCache.size() > 1) {
            return new PointerIterator(iicp);
        }
        return new LeafPointerIterator(iicp);
    }

    IntPointerIterator createPointerIterator(IndexIteratorCachePair iicp, int fs) {
        iicp.createIndexIteratorCache();
        if (iicp.iteratorCache.size() > 1) {
            return new PointerIterator(iicp, fs);
        }
        return new LeafPointerIterator(iicp, fs);
    }

    private FSIndexRepositoryImpl() {
    }

    FSIndexRepositoryImpl(CASImpl cas) {
        this.cas = cas;
        this.typeSystem = cas.getTypeSystemImpl();
        this.name2indexMap = new HashMap();
        this.indexUpdates = new IntVector();
        this.indexUpdateOperation = new BitSet();
        this.fsAddedToIndex = new IntSet();
        this.fsDeletedFromIndex = new IntSet();
        this.fsReindexed = new IntSet();
        this.logProcessed = false;
        this.init();
    }

    FSIndexRepositoryImpl(CASImpl cas, FSIndexRepositoryImpl baseIndexRepo) {
        this.cas = cas;
        this.typeSystem = cas.getTypeSystemImpl();
        this.name2indexMap = new HashMap();
        this.indexUpdates = new IntVector();
        this.indexUpdateOperation = new BitSet();
        this.fsAddedToIndex = new IntSet();
        this.fsDeletedFromIndex = new IntSet();
        this.fsReindexed = new IntSet();
        this.logProcessed = false;
        this.init();
        Set<String> keys = baseIndexRepo.name2indexMap.keySet();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                IndexIteratorCachePair iicp = baseIndexRepo.name2indexMap.get(key);
                this.createIndexNoQuestionsAsked(iicp.index.getComparator(), key, iicp.index.getIndexingStrategy());
            }
        }
        this.defaultOrderBuilder = baseIndexRepo.defaultOrderBuilder;
        this.defaultTypeOrder = baseIndexRepo.defaultTypeOrder;
    }

    private void init() {
        int i;
        TypeSystemImpl ts = this.typeSystem;
        int numTypes = ts.getNumberOfTypes() + 1;
        this.indexArray = new ArrayList[numTypes];
        for (i = 1; i < numTypes; ++i) {
            this.indexArray[i] = new ArrayList();
        }
        this.detectIllegalIndexUpdates = new int[numTypes];
        for (i = 0; i < this.detectIllegalIndexUpdates.length; ++i) {
            this.detectIllegalIndexUpdates[i] = Integer.MIN_VALUE;
        }
        this.usedIndexes = new IntVector();
        this.isUsed = new boolean[numTypes];
    }

    public void flush() {
        if (!this.locked) {
            return;
        }
        if (this.usedIndexes.size() == 0) {
            return;
        }
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            this.isUsed[this.usedIndexes.get((int)i)] = false;
            ArrayList<IndexIteratorCachePair> v = this.indexArray[this.usedIndexes.get(i)];
            int max = v.size();
            for (int j = 0; j < max; ++j) {
                v.get(j).index.flush();
            }
        }
        this.indexUpdates.removeAllElements();
        this.indexUpdateOperation.clear();
        this.fsAddedToIndex = new IntSet();
        this.fsDeletedFromIndex = new IntSet();
        this.fsReindexed = new IntSet();
        this.logProcessed = false;
        this.usedIndexes.removeAllElements();
    }

    public void addFS(int fsRef) {
        this.ll_addFS(fsRef);
    }

    private IndexIteratorCachePair addNewIndex(FSIndexComparator comparator, int indexType) {
        return this.addNewIndex(comparator, 100, indexType);
    }

    private IndexIteratorCachePair addNewIndex(FSIndexComparator comparator, int initialSize, int indexType) {
        FSLeafIndexImpl ind;
        Type type = comparator.getType();
        int typeCode = ((TypeImpl)type).getCode();
        if (typeCode >= this.indexArray.length) {
            // empty if block
        }
        ArrayList<IndexIteratorCachePair> indexVector = this.indexArray[typeCode];
        switch (indexType) {
            case 1: {
                ind = new FSRBTSetIndex(this.cas, type, indexType);
                break;
            }
            case 2: {
                ind = new FSBagIndex(this.cas, type, initialSize, indexType);
                break;
            }
            case 3: {
                ind = new FSBagIndex(this.cas, type, initialSize, indexType);
                break;
            }
            default: {
                ind = new FSIntArrayIndex(this.cas, type, initialSize, 0);
            }
        }
        ind.init(comparator);
        IndexIteratorCachePair iicp = new IndexIteratorCachePair();
        iicp.index = ind;
        indexVector.add(iicp);
        return iicp;
    }

    private IndexIteratorCachePair addNewIndexRecursive(FSIndexComparator comparator, int indexType) {
        FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)comparator).copy();
        return this.addNewIndexRec(compCopy, indexType);
    }

    private static final int findIndex(ArrayList<IndexIteratorCachePair> indexes, FSIndexComparator comp) {
        int max = indexes.size();
        for (int i = 0; i < max; ++i) {
            FSIndexComparator indexComp = indexes.get(i).index.getComparator();
            if (!((Object)comp).equals(indexComp)) continue;
            return i;
        }
        return -1;
    }

    private IndexIteratorCachePair addNewIndexRec(FSIndexComparator comparator, int indexType) {
        IndexIteratorCachePair iicp = this.addNewIndex(comparator, indexType);
        if (indexType == 3) {
            return iicp;
        }
        Type superType = comparator.getType();
        Vector<Type> types = this.typeSystem.getDirectlySubsumedTypes(superType);
        int max = types.size();
        for (int i = 0; i < max; ++i) {
            FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)comparator).copy();
            compCopy.setType(types.get(i));
            this.addNewIndexRec(compCopy, indexType);
        }
        return iicp;
    }

    private static final ArrayList<Type> getAllSubsumedTypes(Type t, TypeSystem ts) {
        ArrayList<Type> v = new ArrayList<Type>();
        FSIndexRepositoryImpl.addAllSubsumedTypes(t, ts, v);
        return v;
    }

    private static final void addAllSubsumedTypes(Type t, TypeSystem ts, ArrayList<Type> v) {
        v.add(t);
        List<Type> sub = ts.getDirectSubtypes(t);
        int len = sub.size();
        for (int i = 0; i < len; ++i) {
            FSIndexRepositoryImpl.addAllSubsumedTypes(sub.get(i), ts, v);
        }
    }

    @Override
    public void commit() {
        this.getDefaultTypeOrder();
        this.locked = true;
    }

    @Override
    public LinearTypeOrder getDefaultTypeOrder() {
        if (this.defaultTypeOrder == null) {
            if (this.defaultOrderBuilder == null) {
                this.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
            }
            try {
                this.defaultTypeOrder = this.defaultOrderBuilder.getOrder();
            }
            catch (CASException cASException) {
                // empty catch block
            }
        }
        return this.defaultTypeOrder;
    }

    @Override
    public LinearTypeOrderBuilder getDefaultOrderBuilder() {
        if (this.defaultOrderBuilder == null) {
            this.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
        }
        return this.defaultOrderBuilder;
    }

    void setDefaultTypeOrder(LinearTypeOrder order) {
        this.defaultTypeOrder = order;
    }

    @Override
    public boolean createIndex(FSIndexComparator comp, String label, int indexType) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException(0);
        }
        return this.createIndexNoQuestionsAsked(comp, label, indexType);
    }

    public boolean createIndexNoQuestionsAsked(FSIndexComparator comp, String label, int indexType) {
        IndexIteratorCachePair cp = this.name2indexMap.get(label);
        if (cp == null) {
            cp = this.addNewIndexRecursive(comp, indexType);
            this.name2indexMap.put(label, cp);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<FSIndex<FeatureStructure>> getIndexes() {
        ArrayList<FSIndex<FeatureStructure>> indexList = new ArrayList<FSIndex<FeatureStructure>>();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            indexList.add(this.getIndex(label));
        }
        return indexList.iterator();
    }

    @Override
    public Iterator<String> getLabels() {
        return this.name2indexMap.keySet().iterator();
    }

    public Iterator<String> getLabels(FSIndexComparator comp) {
        ArrayList<String> labels = new ArrayList<String>();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            if (!((Object)this.name2indexMap.get(label).index.getComparator()).equals(comp)) continue;
            labels.add(label);
        }
        return labels.iterator();
    }

    @Override
    public FSIndex<FeatureStructure> getIndex(String label, Type type) {
        Type componentType;
        IndexIteratorCachePair iicp = this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        if (type.isArray() && (componentType = type.getComponentType()) != null && !componentType.isPrimitive() && !componentType.getName().equals("uima.cas.TOP")) {
            return null;
        }
        Type indexType = iicp.index.getType();
        if (!this.typeSystem.subsumes(indexType, type)) {
            CASRuntimeException cre = new CASRuntimeException("TYPE_NOT_IN_INDEX", new String[]{label, type.getName(), indexType.getName()});
            throw cre;
        }
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList<IndexIteratorCachePair> inds = this.indexArray[typeCode];
        int indexCode = FSIndexRepositoryImpl.findIndex(inds, iicp.index.getComparator());
        if (indexCode < 0) {
            return null;
        }
        return new IndexImpl<FeatureStructure>(inds.get(indexCode));
    }

    @Override
    public FSIndex<FeatureStructure> getIndex(String label) {
        IndexIteratorCachePair iicp = this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        return new IndexImpl<FeatureStructure>(iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String label) {
        IndexImpl index = (IndexImpl)this.getIndex(label);
        if (index == null) {
            return null;
        }
        return this.createPointerIterator(index.iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String label, Type type) {
        IndexImpl index = (IndexImpl)this.getIndex(label, type);
        if (index == null) {
            return null;
        }
        return this.createPointerIterator(index.iicp);
    }

    public int getIndexSize(Type type) {
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList<IndexIteratorCachePair> indexVector = this.indexArray[typeCode];
        if (indexVector.size() == 0) {
            return 0;
        }
        int numFSs = indexVector.get(0).index.size();
        Vector<Type> typeVector = this.typeSystem.getDirectlySubsumedTypes(type);
        int max = typeVector.size();
        for (int i = 0; i < max; ++i) {
            numFSs += this.getIndexSize(typeVector.get(i));
        }
        return numFSs;
    }

    @Override
    public FSIndexComparator createComparator() {
        return new FSIndexComparatorImpl(this.cas);
    }

    @Override
    public boolean isCommitted() {
        return this.locked;
    }

    @Override
    public boolean createIndex(FSIndexComparator comp, String label) throws CASAdminException {
        return this.createIndex(comp, label, 0);
    }

    public int[] getIndexedFSs() {
        IntVector v = new IntVector();
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            int k;
            ArrayList<IndexIteratorCachePair> iv = this.indexArray[this.usedIndexes.get(i)];
            int jMax = iv.size();
            ArrayList<IndexIteratorCachePair> cv = new ArrayList<IndexIteratorCachePair>();
            for (int j = 0; j < jMax; ++j) {
                IndexIteratorCachePair iicp = iv.get(j);
                int indStrat = iicp.index.getIndexingStrategy();
                if (indStrat != 1) {
                    if (cv.size() > 0) {
                        cv = new ArrayList();
                    }
                    cv.add(iicp);
                    break;
                }
                cv.add(iicp);
            }
            if (cv.size() <= 0) continue;
            SortedIntSet set = new SortedIntSet();
            for (k = 0; k < cv.size(); ++k) {
                IntPointerIterator it = ((IndexIteratorCachePair)cv.get(k)).index.refIterator();
                while (it.isValid()) {
                    set.add(it.get());
                    it.inc();
                }
            }
            for (k = 0; k < set.size(); ++k) {
                v.add(set.get(k));
            }
        }
        return v.toArray();
    }

    @Override
    public void addFS(FeatureStructure fs) {
        this.addFS(((FeatureStructureImpl)fs).getAddress());
    }

    private void incrementIllegalIndexUpdateDetector(int typeCode) {
        int n = typeCode;
        this.detectIllegalIndexUpdates[n] = this.detectIllegalIndexUpdates[n] + 1;
    }

    @Override
    public void removeFS(FeatureStructure fs) {
        this.ll_removeFS(this.cas.ll_getFSRef(fs));
    }

    public void removeFS(int fsRef) {
        this.ll_removeFS(fsRef);
    }

    @Override
    public LinearTypeOrderBuilder createTypeSortOrder() {
        LinearTypeOrderBuilderImpl orderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
        if (this.defaultOrderBuilder == null) {
            this.defaultOrderBuilder = orderBuilder;
        }
        return orderBuilder;
    }

    @Override
    public LowLevelIndex ll_getIndex(String indexName) {
        return (LowLevelIndex)((Object)this.getIndex(indexName));
    }

    @Override
    public LowLevelIndex ll_getIndex(String indexName, int typeCode) {
        if (!this.typeSystem.isType(typeCode) || !this.cas.ll_isRefType(typeCode)) {
            LowLevelException e = new LowLevelException(10);
            e.addArgument(Integer.toString(typeCode));
            throw e;
        }
        return (LowLevelIndex)((Object)this.getIndex(indexName, this.typeSystem.ll_getTypeForCode(typeCode)));
    }

    @Override
    public final void ll_addFS(int fsRef, boolean doChecks) {
        if (doChecks) {
            this.cas.checkFsRef(fsRef);
            this.cas.ll_isRefType(this.cas.ll_getFSRefType(fsRef));
        }
        this.ll_addFS(fsRef);
    }

    @Override
    public void ll_addFS(int fsRef) {
        int typeCode = this.cas.getHeapValue(fsRef);
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList<IndexIteratorCachePair> indexes = this.indexArray[typeCode];
        int size = indexes.size();
        for (int i = 0; i < size; ++i) {
            indexes.get(i).index.insert(fsRef);
        }
        if (size == 0) {
            Type type = this.typeSystem.ll_getTypeForCode(typeCode);
            String defIndexName = FSIndexRepositoryImpl.getAutoIndexNameForType(type);
            FSIndexComparator comparator = this.createComparator();
            comparator.setType(type);
            this.createIndexNoQuestionsAsked(comparator, defIndexName, 3);
            assert (this.indexArray[typeCode].size() == 1);
            this.indexArray[typeCode].get(0).index.insert(fsRef);
        }
        if (this.cas.getCurrentMark() != null) {
            this.logIndexOperation(fsRef, true);
        }
        if (!this.isUsed[typeCode]) {
            this.isUsed[typeCode] = true;
            this.usedIndexes.add(typeCode);
        }
    }

    private static final String getAutoIndexNameForType(Type type) {
        return "_" + type.getName() + "_GeneratedIndex";
    }

    @Override
    public void ll_removeFS(int fsRef) {
        int typeCode = this.cas.ll_getFSRefType(fsRef);
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList<IndexIteratorCachePair> idxList = this.indexArray[typeCode];
        int max = idxList.size();
        for (int i = 0; i < max; ++i) {
            idxList.get(i).index.remove(fsRef);
        }
        if (this.cas.getCurrentMark() != null) {
            this.logIndexOperation(fsRef, false);
        }
    }

    @Override
    public FSIterator<FeatureStructure> getAllIndexedFS(Type type) {
        ArrayList iteratorList = new ArrayList();
        this.getAllIndexedFS(type, iteratorList);
        return new FSIteratorAggregate<FeatureStructure>(iteratorList);
    }

    private final void getAllIndexedFS(Type type, List<FSIterator<FeatureStructure>> iteratorList) {
        FSIndex<FeatureStructure> autoIndex = this.getIndex(FSIndexRepositoryImpl.getAutoIndexNameForType(type));
        if (autoIndex != null) {
            iteratorList.add(autoIndex.iterator());
            List<Type> subtypes = this.typeSystem.getDirectSubtypes(type);
            for (int i = 0; i < subtypes.size(); ++i) {
                this.getAllIndexedFS(subtypes.get(i), iteratorList);
            }
            return;
        }
        FSIndex<FeatureStructure> setIndex = null;
        Iterator<String> iter = this.getLabels();
        while (iter.hasNext()) {
            String label = iter.next();
            FSIndex<FeatureStructure> index = this.getIndex(label);
            if (index.getIndexingStrategy() == 3 || !this.typeSystem.subsumes(index.getType(), type)) continue;
            if (index.getIndexingStrategy() != 1) {
                iteratorList.add(this.getIndex(label, type).iterator());
                return;
            }
            setIndex = this.getIndex(label, type);
        }
        if (setIndex != null) {
            iteratorList.add(setIndex.iterator());
            return;
        }
        List<Type> subtypes = this.typeSystem.getDirectSubtypes(type);
        for (int i = 0; i < subtypes.size(); ++i) {
            this.getAllIndexedFS(subtypes.get(i), iteratorList);
        }
    }

    private void logIndexOperation(int fsRef, boolean added) {
        this.indexUpdates.add(fsRef);
        if (added) {
            this.indexUpdateOperation.set(this.indexUpdates.size() - 1, added);
        }
        this.logProcessed = false;
    }

    private void processIndexUpdates() {
        for (int i = 0; i < this.indexUpdates.size(); ++i) {
            int fsRef = this.indexUpdates.get(i);
            boolean added = this.indexUpdateOperation.get(i);
            if (added) {
                if (this.fsDeletedFromIndex.contains(fsRef)) {
                    this.fsDeletedFromIndex.remove(this.fsDeletedFromIndex.indexOf(fsRef));
                    this.fsReindexed.add(fsRef);
                    continue;
                }
                this.fsAddedToIndex.add(fsRef);
                continue;
            }
            if (this.fsAddedToIndex.contains(fsRef)) {
                this.fsAddedToIndex.remove(this.fsAddedToIndex.indexOf(fsRef));
                continue;
            }
            if (this.fsReindexed.contains(fsRef)) {
                this.fsReindexed.remove(fsRef);
                continue;
            }
            this.fsDeletedFromIndex.add(fsRef);
        }
        this.logProcessed = true;
    }

    public int[] getAddedFSs() {
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        int[] fslist = new int[this.fsAddedToIndex.size()];
        for (int i = 0; i < fslist.length; ++i) {
            fslist[i] = this.fsAddedToIndex.get(i);
        }
        return fslist;
    }

    public int[] getDeletedFSs() {
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        int[] fslist = new int[this.fsDeletedFromIndex.size()];
        for (int i = 0; i < fslist.length; ++i) {
            fslist[i] = this.fsDeletedFromIndex.get(i);
        }
        return fslist;
    }

    public int[] getReindexedFSs() {
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        int[] fslist = new int[this.fsReindexed.size()];
        for (int i = 0; i < fslist.length; ++i) {
            fslist[i] = this.fsReindexed.get(i);
        }
        return fslist;
    }

    public boolean isModified() {
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        return this.fsAddedToIndex.size() > 0 || this.fsDeletedFromIndex.size() > 0 || this.fsReindexed.size() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexImpl<T extends FeatureStructure>
    implements FSIndex<T>,
    FSIndexImpl {
        private final IndexIteratorCachePair iicp;

        private IndexImpl(IndexIteratorCachePair iicp) {
            this.iicp = iicp;
        }

        @Override
        public int ll_compare(int ref1, int ref2) {
            return this.iicp.index.ll_compare(ref1, ref2);
        }

        @Override
        public int getIndexingStrategy() {
            return this.iicp.index.getIndexingStrategy();
        }

        @Override
        public FSIndexComparator getComparator() {
            return this.iicp.index.getComparator();
        }

        protected IntComparator getIntComparator() {
            return this.iicp.index.getIntComparator();
        }

        @Override
        public void flush() {
            this.iicp.index.flush();
        }

        @Override
        public int compare(FeatureStructure fs1, FeatureStructure fs2) {
            return this.iicp.index.compare(fs1, fs2);
        }

        @Override
        public boolean contains(FeatureStructure fs) {
            return this.iicp.index.contains(fs);
        }

        @Override
        public FeatureStructure find(FeatureStructure fs) {
            return this.iicp.index.find(fs);
        }

        @Override
        public Type getType() {
            return this.iicp.index.getType();
        }

        @Override
        public FSIterator<T> iterator() {
            return new FSIteratorWrapper(FSIndexRepositoryImpl.this.createPointerIterator(this.iicp), FSIndexRepositoryImpl.this.cas);
        }

        @Override
        public FSIterator<T> iterator(FeatureStructure fs) {
            return new FSIteratorWrapper(FSIndexRepositoryImpl.this.createPointerIterator(this.iicp, ((FeatureStructureImpl)fs).getAddress()), FSIndexRepositoryImpl.this.cas);
        }

        @Override
        public IntPointerIterator getIntIterator() {
            return FSIndexRepositoryImpl.this.createPointerIterator(this.iicp);
        }

        @Override
        public int size() {
            this.iicp.createIndexIteratorCache();
            int size = 0;
            ArrayList subIndex = this.iicp.iteratorCache;
            int max = subIndex.size();
            for (int i = 0; i < max; ++i) {
                size += ((FSLeafIndexImpl)subIndex.get(i)).size();
            }
            return size;
        }

        @Override
        public LowLevelIterator ll_iterator() {
            return (LowLevelIterator)((Object)FSIndexRepositoryImpl.this.createPointerIterator(this.iicp));
        }

        @Override
        public LowLevelIterator ll_rootIterator() {
            this.iicp.createIndexIteratorCache();
            return new LeafPointerIterator(this.iicp);
        }

        @Override
        public LowLevelIterator ll_iterator(boolean ambiguous) {
            if (ambiguous) {
                return this.ll_iterator();
            }
            return new LLUnambiguousIteratorImpl(this.ll_iterator(), ((IndexIteratorCachePair)this.iicp).index.lowLevelCAS);
        }
    }

    private class LeafPointerIterator
    implements IntPointerIterator,
    LowLevelIterator {
        private IndexIteratorCachePair iicp;
        private ComparableIntPointerIterator index;

        private LeafPointerIterator() {
        }

        private void initPointerIterator(IndexIteratorCachePair iicp0) {
            this.iicp = iicp0;
            ArrayList iteratorCache = iicp0.iteratorCache;
            FSLeafIndexImpl leafIndex = (FSLeafIndexImpl)iteratorCache.get(0);
            this.index = leafIndex.pointerIterator(leafIndex, FSIndexRepositoryImpl.this.detectIllegalIndexUpdates, ((TypeImpl)leafIndex.getType()).getCode());
        }

        private LeafPointerIterator(IndexIteratorCachePair iicp) {
            this.initPointerIterator(iicp);
            this.moveToFirst();
        }

        private LeafPointerIterator(IndexIteratorCachePair iicp, int fs) {
            this.initPointerIterator(iicp);
            this.moveTo(fs);
        }

        private ComparableIntPointerIterator checkConcurrentModification() {
            if (this.index.isConcurrentModification()) {
                throw new ConcurrentModificationException();
            }
            return this.index;
        }

        public boolean isValid() {
            return this.index.isValid();
        }

        public void moveToLast() {
            this.index.resetConcurrentModification();
            this.index.moveToLast();
        }

        public void moveToFirst() {
            this.index.resetConcurrentModification();
            this.index.moveToFirst();
        }

        public void moveToNext() {
            this.checkConcurrentModification().inc();
        }

        public void moveToPrevious() {
            this.checkConcurrentModification().dec();
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.checkConcurrentModification().get();
        }

        public Object copy() {
            if (this.isValid()) {
                return new LeafPointerIterator(this.iicp, this.get());
            }
            LeafPointerIterator pi = new LeafPointerIterator(this.iicp);
            pi.moveToFirst();
            pi.moveToPrevious();
            return pi;
        }

        public void moveTo(int fs) {
            this.index.resetConcurrentModification();
            this.index.moveTo(fs);
        }

        public void inc() {
            this.checkConcurrentModification().inc();
        }

        public void dec() {
            this.checkConcurrentModification().dec();
        }

        public int ll_indexSize() {
            return this.iicp.size();
        }

        public LowLevelIndex ll_getIndex() {
            return this.iicp.index;
        }
    }

    private class PointerIterator
    implements IntPointerIterator,
    LowLevelIterator {
        static final int SORTED_SECTION = 3;
        private IndexIteratorCachePair iicp;
        private ComparableIntPointerIterator[] indexes;
        int lastValidIndex;
        private boolean wentForward;
        private IntComparator iteratorComparator;

        private PointerIterator() {
        }

        private void initPointerIterator(IndexIteratorCachePair iicp0) {
            this.iicp = iicp0;
            ArrayList iteratorCache = iicp0.iteratorCache;
            this.indexes = new ComparableIntPointerIterator[iteratorCache.size()];
            this.iteratorComparator = (IntComparator)iteratorCache.get(0);
            for (int i = 0; i < this.indexes.length; ++i) {
                ComparableIntPointerIterator it;
                FSLeafIndexImpl leafIndex = (FSLeafIndexImpl)iteratorCache.get(i);
                this.indexes[i] = it = leafIndex.pointerIterator(this.iteratorComparator, FSIndexRepositoryImpl.this.detectIllegalIndexUpdates, ((TypeImpl)leafIndex.getType()).getCode());
            }
        }

        private PointerIterator(IndexIteratorCachePair iicp) {
            this.initPointerIterator(iicp);
            this.moveToFirst();
        }

        private PointerIterator(IndexIteratorCachePair iicp, int fs) {
            this.initPointerIterator(iicp);
            this.moveTo(fs);
        }

        public boolean isValid() {
            return this.lastValidIndex >= 0;
        }

        private ComparableIntPointerIterator checkConcurrentModification(int i) {
            ComparableIntPointerIterator cipi = this.indexes[i];
            if (cipi.isConcurrentModification()) {
                throw new ConcurrentModificationException();
            }
            return cipi;
        }

        private boolean is_before(ComparableIntPointerIterator l, ComparableIntPointerIterator r, int dir) {
            int ir;
            int il = l.get();
            int d = this.iteratorComparator.compare(il, ir = r.get());
            if (d == 0) {
                d = il - ir;
            }
            return d * dir < 0;
        }

        private void heapify_up(ComparableIntPointerIterator it, int idx, int dir) {
            int nidx;
            while (idx > 3) {
                nidx = idx + 3 - 1 >> 1;
                if (!this.is_before(it, this.indexes[nidx], dir)) {
                    this.indexes[idx] = it;
                    return;
                }
                this.indexes[idx] = this.indexes[nidx];
                idx = nidx;
            }
            while (idx > 0) {
                nidx = idx - 1;
                if (!this.is_before(it, this.indexes[nidx], dir)) {
                    this.indexes[idx] = it;
                    return;
                }
                this.indexes[idx] = this.indexes[nidx];
                idx = nidx;
            }
            this.indexes[idx] = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void heapify_down(ComparableIntPointerIterator it, int dir) {
            int num;
            if (!it.isValid()) {
                ComparableIntPointerIterator itl = this.checkConcurrentModification(this.lastValidIndex);
                this.indexes[this.lastValidIndex] = it;
                this.indexes[0] = itl;
                --this.lastValidIndex;
                it = itl;
            }
            if ((num = this.lastValidIndex) < 1 || !this.is_before(this.checkConcurrentModification(1), it, dir)) {
                return;
            }
            int idx = 1;
            this.indexes[0] = this.indexes[1];
            int end = Math.min(num, 3);
            int nidx = idx + 1;
            try {
                while (nidx <= end) {
                    if (!this.is_before(this.checkConcurrentModification(nidx), it, dir)) {
                        return;
                    }
                    this.indexes[idx] = this.indexes[nidx];
                    idx = nidx;
                    nidx = idx + 1;
                }
                nidx = 4;
                while (nidx <= num) {
                    if (nidx < num && this.is_before(this.checkConcurrentModification(nidx + 1), this.checkConcurrentModification(nidx), dir)) {
                        ++nidx;
                    }
                    if (!this.is_before(this.indexes[nidx], it, dir)) {
                        return;
                    }
                    this.indexes[idx] = this.indexes[nidx];
                    idx = nidx;
                    nidx = (nidx << 1) - 2;
                }
            }
            finally {
                this.indexes[idx] = it;
            }
        }

        public void moveToFirst() {
            int lvi = this.indexes.length - 1;
            int i = 0;
            while (i <= lvi) {
                ComparableIntPointerIterator it = this.indexes[i];
                it.resetConcurrentModification();
                it.moveToFirst();
                if (it.isValid()) {
                    this.heapify_up(it, i, 1);
                    ++i;
                    continue;
                }
                this.indexes[i] = this.indexes[lvi];
                this.indexes[lvi] = it;
                --lvi;
            }
            this.wentForward = true;
            this.lastValidIndex = lvi;
        }

        public void moveToLast() {
            int lvi = this.indexes.length - 1;
            int i = 0;
            while (i <= lvi) {
                ComparableIntPointerIterator it = this.indexes[i];
                it.resetConcurrentModification();
                it.moveToLast();
                if (it.isValid()) {
                    this.heapify_up(it, i, -1);
                    ++i;
                    continue;
                }
                this.indexes[i] = this.indexes[lvi];
                this.indexes[lvi] = it;
                --lvi;
            }
            this.wentForward = false;
            this.lastValidIndex = lvi;
        }

        public void moveToNext() {
            if (!this.isValid()) {
                return;
            }
            ComparableIntPointerIterator it0 = this.checkConcurrentModification(0);
            if (this.wentForward) {
                it0.inc();
                this.heapify_down(it0, 1);
            } else {
                int lvi = this.indexes.length - 1;
                int i = 1;
                while (i <= lvi) {
                    ComparableIntPointerIterator it = this.checkConcurrentModification(i);
                    if (!it.isValid()) {
                        it.moveToFirst();
                    }
                    while (it.isValid() && this.is_before(it, it0, 1)) {
                        it.inc();
                    }
                    if (it.isValid()) {
                        this.heapify_up(it, i, 1);
                        ++i;
                        continue;
                    }
                    this.indexes[i] = this.indexes[lvi];
                    this.indexes[lvi] = it;
                    --lvi;
                }
                this.lastValidIndex = lvi;
                this.wentForward = true;
                it0.inc();
                this.heapify_down(it0, 1);
            }
        }

        public void moveToPrevious() {
            if (!this.isValid()) {
                return;
            }
            ComparableIntPointerIterator it0 = this.checkConcurrentModification(0);
            if (!this.wentForward) {
                it0.dec();
                this.heapify_down(it0, -1);
            } else {
                int lvi = this.indexes.length - 1;
                int i = 1;
                while (i <= lvi) {
                    ComparableIntPointerIterator it = this.checkConcurrentModification(i);
                    if (!it.isValid()) {
                        it.moveToLast();
                    }
                    while (it.isValid() && this.is_before(it, it0, -1)) {
                        it.dec();
                    }
                    if (it.isValid()) {
                        this.heapify_up(it, i, -1);
                        ++i;
                        continue;
                    }
                    this.indexes[i] = this.indexes[lvi];
                    this.indexes[lvi] = it;
                    --lvi;
                }
                this.lastValidIndex = lvi;
                this.wentForward = false;
                it0.dec();
                this.heapify_down(it0, -1);
            }
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.checkConcurrentModification(0).get();
        }

        public Object copy() {
            if (this.isValid()) {
                return new PointerIterator(this.iicp, this.get());
            }
            PointerIterator pi = new PointerIterator(this.iicp);
            pi.moveToFirst();
            pi.moveToPrevious();
            return pi;
        }

        public void moveTo(int fs) {
            block4: {
                block3: {
                    int prev;
                    int lvi = this.indexes.length - 1;
                    int i = 0;
                    while (i <= lvi) {
                        ComparableIntPointerIterator it = this.indexes[i];
                        it.resetConcurrentModification();
                        it.moveTo(fs);
                        if (it.isValid()) {
                            this.heapify_up(it, i, 1);
                            ++i;
                            continue;
                        }
                        this.indexes[i] = this.indexes[lvi];
                        this.indexes[lvi] = it;
                        --lvi;
                    }
                    this.wentForward = true;
                    this.lastValidIndex = lvi;
                    do {
                        this.moveToPrevious();
                        if (!this.isValid()) break block3;
                        prev = this.get();
                    } while (this.iicp.index.compare(prev, fs) == 0);
                    this.moveToNext();
                    break block4;
                }
                this.moveToFirst();
            }
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return this.iicp.size();
        }

        public LowLevelIndex ll_getIndex() {
            return this.iicp.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexIteratorCachePair
    implements Comparable<IndexIteratorCachePair> {
        private FSLeafIndexImpl index = null;
        private ArrayList<FSLeafIndexImpl> iteratorCache = null;

        private IndexIteratorCachePair() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndexIteratorCachePair)) {
                return false;
            }
            IndexIteratorCachePair iicp = (IndexIteratorCachePair)o;
            return ((Object)this.index.getComparator()).equals(iicp.index.getComparator()) && this.index.getIndexingStrategy() == iicp.index.getIndexingStrategy();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private void createIndexIteratorCache() {
            if (this.iteratorCache != null) {
                return;
            }
            this.iteratorCache = new ArrayList();
            Type rootType = this.index.getComparator().getType();
            ArrayList allTypes = null;
            if (this.index.getIndexingStrategy() == 3) {
                allTypes = new ArrayList();
                allTypes.add(rootType);
            } else {
                allTypes = FSIndexRepositoryImpl.getAllSubsumedTypes(rootType, FSIndexRepositoryImpl.this.typeSystem);
            }
            int len = allTypes.size();
            for (int i = 0; i < len; ++i) {
                int typeCode = ((TypeImpl)allTypes.get(i)).getCode();
                ArrayList indexList = FSIndexRepositoryImpl.this.indexArray[typeCode];
                int indexPos = indexList.indexOf(this);
                if (indexPos < 0) continue;
                this.iteratorCache.add(((IndexIteratorCachePair)indexList.get((int)indexPos)).index);
            }
        }

        @Override
        public int compareTo(IndexIteratorCachePair o) {
            int typeCode2;
            IndexIteratorCachePair cp = o;
            int typeCode1 = ((TypeImpl)this.index.getType()).getCode();
            if (typeCode1 < (typeCode2 = ((TypeImpl)cp.index.getType()).getCode())) {
                return -1;
            }
            if (typeCode1 > typeCode2) {
                return 1;
            }
            return this.index.getComparator().compareTo(cp.index.getComparator());
        }

        int size() {
            int size = 0;
            for (int i = 0; i < this.iteratorCache.size(); ++i) {
                size += this.iteratorCache.get(i).size();
            }
            return size;
        }
    }
}

