/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSConstraint;
import org.apache.uima.cas.FSIntConstraint;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.AbstractAnnotationDocumentListener;
import org.apache.uima.caseditor.editor.AnnotationDocument;
import org.apache.uima.caseditor.editor.AnnotationEditorSelection;
import org.apache.uima.caseditor.editor.AnnotationInformationProvider;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.AnnotationStyleChangeListener;
import org.apache.uima.caseditor.editor.CasDocumentProvider;
import org.apache.uima.caseditor.editor.CasDocumentProviderFactory;
import org.apache.uima.caseditor.editor.ChangeModeAction;
import org.apache.uima.caseditor.editor.DocumentUimaImpl;
import org.apache.uima.caseditor.editor.FeatureStructureSelectionProvider;
import org.apache.uima.caseditor.editor.FindAnnotateAction;
import org.apache.uima.caseditor.editor.IAnnotationEditorModifyListener;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.apache.uima.caseditor.editor.ICasEditorInputListener;
import org.apache.uima.caseditor.editor.ModelFeatureStructure;
import org.apache.uima.caseditor.editor.QuickTypeSelectionDialog;
import org.apache.uima.caseditor.editor.TextDocumentProvider;
import org.apache.uima.caseditor.editor.action.DeleteFeatureStructureAction;
import org.apache.uima.caseditor.editor.action.LowerLeftAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.LowerRightAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.WideLeftAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.WideRightAnnotationSideAction;
import org.apache.uima.caseditor.editor.annotation.DrawingStyle;
import org.apache.uima.caseditor.editor.annotation.EclipseAnnotationPeer;
import org.apache.uima.caseditor.editor.context.AnnotationEditingControlCreator;
import org.apache.uima.caseditor.editor.contextmenu.IModeMenuListener;
import org.apache.uima.caseditor.editor.contextmenu.IShowAnnotationsListener;
import org.apache.uima.caseditor.editor.contextmenu.ModeMenu;
import org.apache.uima.caseditor.editor.contextmenu.ShowAnnotationsMenu;
import org.apache.uima.caseditor.editor.outline.AnnotationOutline;
import org.apache.uima.caseditor.editor.outline.OutlinePageBook;
import org.apache.uima.caseditor.editor.util.AnnotationComparator;
import org.apache.uima.caseditor.editor.util.AnnotationSelection;
import org.apache.uima.caseditor.editor.util.FeatureStructureTransfer;
import org.apache.uima.caseditor.editor.util.Span;
import org.apache.uima.caseditor.editor.util.StrictTypeConstraint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class AnnotationEditor
extends StatusTextEditor
implements ICasEditor,
ISelectionListener {
    private Type mAnnotationMode;
    private OutlinePageBook mOutlinePage = new OutlinePageBook();
    private Set<IAnnotationEditorModifyListener> mEditorListener = new HashSet<IAnnotationEditorModifyListener>();
    private ListenerList mEditorInputListener = new ListenerList();
    private int mCursorPosition;
    boolean mIsSomethingHighlighted = false;
    private StyleRange mCurrentStyleRange;
    private FeatureStructureSelectionProvider mFeatureStructureSelectionProvider;
    private AnnotationPainter mPainter;
    private ShowAnnotationsMenu mShowAnnotationsMenu;
    private DocumentListener mAnnotationSynchronizer;
    private AnnotationStyleChangeListener mAnnotationStyleListener;
    private Collection<Type> shownAnnotationTypes = new HashSet<Type>();
    private IPropertyChangeListener preferenceStoreChangeListener;
    private CasDocumentProvider casDocumentProvider;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.casDocumentProvider = CasDocumentProviderFactory.instance().getDocumentProvider(input);
        this.setDocumentProvider((IDocumentProvider)new TextDocumentProvider(this.casDocumentProvider));
        super.init(site, input);
    }

    @Override
    public CasDocumentProvider getCasDocumentProvider() {
        return this.casDocumentProvider;
    }

    public String getTitleToolTip() {
        if (this.getEditorInput() == null) {
            return super.getTitleToolTip();
        }
        ICasDocument document = this.getDocument();
        if (document == null) {
            return super.getTitleToolTip();
        }
        String typeSystemText = document.getTypeSystemText();
        String toolTipText = this.getEditorInput().getToolTipText();
        if (typeSystemText != null) {
            return toolTipText + " (" + typeSystemText + ")";
        }
        return toolTipText;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter) && this.getDocument() != null) {
            return this.mOutlinePage;
        }
        if (CAS.class.equals((Object)adapter) && this.getDocument() != null) {
            return this.getDocument().getCAS();
        }
        return super.getAdapter(adapter);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        SourceViewer sourceViewer = new SourceViewer(parent, ruler, styles);
        sourceViewer.setEditable(false);
        this.mPainter = new AnnotationPainter((ISourceViewer)sourceViewer, (IAnnotationAccess)new AnnotationAccess());
        sourceViewer.addPainter((IPainter)this.mPainter);
        return sourceViewer;
    }

    private void setTextSize(int newSize) {
        Font font = this.getSourceViewer().getTextWidget().getFont();
        if (font.getFontData().length > 0) {
            FontData fd = font.getFontData()[0];
            this.getSourceViewer().getTextWidget().setFont(new Font(font.getDevice(), fd.getName(), newSize, fd.getStyle()));
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.showChangeInformation(false);
        this.getSourceViewer().getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int newCaretOffset = AnnotationEditor.this.getSourceViewer().getTextWidget().getCaretOffset();
                if (newCaretOffset != AnnotationEditor.this.mCursorPosition) {
                    AnnotationEditor.this.mCursorPosition = newCaretOffset;
                    AnnotationEditor.this.refreshSelection();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.getSourceViewer().getTextWidget().addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                int newCaretOffset = AnnotationEditor.this.getSourceViewer().getTextWidget().getCaretOffset();
                if (newCaretOffset != AnnotationEditor.this.mCursorPosition) {
                    AnnotationEditor.this.mCursorPosition = newCaretOffset;
                    AnnotationEditor.this.refreshSelection();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                int newCaretOffset = AnnotationEditor.this.getSourceViewer().getTextWidget().getCaretOffset();
                if (newCaretOffset != AnnotationEditor.this.mCursorPosition) {
                    AnnotationEditor.this.mCursorPosition = newCaretOffset;
                    AnnotationEditor.this.refreshSelection();
                }
            }
        });
        this.getSourceViewer().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AnnotationEditor.this.mFeatureStructureSelectionProvider.setSelection((ISelection)new AnnotationEditorSelection((ITextSelection)event.getSelection(), (IStructuredSelection)new StructuredSelection(ModelFeatureStructure.create(AnnotationEditor.this.getDocument(), AnnotationEditor.this.getSelectedAnnotations()))));
            }
        });
        DragSource dragSource = new DragSource((Control)this.getSourceViewer().getTextWidget(), 1);
        Transfer[] types = new Transfer[]{FeatureStructureTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)new FeatureStructureDragListener(this.getSourceViewer().getTextWidget()));
        this.getSourceViewer().getTextWidget().setEditable(false);
        this.getSourceViewer().setEditable(false);
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFeatureStructureSelectionProvider);
        IPreferenceStore prefStore = CasEditorPlugin.getDefault().getPreferenceStore();
        int textSize = prefStore.getInt("org.apache.uima.caseditor.editor-text-size");
        if (textSize > 0) {
            this.setTextSize(textSize);
        }
        this.preferenceStoreChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Integer textSize;
                if ("org.apache.uima.caseditor.editor-text-size".equals(event.getProperty()) && (textSize = (Integer)event.getNewValue()) != null && textSize > 0) {
                    AnnotationEditor.this.setTextSize(textSize);
                }
            }
        };
        prefStore.addPropertyChangeListener(this.preferenceStoreChangeListener);
        this.initiallySynchronizeUI();
    }

    private void refreshSelection() {
        this.mFeatureStructureSelectionProvider.setSelection(this.getDocument(), this.getSelectedAnnotations());
    }

    public boolean isEditable() {
        return false;
    }

    protected void handleElementContentReplaced() {
        super.handleElementContentReplaced();
        this.setInput(this.getEditorInput());
    }

    protected void doSetInput(final IEditorInput input) throws CoreException {
        final IEditorInput oldInput = this.getEditorInput();
        final ICasDocument oldDocument = this.getDocument();
        if (oldDocument != null) {
            oldDocument.removeChangeListener(this.mAnnotationSynchronizer);
            this.mAnnotationSynchronizer = null;
            this.getCasDocumentProvider().getTypeSystemPreferenceStore(this.getEditorInput()).removePropertyChangeListener((IPropertyChangeListener)this.mAnnotationStyleListener);
            this.mAnnotationStyleListener = null;
        }
        super.doSetInput(input);
        if (CasEditorPlugin.getDefault().getAndClearShowMigrationDialogFlag()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)AnnotationEditor.this.getSite().getShell(), (String)"Cas Editor Project Removed", (String)"The Cas Editor Project support was removed from this release and your existing Cas Editor Projects have been migrated. If you still want to use the Cas Editor Project support please install the Cas Editor 2.3.1 again.\n\nThe Analysis Engine and Cas Consumer run support was also removed and is replaced by the new Analysis Engine Launch plugin.");
                }
            });
        }
        if (this.getDocument() != null) {
            String[] shownTypes;
            AnnotationOutline outline = new AnnotationOutline(this);
            this.mOutlinePage.setCASViewPage((IPageBookViewPage)outline);
            this.shownAnnotationTypes.clear();
            String shownTypesString = this.getCasDocumentProvider().getSessionPreferenceStore(input).getString("LastShownTypes");
            for (String shownType : shownTypes = shownTypesString.split(";")) {
                Type type = this.getDocument().getType(shownType);
                if (type == null) continue;
                this.shownAnnotationTypes.add(type);
            }
            if (this.getSourceViewer() != null) {
                this.initiallySynchronizeUI();
                IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
                for (IViewPart view : page.getViews()) {
                    if (!(view instanceof PageBookView)) continue;
                    ((PageBookView)view).partBroughtToTop(this.getEditorSite().getPart());
                }
            }
        } else {
            this.mOutlinePage.setCASViewPage(null);
        }
        final ICasDocument newDocument = this.getDocument();
        if (this.mEditorInputListener != null) {
            for (Object listener : this.mEditorInputListener.getListeners()) {
                final ICasEditorInputListener inputListener = (ICasEditorInputListener)listener;
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        inputListener.casDocumentChanged(oldInput, oldDocument, input, newDocument);
                    }
                });
            }
        }
    }

    protected boolean isErrorStatus(IStatus status) {
        return super.isErrorStatus(status) || this.getDocument().getCAS().getDocumentText() == null;
    }

    private void initiallySynchronizeUI() {
        if (this.getDocument() != null) {
            this.mShowAnnotationsMenu = new ShowAnnotationsMenu(this.getDocument().getCAS().getTypeSystem(), this.shownAnnotationTypes);
            this.mShowAnnotationsMenu.addListener(new IShowAnnotationsListener(){

                @Override
                public void selectionChanged(Collection<Type> selection) {
                    HashSet notShownAnymore = new HashSet(AnnotationEditor.this.shownAnnotationTypes);
                    notShownAnymore.removeAll(selection);
                    for (Type type : notShownAnymore) {
                        AnnotationEditor.this.showAnnotationType(type, false);
                    }
                    HashSet<Type> newShownTypes = new HashSet<Type>(selection);
                    newShownTypes.removeAll(AnnotationEditor.this.shownAnnotationTypes);
                    for (Type type : newShownTypes) {
                        AnnotationEditor.this.showAnnotationType(type, true);
                    }
                    AnnotationEditor.this.mPainter.paint(16);
                    AnnotationEditor.this.setEditorSessionPreferences();
                    if (AnnotationEditor.this.mEditorListener != null) {
                        for (IAnnotationEditorModifyListener listener : AnnotationEditor.this.mEditorListener) {
                            listener.showAnnotationsChanged(selection);
                        }
                    }
                }
            });
            IPreferenceStore sessionPreferences = this.getCasDocumentProvider().getSessionPreferenceStore(this.getEditorInput());
            Type annotationModeType = this.getDocument().getType(sessionPreferences.getString("LastUsedModeType"));
            if (annotationModeType == null) {
                annotationModeType = this.getDocument().getType("uima.tcas.Annotation");
            }
            this.setAnnotationMode(annotationModeType);
            String lastActiveViewName = sessionPreferences.getString("LastActiveCasViewName");
            try {
                this.getDocument().getCAS().getView(lastActiveViewName);
                this.showView(lastActiveViewName);
            }
            catch (CASRuntimeException e) {
                this.showView("_InitialView");
            }
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.appendToGroup("additions", (IContributionItem)new Separator());
        menu.appendToGroup("additions", this.getAction("Annotate"));
        menu.appendToGroup("additions", this.getAction("QuickAnnotate"));
        menu.appendToGroup("additions", this.getAction("org.eclipse.ui.edit.delete"));
        TypeSystem typeSytem = this.getDocument().getCAS().getTypeSystem();
        MenuManager modeMenuManager = new MenuManager("Mode");
        menu.appendToGroup("additions", (IContributionItem)modeMenuManager);
        ModeMenu modeMenu = new ModeMenu(typeSytem, this);
        modeMenu.addListener(new IModeMenuListener(){

            @Override
            public void modeChanged(Type newMode) {
                ChangeModeAction actionToExecute = new ChangeModeAction(newMode, newMode.getShortName(), AnnotationEditor.this);
                actionToExecute.run();
            }
        });
        modeMenuManager.add((IContributionItem)modeMenu);
        MenuManager showAnnotationMenu = new MenuManager("Show Annotations");
        menu.appendToGroup("additions", (IContributionItem)showAnnotationMenu);
        showAnnotationMenu.add((IContributionItem)this.mShowAnnotationsMenu);
        MenuManager casViewMenuManager = new MenuManager("CAS Views");
        menu.appendToGroup("additions", (IContributionItem)casViewMenuManager);
        CasViewMenu casViewMenu = new CasViewMenu(this);
        casViewMenuManager.add((IContributionItem)casViewMenu);
    }

    private void updateStatusLineModeItem() {
        IStatusField statusField = this.getStatusField("org.apache.uima.caseditor.editor.mode.status");
        if (statusField != null) {
            statusField.setText(this.getAnnotationMode().getShortName());
        }
    }

    @Override
    public ICasDocument getDocument() {
        return (ICasDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    @Override
    public void reopenEditorWithNewTypeSystem() {
        this.setInput(this.getEditorInput());
    }

    public Type getAnnotationMode() {
        return this.mAnnotationMode;
    }

    public void setAnnotationMode(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null!");
        }
        this.mAnnotationMode = type;
        this.highlight(0, 0);
        this.setEditorSessionPreferences();
        this.updateStatusLineModeItem();
        this.syncAnnotationTypes();
        this.fireAnnotationTypeChanged(this.getAnnotationMode());
        this.mShowAnnotationsMenu.setEditorAnnotationMode(type);
    }

    public Collection<Type> getShownAnnotationTypes() {
        return Collections.unmodifiableCollection(this.shownAnnotationTypes);
    }

    public void setShownAnnotationType(Type type, boolean isShown) {
        this.mShowAnnotationsMenu.setSelectedType(type, isShown);
    }

    public void setShownAnnotationTypes(Collection<Type> types) {
        this.mShowAnnotationsMenu.setSelectedTypes(types);
    }

    private void fireAnnotationTypeChanged(Type type) {
        if (this.mEditorListener != null) {
            for (IAnnotationEditorModifyListener listener : this.mEditorListener) {
                listener.annotationModeChanged(type);
            }
        }
    }

    public AnnotationStyle getAnnotationStyle(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type parameter must not be null!");
        }
        IPreferenceStore prefStore = this.getCasDocumentProvider().getTypeSystemPreferenceStore(this.getEditorInput());
        return AnnotationStyle.getAnnotationStyleFromStore(prefStore, type.getName());
    }

    public void setAnnotationStyle(AnnotationStyle style) {
        IPreferenceStore prefStore = this.getCasDocumentProvider().getTypeSystemPreferenceStore(this.getEditorInput());
        AnnotationStyle.putAnnotatationStyleToStore(prefStore, style);
        this.getCasDocumentProvider().saveTypeSystemPreferenceStore(this.getEditorInput());
    }

    private void showAnnotationType(Type type, boolean isVisible) {
        AnnotationStyle style = this.getAnnotationStyle(type);
        if (isVisible) {
            AnnotationPainter.IDrawingStrategy strategy = DrawingStyle.createStrategy(style);
            if (strategy != null) {
                if (style.getStyle().equals((Object)AnnotationStyle.Style.TAG)) {
                    this.getSourceViewer().getTextWidget().setLineSpacing(13);
                }
                this.mPainter.addDrawingStrategy((Object)type.getName(), strategy);
                this.mPainter.addAnnotationType((Object)type.getName(), (Object)type.getName());
                Color color = style.getColor();
                this.mPainter.setAnnotationTypeColor((Object)type.getName(), new org.eclipse.swt.graphics.Color(null, color.getRed(), color.getGreen(), color.getBlue()));
            }
            this.shownAnnotationTypes.add(type);
        } else {
            this.mPainter.removeAnnotationType((Object)type.getName());
            this.shownAnnotationTypes.remove(type);
            if (style.getStyle().equals((Object)AnnotationStyle.Style.TAG)) {
                boolean isKeepLineSpacing = false;
                for (Type shownType : this.shownAnnotationTypes) {
                    AnnotationStyle potentialTagStyle = this.getAnnotationStyle(shownType);
                    if (!AnnotationStyle.Style.TAG.equals((Object)potentialTagStyle.getStyle())) continue;
                    isKeepLineSpacing = true;
                    break;
                }
                if (!isKeepLineSpacing) {
                    this.getSourceViewer().getTextWidget().setLineSpacing(0);
                }
            }
        }
    }

    public void syncAnnotationTypes() {
        this.mPainter.removeAllAnnotationTypes();
        this.getSourceViewer().getTextWidget().setLineSpacing(0);
        for (Type displayType : this.mShowAnnotationsMenu.getSelectedTypes()) {
            this.showAnnotationType(displayType, true);
        }
        if (!this.mShowAnnotationsMenu.getSelectedTypes().contains(this.getAnnotationMode())) {
            this.showAnnotationType(this.getAnnotationMode(), true);
        }
        this.mPainter.paint(16);
    }

    private void removeAllAnnotations() {
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        ((IAnnotationModelExtension)annotationModel).removeAllAnnotations();
    }

    private void syncAnnotations() {
        this.removeAllAnnotations();
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        ((IAnnotationModelExtension)annotationModel).removeAllAnnotations();
        FSIterator mAnnotations = this.getDocument().getCAS().getAnnotationIndex().iterator();
        HashMap<EclipseAnnotationPeer, Position> annotationsToAdd = new HashMap<EclipseAnnotationPeer, Position>();
        while (mAnnotations.hasNext()) {
            AnnotationFS annotationFS = (AnnotationFS)mAnnotations.next();
            annotationsToAdd.put(new EclipseAnnotationPeer(annotationFS), new Position(annotationFS.getBegin(), annotationFS.getEnd() - annotationFS.getBegin()));
        }
        ((IAnnotationModelExtension)annotationModel).replaceAnnotations(null, annotationsToAdd);
    }

    public void addAnnotationListener(IAnnotationEditorModifyListener listener) {
        this.mEditorListener.add(listener);
    }

    public void removeAnnotationListener(IAnnotationEditorModifyListener listener) {
        this.mEditorListener.remove(listener);
    }

    @Override
    public void addCasEditorInputListener(ICasEditorInputListener listener) {
        this.mEditorInputListener.add((Object)listener);
    }

    @Override
    public void removeCasEditorInputListener(ICasEditorInputListener listener) {
        this.mEditorInputListener.remove((Object)listener);
    }

    public Point getSelection() {
        return this.getSourceViewer().getTextWidget().getSelection();
    }

    private void highlight(int start, int length) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        assert (sourceViewer != null);
        StyledText text = sourceViewer.getTextWidget();
        if (this.mCurrentStyleRange != null) {
            StyleRange resetedStyleRange = new StyleRange(this.mCurrentStyleRange.start, this.mCurrentStyleRange.length, null, null);
            text.setStyleRange(resetedStyleRange);
            this.mCurrentStyleRange = null;
        }
        if (length != 0) {
            this.mCurrentStyleRange = new StyleRange(start, length, text.getSelectionForeground(), text.getSelectionBackground());
            text.setStyleRange(this.mCurrentStyleRange);
        }
    }

    public List<AnnotationFS> getSelectedAnnotations() {
        ArrayList<AnnotationFS> selection = new ArrayList<AnnotationFS>();
        if (this.isSomethingSelected()) {
            Point selectedText = this.getSourceViewer().getTextWidget().getSelectionRange();
            Span selecectedSpan = new Span(selectedText.x, selectedText.y);
            Collection<AnnotationFS> selectedAnnotations = AnnotationEditor.getAnnotation(this.getDocument().getCAS(), this.getAnnotationMode(), selecectedSpan);
            for (AnnotationFS annotation : selectedAnnotations) {
                selection.add(annotation);
            }
            Collections.sort(selection, new AnnotationComparator());
        } else {
            Map<Integer, AnnotationFS> view = this.getView(this.getAnnotationMode());
            AnnotationFS annotation = view.get(this.getSourceViewer().getTextWidget().getCaretOffset());
            if (annotation == null) {
                annotation = view.get(this.mCursorPosition - 1);
            }
            if (annotation != null) {
                selection.add(annotation);
            }
        }
        return selection;
    }

    public int getCaretOffset() {
        return this.getSourceViewer().getTextWidget().getCaretOffset();
    }

    public void showView(String viewName) {
        this.mFeatureStructureSelectionProvider.clearSelection();
        if (this.getSourceViewer().getTextWidget().getText().length() > 0) {
            this.getSourceViewer().getTextWidget().setCaretOffset(0);
        }
        this.highlight(0, 0);
        this.removeAllAnnotations();
        ((AnnotationDocument)this.getDocument()).switchView(viewName);
        this.getSourceViewer().setDocument((IDocument)((AnnotationDocument)this.getDocument()), this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput()));
        this.getSourceViewer().invalidateTextPresentation();
        this.setEditorSessionPreferences();
        if (!this.isErrorStatus(this.getCasDocumentProvider().getStatus(this.getEditorInput()))) {
            this.syncAnnotations();
            if (this.mAnnotationSynchronizer == null) {
                this.mAnnotationSynchronizer = new DocumentListener();
                this.getDocument().addChangeListener(this.mAnnotationSynchronizer);
            }
            if (this.mAnnotationStyleListener == null) {
                this.mAnnotationStyleListener = new AnnotationStyleChangeListener(){

                    @Override
                    public void annotationStylesChanged(Collection<AnnotationStyle> styles) {
                        AnnotationEditor.this.syncAnnotationTypes();
                    }
                };
                this.getCasDocumentProvider().getTypeSystemPreferenceStore(this.getEditorInput()).addPropertyChangeListener((IPropertyChangeListener)this.mAnnotationStyleListener);
            }
            this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        } else {
            if (this.mAnnotationSynchronizer != null) {
                this.getDocument().removeChangeListener(this.mAnnotationSynchronizer);
                this.mAnnotationSynchronizer = null;
            }
            if (this.mAnnotationStyleListener != null) {
                this.getCasDocumentProvider().getTypeSystemPreferenceStore(this.getEditorInput()).removePropertyChangeListener((IPropertyChangeListener)this.mAnnotationStyleListener);
                this.mAnnotationStyleListener = null;
            }
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        }
        this.updatePartControl(this.getEditorInput());
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            AnnotationSelection annotations = new AnnotationSelection((IStructuredSelection)((StructuredSelection)selection));
            if (this.getSite().getPage().getActiveEditor() == this) {
                if (!annotations.isEmpty()) {
                    this.highlight(annotations.getFirst().getBegin(), annotations.getLast().getEnd() - annotations.getFirst().getBegin());
                    if (this != part) {
                        int newCaretOffset = annotations.getLast().getEnd();
                        String text = this.getSourceViewer().getTextWidget().getText();
                        if (newCaretOffset > 0 && newCaretOffset < text.length()) {
                            char beforeCaret = text.charAt(newCaretOffset - 1);
                            char afterCaret = text.charAt(newCaretOffset);
                            int cr = 13;
                            int lf = 10;
                            if (beforeCaret == '\r' && afterCaret == '\n') {
                                --newCaretOffset;
                            }
                        }
                        this.getSourceViewer().getTextWidget().setCaretOffset(newCaretOffset);
                        this.getSourceViewer().revealRange(newCaretOffset, 0);
                        this.mFeatureStructureSelectionProvider.setSelection(selection);
                    }
                } else {
                    this.highlight(0, 0);
                }
            }
        }
    }

    private boolean isSomethingSelected() {
        return this.getSourceViewer().getTextWidget().getSelectionCount() != 0;
    }

    private void setEditorSessionPreferences() {
        IPreferenceStore sessionStore = this.getCasDocumentProvider().getSessionPreferenceStore(this.getEditorInput());
        sessionStore.setValue("LastActiveCasViewName", this.getDocument().getCAS().getViewName());
        sessionStore.setValue("LastUsedModeType", this.getAnnotationMode().getName());
        StringBuilder shownTypesString = new StringBuilder();
        for (Type shownType : this.getShownAnnotationTypes()) {
            shownTypesString.append(shownType.getName());
            shownTypesString.append(";");
        }
        sessionStore.setValue("LastShownTypes", shownTypesString.toString());
    }

    protected void createActions() {
        super.createActions();
        this.mFeatureStructureSelectionProvider = new FeatureStructureSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFeatureStructureSelectionProvider);
        QuickAnnotateAction quickAnnotateAction = new QuickAnnotateAction(this.getSourceViewer().getTextWidget());
        quickAnnotateAction.setActionDefinitionId("QuickAnnotate");
        quickAnnotateAction.setText("Quick Annotate");
        this.setAction("QuickAnnotate", (IAction)quickAnnotateAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)quickAnnotateAction);
        SmartAnnotateAction smartAnnotateAction = new SmartAnnotateAction();
        smartAnnotateAction.setActionDefinitionId("Annotate");
        smartAnnotateAction.setText("Annotate");
        this.setAction("Annotate", (IAction)smartAnnotateAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)smartAnnotateAction);
        DeleteFeatureStructureAction deleteAnnotationAction = new DeleteFeatureStructureAction(this);
        deleteAnnotationAction.setText("Delete Annotation");
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)deleteAnnotationAction);
        deleteAnnotationAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction("org.eclipse.ui.edit.delete", (IAction)deleteAnnotationAction);
        this.setActionActivationCode("org.eclipse.ui.edit.delete", '\u0000', 13, 0);
        ShowAnnotationContextEditAction annotationContextEditAction = new ShowAnnotationContextEditAction();
        annotationContextEditAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", (IAction)annotationContextEditAction);
        FindAnnotateAction findAnnotateAction = new FindAnnotateAction(this, this.getSourceViewer().getFindReplaceTarget());
        findAnnotateAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction(ITextEditorActionConstants.FIND, (IAction)findAnnotateAction);
        LowerLeftAnnotationSideAction lowerLeftAnnotationSideAction = new LowerLeftAnnotationSideAction(this);
        lowerLeftAnnotationSideAction.setActionDefinitionId("LowerLeftAnnotationSide");
        this.setAction("LowerLeftAnnotationSide", (IAction)lowerLeftAnnotationSideAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)lowerLeftAnnotationSideAction);
        WideLeftAnnotationSideAction wideLeftAnnotationSide = new WideLeftAnnotationSideAction(this);
        wideLeftAnnotationSide.setActionDefinitionId("WideLeftAnnotationSide");
        this.setAction("WideLeftAnnotationSide", (IAction)wideLeftAnnotationSide);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)wideLeftAnnotationSide);
        LowerRightAnnotationSideAction lowerRightAnnotationSideAction = new LowerRightAnnotationSideAction(this);
        lowerRightAnnotationSideAction.setActionDefinitionId("LowerRightAnnotationSide");
        this.setAction("LowerRightAnnotationSide", (IAction)lowerRightAnnotationSideAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)lowerRightAnnotationSideAction);
        WideRightAnnotationSideAction wideRightAnnotationSideAction = new WideRightAnnotationSideAction(this);
        wideRightAnnotationSideAction.setActionDefinitionId("WideRightAnnotationSide");
        this.setAction("WideRightAnnotationSide", (IAction)wideRightAnnotationSideAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)wideRightAnnotationSideAction);
    }

    public void dispose() {
        IPreferenceStore store;
        CasDocumentProvider provider;
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        ICasDocument document = this.getDocument();
        if (document != null) {
            document.removeChangeListener(this.mAnnotationSynchronizer);
        }
        if ((provider = this.getCasDocumentProvider()) != null && (store = provider.getTypeSystemPreferenceStore(this.getEditorInput())) != null) {
            store.removePropertyChangeListener((IPropertyChangeListener)this.mAnnotationStyleListener);
        }
        if (this.preferenceStoreChangeListener != null) {
            CasEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceStoreChangeListener);
        }
        super.dispose();
    }

    void setAnnotationSelection(AnnotationFS annotation) {
        this.mFeatureStructureSelectionProvider.setSelection(this.getDocument(), annotation);
    }

    public static AnnotationEditor[] getAnnotationEditors() {
        IWorkbenchWindow[] windows;
        ArrayList<AnnotationEditor> dirtyParts = new ArrayList<AnnotationEditor>();
        for (IWorkbenchWindow element : windows = PlatformUI.getWorkbench().getWorkbenchWindows()) {
            IWorkbenchPage[] pages;
            for (IWorkbenchPage page : pages = element.getPages()) {
                IEditorReference[] references;
                for (IEditorReference reference : references = page.getEditorReferences()) {
                    IEditorPart part = reference.getEditor(false);
                    if (!(part instanceof AnnotationEditor)) continue;
                    AnnotationEditor editor = (AnnotationEditor)part;
                    dirtyParts.add(editor);
                }
            }
        }
        return dirtyParts.toArray(new AnnotationEditor[dirtyParts.size()]);
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        if (status.getCode() == 12 && this.getEditorInput() != null) {
            return this.getCasDocumentProvider().createTypeSystemSelectorForm(this, parent, status);
        }
        if (status.getCode() == 0) {
            if (this.getDocument() != null && this.getDocument().getCAS().getDocumentText() == null) {
                Composite noTextComposite = new Composite(parent, 0);
                noTextComposite.setLayout((Layout)new GridLayout(1, false));
                Label noTextLabel = new Label(noTextComposite, 0);
                noTextLabel.setText("Text sofa is not set!");
                Label switchToView = new Label(noTextComposite, 0);
                switchToView.setText("Choose a view to switch to:");
                final Combo viewSelectionCombo = new Combo(noTextComposite, 8);
                ArrayList<String> viewNames = new ArrayList<String>();
                Iterator it = this.getDocument().getCAS().getViewIterator();
                while (it.hasNext()) {
                    viewNames.add(((CAS)it.next()).getViewName());
                }
                viewSelectionCombo.setItems(viewNames.toArray(new String[viewNames.size()]));
                viewSelectionCombo.select(0);
                Button switchView = new Button(noTextComposite, 8);
                switchView.setText("Switch");
                switchView.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        AnnotationEditor.this.showView(viewSelectionCombo.getText());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return noTextComposite;
            }
            return super.createStatusControl(parent, status);
        }
        return super.createStatusControl(parent, status);
    }

    static Collection<AnnotationFS> getAnnotation(CAS cas, Type type, Span span) {
        ConstraintFactory cf = cas.getConstraintFactory();
        Type annotationType = cas.getAnnotationType();
        FeaturePath beginPath = cas.createFeaturePath();
        beginPath.addFeature(annotationType.getFeatureByBaseName("begin"));
        FSIntConstraint beginConstraint = cf.createIntConstraint();
        beginConstraint.geq(span.getStart());
        FSMatchConstraint embeddedBegin = cf.embedConstraint(beginPath, (FSConstraint)beginConstraint);
        FeaturePath endPath = cas.createFeaturePath();
        endPath.addFeature(annotationType.getFeatureByBaseName("end"));
        FSIntConstraint endConstraint = cf.createIntConstraint();
        endConstraint.leq(span.getEnd());
        FSMatchConstraint embeddedEnd = cf.embedConstraint(endPath, (FSConstraint)endConstraint);
        StrictTypeConstraint strictType = new StrictTypeConstraint(type);
        FSMatchConstraint annotatioInSpanConstraint = cf.and(embeddedBegin, embeddedEnd);
        FSMatchConstraint annotationInSpanAndStrictTypeConstraint = cf.and(annotatioInSpanConstraint, (FSMatchConstraint)strictType);
        AnnotationIndex allAnnotations = cas.getAnnotationIndex(type);
        FSIterator annotationInsideSpanIndex = cas.createFilteredIterator(allAnnotations.iterator(), annotationInSpanAndStrictTypeConstraint);
        return DocumentUimaImpl.fsIteratorToCollection((FSIterator<AnnotationFS>)annotationInsideSpanIndex);
    }

    private Map<Integer, AnnotationFS> getView(Type annotationType) {
        Collection<AnnotationFS> annotations = this.getDocument().getAnnotations(annotationType);
        HashMap<Integer, AnnotationFS> viewMap = new HashMap<Integer, AnnotationFS>();
        for (AnnotationFS annotation : annotations) {
            for (int i = annotation.getBegin(); i <= annotation.getEnd() - 1; ++i) {
                viewMap.put(i, annotation);
            }
        }
        return Collections.unmodifiableMap(viewMap);
    }

    static class CasViewMenu
    extends ContributionItem {
        private AnnotationEditor casEditor;

        public CasViewMenu(AnnotationEditor casEditor) {
            this.casEditor = casEditor;
        }

        public void fill(Menu parentMenu, int index) {
            CAS cas = this.casEditor.getDocument().getCAS();
            Iterator it = cas.getViewIterator();
            while (it.hasNext()) {
                CAS casView = (CAS)it.next();
                final String viewName = casView.getViewName();
                MenuItem actionItem = new MenuItem(parentMenu, 32);
                actionItem.setText(viewName);
                try {
                    actionItem.setEnabled(cas.getDocumentText() != null);
                }
                catch (Throwable t) {
                    actionItem.setEnabled(false);
                }
                if (cas.getViewName().equals(viewName)) {
                    actionItem.setSelection(true);
                }
                actionItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (!casEditor.getDocument().getCAS().getViewName().equals(viewName)) {
                            casEditor.showView(viewName);
                        }
                    }
                });
            }
        }
    }

    private class AnnotationAccess
    implements IAnnotationAccess,
    IAnnotationAccessExtension {
        private AnnotationAccess() {
        }

        public Object getType(Annotation annotation) {
            return null;
        }

        public boolean isMultiLine(Annotation annotation) {
            return false;
        }

        public boolean isTemporary(Annotation annotation) {
            return false;
        }

        public int getLayer(Annotation annotation) {
            if (annotation instanceof EclipseAnnotationPeer) {
                EclipseAnnotationPeer eclipseAnnotation = (EclipseAnnotationPeer)annotation;
                AnnotationStyle style = AnnotationEditor.this.getAnnotationStyle(eclipseAnnotation.getAnnotationFS().getType());
                return style.getLayer();
            }
            return 0;
        }

        public Object[] getSupertypes(Object annotationType) {
            return new Object[0];
        }

        public String getTypeLabel(Annotation annotation) {
            return null;
        }

        public boolean isPaintable(Annotation annotation) {
            assert (false) : "Should never be called";
            return false;
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            Type type = AnnotationEditor.this.getDocument().getCAS().getTypeSystem().getType((String)annotationType);
            return AnnotationEditor.this.mShowAnnotationsMenu.getSelectedTypes().contains(type) || AnnotationEditor.this.getAnnotationMode().equals(type);
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            assert (false) : "Should never be called";
        }
    }

    private class FeatureStructureDragListener
    implements DragSourceListener {
        private boolean mIsActive;
        private AnnotationFS mCandidate;

        FeatureStructureDragListener(final StyledText textWidget) {
            textWidget.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 65536) {
                        FeatureStructureDragListener.this.mIsActive = true;
                        textWidget.setCursor(Display.getCurrent().getSystemCursor(21));
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (e.stateMask == 65536) {
                        FeatureStructureDragListener.this.mIsActive = false;
                        textWidget.setCursor(null);
                    }
                }
            });
            textWidget.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (FeatureStructureDragListener.this.mIsActive) {
                        int offset;
                        try {
                            offset = textWidget.getOffsetAtLocation(new Point(e.x, e.y));
                        }
                        catch (IllegalArgumentException e2) {
                            return;
                        }
                        Map view = AnnotationEditor.this.getView(AnnotationEditor.this.getAnnotationMode());
                        FeatureStructureDragListener.this.mCandidate = (AnnotationFS)view.get(offset);
                        if (FeatureStructureDragListener.this.mCandidate != null) {
                            textWidget.setSelectionRange(FeatureStructureDragListener.this.mCandidate.getBegin(), FeatureStructureDragListener.this.mCandidate.getEnd() - FeatureStructureDragListener.this.mCandidate.getBegin());
                        }
                    }
                }
            });
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = this.mIsActive ? this.mCandidate != null : false;
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = this.mCandidate;
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }

    private class DocumentListener
    extends AbstractAnnotationDocumentListener {
        private DocumentListener() {
        }

        @Override
        public void addedAnnotation(Collection<AnnotationFS> annotations) {
            IAnnotationModelExtension annotationModel = (IAnnotationModelExtension)AnnotationEditor.this.getDocumentProvider().getAnnotationModel((Object)AnnotationEditor.this.getEditorInput());
            HashMap<EclipseAnnotationPeer, Position> addAnnotationMap = new HashMap<EclipseAnnotationPeer, Position>();
            for (AnnotationFS annotation : annotations) {
                addAnnotationMap.put(new EclipseAnnotationPeer(annotation), new Position(annotation.getBegin(), annotation.getEnd() - annotation.getBegin()));
            }
            annotationModel.replaceAnnotations(null, addAnnotationMap);
        }

        @Override
        public void removedAnnotation(Collection<AnnotationFS> deletedAnnotations) {
            if (AnnotationEditor.this.getSite().getPage().getActivePart() == AnnotationEditor.this) {
                AnnotationEditor.this.mFeatureStructureSelectionProvider.clearSelection();
            } else {
                AnnotationEditor.this.mFeatureStructureSelectionProvider.clearSelectionSilently();
            }
            AnnotationEditor.this.highlight(0, 0);
            IAnnotationModelExtension annotationModel = (IAnnotationModelExtension)AnnotationEditor.this.getDocumentProvider().getAnnotationModel((Object)AnnotationEditor.this.getEditorInput());
            Annotation[] removeAnnotations = new Annotation[deletedAnnotations.size()];
            int removeAnnotationsIndex = 0;
            for (AnnotationFS annotation : deletedAnnotations) {
                removeAnnotations[removeAnnotationsIndex++] = new EclipseAnnotationPeer(annotation);
            }
            annotationModel.replaceAnnotations(removeAnnotations, null);
        }

        @Override
        public void updatedAnnotation(Collection<AnnotationFS> annotations) {
            IAnnotationModelExtension annotationModel = (IAnnotationModelExtension)AnnotationEditor.this.getDocumentProvider().getAnnotationModel((Object)AnnotationEditor.this.getEditorInput());
            for (AnnotationFS annotation : annotations) {
                annotationModel.modifyAnnotationPosition((Annotation)new EclipseAnnotationPeer(annotation), new Position(annotation.getBegin(), annotation.getEnd() - annotation.getBegin()));
            }
            AnnotationEditor.this.selectionChanged(AnnotationEditor.this.getSite().getPage().getActivePart(), AnnotationEditor.this.mFeatureStructureSelectionProvider.getSelection());
        }

        @Override
        public void changed() {
            AnnotationEditor.this.mFeatureStructureSelectionProvider.clearSelection();
            AnnotationEditor.this.syncAnnotations();
        }

        @Override
        public void viewChanged(String oldViewName, String newViewName) {
        }
    }

    private class ShowAnnotationContextEditAction
    extends Action {
        private InformationPresenter mPresenter = new InformationPresenter((IInformationControlCreator)new AnnotationEditingControlCreator());

        ShowAnnotationContextEditAction() {
            this.mPresenter.setInformationProvider((IInformationProvider)new AnnotationInformationProvider(AnnotationEditor.this), "__dftl_partition_content_type");
            this.mPresenter.setDocumentPartitioning("__dftl_partition_content_type");
            this.mPresenter.install((ITextViewer)AnnotationEditor.this.getSourceViewer());
        }

        public void run() {
            this.mPresenter.showInformation();
        }
    }

    private class SmartAnnotateAction
    extends AbstractAnnotateAction {
        private static final String ID = "Annotate";

        private SmartAnnotateAction() {
        }

        public void run() {
            if (AnnotationEditor.this.isSomethingSelected()) {
                QuickTypeSelectionDialog typeDialog = new QuickTypeSelectionDialog(Display.getCurrent().getActiveShell(), AnnotationEditor.this);
                typeDialog.open();
            }
        }
    }

    private class QuickAnnotateAction
    extends AbstractAnnotateAction {
        private static final String ID = "QuickAnnotate";
        private StyledText mTextWidget;

        QuickAnnotateAction(StyledText textWidget) {
            this.mTextWidget = textWidget;
        }

        public void run() {
            if (AnnotationEditor.this.isSomethingSelected()) {
                Point selection = this.mTextWidget.getSelectionRange();
                Collection<AnnotationFS> oldAnnotations = AnnotationEditor.getAnnotation(this.getDocument().getCAS(), AnnotationEditor.this.getAnnotationMode(), new Span(selection.x, selection.y));
                if (!oldAnnotations.isEmpty()) {
                    this.getDocument().removeFeatureStructures(oldAnnotations);
                }
                int start = selection.x;
                int end = start + selection.y;
                AnnotationFS annotation = this.getDocument().getCAS().createAnnotation(AnnotationEditor.this.getAnnotationMode(), start, end);
                this.getDocument().addFeatureStructure((FeatureStructure)annotation);
                AnnotationEditor.this.setAnnotationSelection(annotation);
            }
        }

        ICasDocument getDocument() {
            return AnnotationEditor.this.getDocument();
        }
    }

    private abstract class AbstractAnnotateAction
    extends Action
    implements ISelectionChangedListener {
        private AbstractAnnotateAction() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setEnabled(AnnotationEditor.this.getSelection().y - AnnotationEditor.this.getSelection().x > 0);
        }
    }
}

