/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.contextmenu;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.editor.contextmenu.IShowAnnotationsListener;
import org.apache.uima.caseditor.editor.contextmenu.TypeMenu;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowAnnotationsMenu
extends TypeMenu {
    private Set<IShowAnnotationsListener> listeners = new HashSet<IShowAnnotationsListener>();
    private Collection<Type> typesToDisplay = new HashSet<Type>();
    private Type editorAnnotationMode;

    public ShowAnnotationsMenu(TypeSystem typeSystem, Collection<Type> shownTypes) {
        super(typeSystem.getType("uima.tcas.Annotation"), typeSystem);
        for (Type type : shownTypes) {
            this.typesToDisplay.add(type);
        }
    }

    public void addListener(IShowAnnotationsListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IShowAnnotationsListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void insertAction(final Type type, Menu parentMenu) {
        final MenuItem actionItem = new MenuItem(parentMenu, 32);
        actionItem.setText(type.getName());
        if (this.editorAnnotationMode != null && this.editorAnnotationMode.equals(type)) {
            actionItem.setSelection(true);
        }
        if (this.typesToDisplay.contains(type)) {
            actionItem.setSelection(true);
        }
        actionItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (actionItem.getSelection()) {
                    ShowAnnotationsMenu.this.typesToDisplay.add(type);
                } else {
                    ShowAnnotationsMenu.this.typesToDisplay.remove(type);
                }
                ShowAnnotationsMenu.this.fireChanged();
            }
        });
    }

    public Collection<Type> getSelectedTypes() {
        LinkedList<Type> selectedTypes = new LinkedList<Type>();
        if (this.editorAnnotationMode != null) {
            selectedTypes.add(this.editorAnnotationMode);
        }
        for (Type type : this.typesToDisplay) {
            selectedTypes.add(type);
        }
        return Collections.unmodifiableCollection(selectedTypes);
    }

    private void fireChanged() {
        for (IShowAnnotationsListener listener : this.listeners) {
            listener.selectionChanged(this.getSelectedTypes());
        }
    }

    public void setSelectedType(Type type, boolean isShown) {
        if (this.typesToDisplay.contains(type)) {
            if (!isShown) {
                this.typesToDisplay.remove(type);
                this.fireChanged();
            }
        } else if (isShown) {
            this.typesToDisplay.add(type);
            this.fireChanged();
        }
    }

    public void setSelectedTypes(Collection<Type> types) {
        this.typesToDisplay = new HashSet<Type>();
        for (Type type : types) {
            this.typesToDisplay.add(type);
        }
        for (IShowAnnotationsListener listener : this.listeners) {
            listener.selectionChanged(this.getSelectedTypes());
        }
    }

    public void setEditorAnnotationMode(Type newMode) {
        if (this.typesToDisplay.contains(newMode)) {
            if (this.editorAnnotationMode != null) {
                this.editorAnnotationMode = null;
                this.fireChanged();
            }
        } else {
            this.editorAnnotationMode = newMode;
            this.fireChanged();
        }
    }
}

