/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.Collection;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.DocumentUimaImpl;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationDocument
extends Document
implements ICasDocument {
    private ICasDocument mDocument;
    private int lineLengthHint;

    public AnnotationDocument() {
        IPreferenceStore prefStore = CasEditorPlugin.getDefault().getPreferenceStore();
        this.lineLengthHint = prefStore.getInt("EDITOR_LINE_LENGTH_HINT");
        if (this.lineLengthHint == 0) {
            this.lineLengthHint = 80;
        }
    }

    private String transformText(String text) {
        if (this.lineLengthHint != 0 && text != null) {
            return this.wrapWords(text, this.lineLengthHint);
        }
        if (text != null) {
            return text;
        }
        return "";
    }

    private String getText() {
        String text = this.getCAS().getDocumentText();
        return this.transformText(text);
    }

    private void fireDocumentChanged() {
        DocumentEvent ev = new DocumentEvent();
        ev.fDocument = this;
        this.fireDocumentChanged(ev);
    }

    public void setDocument(ICasDocument element) {
        this.mDocument = element;
        this.set(this.getText());
    }

    public ICasDocument getDocument() {
        return this.mDocument;
    }

    @Override
    public void addFeatureStructure(FeatureStructure annotation) {
        this.mDocument.addFeatureStructure(annotation);
        this.fireDocumentChanged();
    }

    @Override
    public void addFeatureStructures(Collection<? extends FeatureStructure> annotations) {
        this.mDocument.addFeatureStructures(annotations);
        this.fireDocumentChanged();
    }

    @Override
    public void removeFeatureStructure(FeatureStructure annotation) {
        this.mDocument.removeFeatureStructure(annotation);
        this.fireDocumentChanged();
    }

    @Override
    public void removeFeatureStructures(Collection<? extends FeatureStructure> annotationsToRemove) {
        this.mDocument.removeFeatureStructures(annotationsToRemove);
        this.fireDocumentChanged();
    }

    @Override
    public void update(FeatureStructure annotation) {
        this.mDocument.update(annotation);
        this.fireDocumentChanged();
    }

    @Override
    public void updateFeatureStructure(Collection<? extends FeatureStructure> annotations) {
        this.mDocument.updateFeatureStructure(annotations);
        this.fireDocumentChanged();
    }

    @Override
    public void changed() {
        this.mDocument.changed();
        this.fireDocumentChanged();
    }

    @Override
    public Collection<AnnotationFS> getAnnotations(Type type) {
        return this.mDocument.getAnnotations(type);
    }

    @Override
    public void addChangeListener(ICasDocumentListener listener) {
        this.mDocument.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ICasDocumentListener listener) {
        this.mDocument.removeChangeListener(listener);
    }

    private String wrapWords(String textString, int lineLengthHint) {
        char[] text = textString.toCharArray();
        int charCounter = 0;
        for (int i = 0; i < text.length; ++i) {
            if (text[i] == '\r' || text[i] == '\n') {
                charCounter = 0;
            }
            if (charCounter > lineLengthHint && text[i] == ' ') {
                text[i] = 10;
                charCounter = 0;
            }
            ++charCounter;
        }
        return new String(text);
    }

    @Override
    public CAS getCAS() {
        return this.mDocument.getCAS();
    }

    @Override
    public Type getType(String type) {
        return this.mDocument.getType(type);
    }

    @Override
    public void switchView(String viewName) {
        String text = this.transformText(this.getCAS().getView(viewName).getDocumentText());
        this.getStore().set(text);
        this.getTracker().set(text);
        ((DocumentUimaImpl)this.mDocument).switchView(viewName);
    }

    @Override
    public String getTypeSystemText() {
        if (this.mDocument != null) {
            return this.mDocument.getTypeSystemText();
        }
        return null;
    }
}

